/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.att.controller;

import com.zkteco.zkbiosecurity.att.remote.AttWorkTimeReportRemote;
import com.zkteco.zkbiosecurity.att.service.AttRecordService;
import com.zkteco.zkbiosecurity.att.vo.AttWorkTimeReportItem;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.SecuritySubject;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AttWorkTimeReportController
extends ExportController
implements AttWorkTimeReportRemote {
    @Autowired
    private AttRecordService attRecordService;

    @RequiresPermissions(value={"att:workTimeReport"})
    public ModelAndView index() {
        SecuritySubject securitySubject = this.getCurrentSubject();
        Boolean staff = securitySubject.getStaff();
        this.request.setAttribute("staff", (Object)staff);
        return new ModelAndView("att/report/attWorkTime");
    }

    @RequiresPermissions(value={"att:workTimeReport:refresh"})
    public DxGrid list(AttWorkTimeReportItem condition) {
        Pager pager = this.attRecordService.getWorkTimeReportPager(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"att:workTimeReport:export"})
    @LogRequest(module="att_module", object="att_leftMenu_workTimeReport", opType="common_op_export", requestParams={"exportType"}, opContent="common_report_fileType")
    public void export(HttpServletRequest request, HttpServletResponse response) {
        AttWorkTimeReportItem attWorkTimeReportItem = new AttWorkTimeReportItem();
        this.setConditionValue((BaseItem)attWorkTimeReportItem);
        List itemList = this.attRecordService.getWorkTimeReportItemData(request.getSession().getId(), attWorkTimeReportItem, this.getBeginIndex(), this.getEndIndex());
        this.excelExport(itemList, AttWorkTimeReportItem.class);
    }
}

