/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.att.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.att.remote.AttFlowableRemote;
import com.zkteco.zkbiosecurity.att.service.AttFlowableService;
import com.zkteco.zkbiosecurity.att.service.AttPersonService;
import com.zkteco.zkbiosecurity.att.service.AttWorkflowService;
import com.zkteco.zkbiosecurity.att.vo.AttAdjustItem;
import com.zkteco.zkbiosecurity.att.vo.AttClassItem;
import com.zkteco.zkbiosecurity.att.vo.AttLeaveItem;
import com.zkteco.zkbiosecurity.att.vo.AttOutItem;
import com.zkteco.zkbiosecurity.att.vo.AttOvertimeItem;
import com.zkteco.zkbiosecurity.att.vo.AttPersonItem;
import com.zkteco.zkbiosecurity.att.vo.AttProcessInfoItem;
import com.zkteco.zkbiosecurity.att.vo.AttSignItem;
import com.zkteco.zkbiosecurity.att.vo.AttTripItem;
import com.zkteco.zkbiosecurity.auth.service.AuthSessionServcie;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.SecuritySubject;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.FileUtil;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.system.service.BaseMessageService;
import java.util.Date;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AttFlowableController
extends BaseController
implements AttFlowableRemote {
    @Autowired
    private AttFlowableService attFlowableService;
    @Autowired
    private AttPersonService attPersonService;
    @Autowired
    private AttWorkflowService attWorkflowService;
    @Autowired
    private BaseMessageService baseMessageService;
    @Autowired
    private AuthSessionServcie authSessionServcie;

    public ModelAndView index() {
        return null;
    }

    public ModelAndView myApply() {
        SecuritySubject securitySubject = this.getCurrentSubject();
        Boolean staff = securitySubject.getStaff();
        AttPersonItem attPersonItem = this.attPersonService.getItemByPersonPin(securitySubject.getUserCode());
        if (Objects.nonNull(attPersonItem)) {
            staff = true;
        }
        this.request.setAttribute("staff", (Object)staff);
        return new ModelAndView("/att/flowable/myApply");
    }

    public ModelAndView pendingTask() {
        SecuritySubject securitySubject = this.getCurrentSubject();
        Boolean staff = securitySubject.getStaff();
        AttPersonItem attPersonItem = this.attPersonService.getItemByPersonPin(securitySubject.getUserCode());
        if (Objects.nonNull(attPersonItem)) {
            staff = true;
        }
        this.request.setAttribute("staff", (Object)staff);
        return new ModelAndView("/att/flowable/pendingTask");
    }

    public ModelAndView approvedTask() {
        SecuritySubject securitySubject = this.getCurrentSubject();
        Boolean staff = securitySubject.getStaff();
        AttPersonItem attPersonItem = this.attPersonService.getItemByPersonPin(securitySubject.getUserCode());
        if (Objects.nonNull(attPersonItem)) {
            staff = true;
        }
        this.request.setAttribute("staff", (Object)staff);
        return new ModelAndView("/att/flowable/approvedTask");
    }

    public DxGrid myApplyList(AttProcessInfoItem condition) {
        Pager pager = this.attFlowableService.findMyApplyList(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public DxGrid pendingTaskList(AttProcessInfoItem condition) {
        Pager pager = this.attFlowableService.findPendingTaskList(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public DxGrid approvedTaskList(AttProcessInfoItem condition) {
        Pager pager = this.attFlowableService.findApprovedTaskList(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public ZKResultMsg startSign(AttSignItem attSignItem) {
        ZKResultMsg zkResultMsg = new ZKResultMsg();
        attSignItem.setPersonPin(this.getCurrentSubject().getUserCode());
        this.attFlowableService.startSign(attSignItem);
        return zkResultMsg;
    }

    public ZKResultMsg startLeave(AttLeaveItem attLeaveItem) {
        ZKResultMsg zkResultMsg = new ZKResultMsg();
        attLeaveItem.setPersonPin(this.getCurrentSubject().getUserCode());
        this.attFlowableService.startLeave(attLeaveItem);
        return zkResultMsg;
    }

    public ZKResultMsg startOvertime(AttOvertimeItem attOvertimeItem) {
        ZKResultMsg zkResultMsg = new ZKResultMsg();
        attOvertimeItem.setPersonPin(this.getCurrentSubject().getUserCode());
        this.attFlowableService.startOvertime(attOvertimeItem);
        return zkResultMsg;
    }

    public ZKResultMsg startOut(AttOutItem attOutItem) {
        ZKResultMsg zkResultMsg = new ZKResultMsg();
        attOutItem.setPersonPin(this.getCurrentSubject().getUserCode());
        this.attFlowableService.startOut(attOutItem);
        return zkResultMsg;
    }

    public ZKResultMsg startTrip(AttTripItem attTripItem) {
        ZKResultMsg zkResultMsg = new ZKResultMsg();
        attTripItem.setPersonPin(this.getCurrentSubject().getUserCode());
        this.attFlowableService.startTrip(attTripItem);
        return zkResultMsg;
    }

    public ZKResultMsg startClass(AttClassItem attClassItem) {
        this.attFlowableService.startClass(attClassItem);
        return new ZKResultMsg();
    }

    public ZKResultMsg startAdjust(AttAdjustItem attAdjustItem) {
        this.attFlowableService.startAdjust(attAdjustItem);
        return new ZKResultMsg();
    }

    public ZKResultMsg attachment(MultipartFile file) {
        ZKResultMsg zkResultMsg = new ZKResultMsg();
        String filePath = null;
        if (Objects.nonNull(file) && !file.isEmpty()) {
            Date date = new Date();
            filePath = FileUtil.saveFileToServer((String)"att", (String)"leave/image", (String)(date.getTime() + ".jpg"), (MultipartFile)file);
        }
        zkResultMsg.setData(filePath);
        return zkResultMsg;
    }

    public ZKResultMsg complete(String taskId, String pass, String comment, String notifierPerIds) {
        ZKResultMsg zkResultMsg = new ZKResultMsg();
        String personPin = this.getPersonPin();
        this.attWorkflowService.completeTask(personPin, taskId, pass, comment, notifierPerIds);
        this.baseMessageService.saveTodoMsgRead(personPin, taskId);
        return zkResultMsg;
    }

    private String getPersonPin() {
        SecuritySubject securitySubject = this.getCurrentSubject();
        return securitySubject.getUserCode();
    }

    public ZKResultMsg cancelApply(String businessKey, String revokeReason) {
        SecuritySubject securitySubject = this.authSessionServcie.getSecuritySubject(this.request.getSession().getId());
        if (securitySubject != null) {
            ZKResultMsg resultMsg = this.attWorkflowService.revokeProcess(businessKey, securitySubject.getUserCode(), revokeReason);
            if (resultMsg != null && "ok".equals(resultMsg.getRet()) && resultMsg.getData() != null) {
                JSONObject data = JSONObject.parseObject((String)JSON.toJSONString((Object)resultMsg.getData()));
                String personPin = data.getString("pin");
                String processTaskId = data.getString("taskId");
                this.baseMessageService.saveTodoMsgRead(personPin, processTaskId);
            }
            return resultMsg;
        }
        return ZKResultMsg.failMsg();
    }

    public ZKResultMsg isCanOpenFlowable() {
        ZKResultMsg result = new ZKResultMsg();
        SecuritySubject securitySubject = this.authSessionServcie.getSecuritySubject(this.request.getSession().getId());
        if ("PERS".equals(securitySubject.getLoginType()) || securitySubject.getIsSuperuser().booleanValue()) {
            result.setData((Object)true);
            return result;
        }
        result.setData((Object)false);
        result.setMsg("att_flowable_noAuth");
        return I18nUtil.i18nMsg((ZKResultMsg)result);
    }
}

