/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.att.app.controller;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.att.service.AttAppService;
import com.zkteco.zkbiosecurity.att.service.AttMonthStatisticalReportService;
import com.zkteco.zkbiosecurity.att.service.AttParamService;
import com.zkteco.zkbiosecurity.att.utils.AttDateUtils;
import com.zkteco.zkbiosecurity.att.vo.AttMonthStatisticalReportItem;
import com.zkteco.zkbiosecurity.base.vo.AppResultMessage;
import java.math.BigDecimal;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/app/v1"})
public class AttAppController {
    @Autowired
    private AttAppService attAppService;
    @Autowired
    private AttParamService attParamService;
    @Autowired
    private AttMonthStatisticalReportService attMonthStatisticalReportService;

    @RequestMapping(value={"/monthlyStatistics"}, method={RequestMethod.POST})
    public JSONObject monthlyStatistics(@RequestBody JSONObject jsonObject) {
        JSONObject returnObject = new JSONObject();
        String pin = jsonObject.getString("pin");
        String date = jsonObject.getString("date");
        String[] dateArray = date.split("-");
        int year = Integer.parseInt(dateArray[0]);
        int month = Integer.parseInt(dateArray[1]);
        Date startDate = AttDateUtils.getFirstDayOfMonth((int)year, (int)month);
        Date endDate = AttDateUtils.getLastDayOfMonth((int)year, (int)month);
        AttMonthStatisticalReportItem item = this.attMonthStatisticalReportService.getItemByPinAndDate(pin, startDate, endDate);
        JSONObject attendanceObject = new JSONObject();
        attendanceObject.put("shouldHour", (Object)(item != null && StringUtils.isNotBlank((CharSequence)item.getShouldHour()) ? item.getShouldHour() : "0"));
        attendanceObject.put("actualHour", (Object)(item != null && StringUtils.isNotBlank((CharSequence)item.getActualHour()) ? item.getActualHour() : "0"));
        attendanceObject.put("validHour", (Object)(item != null && StringUtils.isNotBlank((CharSequence)item.getValidHour()) ? item.getValidHour() : "0"));
        returnObject.put("attendanceData", (Object)attendanceObject);
        JSONObject lateObject = new JSONObject();
        String lateMinute = item != null && StringUtils.isNotBlank((CharSequence)item.getLateMinute()) ? item.getLateMinute() : "0";
        lateObject.put("lateHour", (Object)this.attParamService.minutesToHourFormat(new BigDecimal(lateMinute)));
        lateObject.put("lateCount", (Object)(item != null && StringUtils.isNotBlank((CharSequence)item.getLateCountTotal()) ? item.getLateCountTotal() : "0"));
        returnObject.put("lateData", (Object)lateObject);
        JSONObject earlyObject = new JSONObject();
        String earlyMinute = item != null && StringUtils.isNotBlank((CharSequence)item.getEarlyMinute()) ? item.getEarlyMinute() : "0";
        earlyObject.put("earlyHour", (Object)this.attParamService.minutesToHourFormat(new BigDecimal(earlyMinute)));
        earlyObject.put("earlyCount", (Object)(item != null && StringUtils.isNotBlank((CharSequence)item.getEarlyCount()) ? item.getEarlyCount() : "0"));
        returnObject.put("earlyData", (Object)earlyObject);
        JSONObject overtimeObject = new JSONObject();
        overtimeObject.put("usualHour", (Object)(item != null && StringUtils.isNotBlank((CharSequence)item.getOvertimeUsualHour()) ? item.getOvertimeUsualHour() : "0"));
        overtimeObject.put("restHour", (Object)(item != null && StringUtils.isNotBlank((CharSequence)item.getOvertimeRestHour()) ? item.getOvertimeRestHour() : "0"));
        overtimeObject.put("holidayHour", (Object)(item != null && StringUtils.isNotBlank((CharSequence)item.getOvertimeHolidayHour()) ? item.getOvertimeHolidayHour() : "0"));
        overtimeObject.put("totalHour", (Object)(item != null && StringUtils.isNotBlank((CharSequence)item.getOvertimeHour()) ? item.getOvertimeHour() : "0"));
        returnObject.put("overtimeData", (Object)overtimeObject);
        JSONObject exceptionObject = new JSONObject();
        exceptionObject.put("absentHour", (Object)(item != null && StringUtils.isNotBlank((CharSequence)item.getAbsentHour()) ? item.getAbsentHour() : "0"));
        exceptionObject.put("leaveHour", (Object)(item != null && StringUtils.isNotBlank((CharSequence)item.getLeaveHour()) ? item.getLeaveHour() : "0"));
        exceptionObject.put("tripHour", (Object)(item != null && StringUtils.isNotBlank((CharSequence)item.getTripHour()) ? item.getTripHour() : "0"));
        exceptionObject.put("outHour", (Object)(item != null && StringUtils.isNotBlank((CharSequence)item.getOutHour()) ? item.getOutHour() : "0"));
        returnObject.put("exceptionData", (Object)exceptionObject);
        return returnObject;
    }

    @RequestMapping(value={"/monthlyAttendanceCalendar"}, method={RequestMethod.POST})
    public AppResultMessage monthlyAttendanceCalendar(@RequestBody JSONObject jsonObject) {
        String pin = jsonObject.getString("pin");
        String date = jsonObject.getString("time");
        return this.attAppService.getAttendanceCalendar(pin, date);
    }
}

