/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.att.api.controller;

import com.alibaba.fastjson.JSON;
import com.zkteco.zkbiosecurity.att.api.vo.AttApiDayDetailReportItem;
import com.zkteco.zkbiosecurity.att.api.vo.AttApiQueryRecordItem;
import com.zkteco.zkbiosecurity.att.service.AttMonthStatisticalReportService;
import com.zkteco.zkbiosecurity.att.service.AttRecordService;
import com.zkteco.zkbiosecurity.att.service.AttRuleService;
import com.zkteco.zkbiosecurity.att.vo.AttMonthStatisticalReportItem;
import com.zkteco.zkbiosecurity.att.vo.AttRecordItem;
import com.zkteco.zkbiosecurity.base.annotation.ApiPermissions;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.DateUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.message.bean.ZKMessage;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/attRecord"})
public class AttApiRecordController {
    @Autowired
    private AttRecordService attRecordService;
    @Autowired
    private AttMonthStatisticalReportService attMonthStatisticalReportService;
    @Autowired
    private AttRuleService attRuleService;

    @ApiPermissions(moduleCode="att", moduleName="att_module")
    @RequestMapping(path={"/getRecordByPinAndData"}, method={RequestMethod.POST}, produces={"application/json"})
    public ZKResultMsg getRecordByPinAndData(@RequestBody ZKMessage message) {
        Map data = message.getContent();
        String personPin = MapUtils.getString((Map)data, (Object)"pin");
        String startTime = MapUtils.getString((Map)data, (Object)"startTime");
        String endTime = MapUtils.getString((Map)data, (Object)"endTime");
        Date startDate = DateUtil.stringToDate((String)startTime);
        Date endDate = DateUtil.stringToDate((String)endTime);
        if (startDate == null || endDate == null) {
            return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.failMsg((String)"common_dsTime_timeValid2", (Object[])new Object[0]));
        }
        if (startDate.getTime() > endDate.getTime()) {
            return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.failMsg((String)"common_dsTime_timeValid4", (Object[])new Object[0]));
        }
        AttRecordItem attRecordItem = new AttRecordItem();
        if (StringUtils.isNotBlank((CharSequence)personPin)) {
            attRecordItem.setInPersonPin(personPin);
        }
        attRecordItem.setStartDate(startDate);
        attRecordItem.setEndDate(endDate);
        attRecordItem.equals(true);
        List attRecordItems = this.attRecordService.getByCondition(attRecordItem);
        ZKResultMsg resultMsg = ZKResultMsg.successMsg();
        resultMsg.setData((Object)attRecordItems);
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }

    @ApiPermissions(moduleCode="att", moduleName="att_module")
    @RequestMapping(path={"/getRecordPage"}, method={RequestMethod.POST}, produces={"application/json"})
    public ZKResultMsg getRecordPage(@RequestBody ZKMessage message) {
        Map data = message.getContent();
        ZKResultMsg resultMsg = ZKResultMsg.successMsg();
        if (data.containsKey("attRecord")) {
            AttApiQueryRecordItem attApiQueryRecordItem = (AttApiQueryRecordItem)JSON.parseObject((String)JSON.toJSONString(data.get("attRecord")), AttApiQueryRecordItem.class);
            AttRecordItem attRecordItem = new AttRecordItem();
            attRecordItem.setStartDate(attApiQueryRecordItem.getAttDateStart());
            attRecordItem.setEndDate(attApiQueryRecordItem.getAttDateEnd());
            attRecordItem.setInPersonPin(attApiQueryRecordItem.getInPin());
            Integer page = MapUtils.getInteger((Map)data, (Object)"page");
            Integer pageSize = MapUtils.getInteger((Map)data, (Object)"pageSize");
            Pager pager = this.attRecordService.getItemsByPage((BaseItem)attRecordItem, page.intValue(), pageSize.intValue());
            resultMsg.setData((Object)pager);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }

    @ApiPermissions(moduleCode="att", moduleName="att_module")
    @RequestMapping(path={"/getMonthStatisticalReport"}, method={RequestMethod.POST}, produces={"application/json"})
    public ZKResultMsg getMonthStatisticalReport(@RequestBody ZKMessage message) {
        Map data = message.getContent();
        String pin = MapUtils.getString((Map)data, (Object)"pin");
        String monthStart = MapUtils.getString((Map)data, (Object)"monthStart");
        String monthEnd = MapUtils.getString((Map)data, (Object)"monthEnd");
        Date monthStartDate = DateUtil.stringToDate((String)monthStart);
        Date monthEndDate = DateUtil.stringToDate((String)monthEnd);
        if (StringUtils.isBlank((CharSequence)pin)) {
            return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.failMsg((String)"pers_import_pinNotEmpty", (Object[])new Object[0]));
        }
        if (monthStartDate == null || monthEndDate == null) {
            return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.failMsg((String)"common_dsTime_timeValid2", (Object[])new Object[0]));
        }
        if (monthStartDate.getTime() > monthEndDate.getTime()) {
            return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.failMsg((String)"common_dsTime_timeValid4", (Object[])new Object[0]));
        }
        ZKResultMsg resultMsg = ZKResultMsg.successMsg();
        AttMonthStatisticalReportItem attMonthStatisticalReportItem = this.attMonthStatisticalReportService.getItemByPinAndDate(pin, monthStartDate, monthEndDate);
        resultMsg.setData((Object)attMonthStatisticalReportItem);
        return resultMsg;
    }

    @ApiPermissions(moduleCode="att", moduleName="att_module")
    @RequestMapping(path={"/getPersonDetailReport"}, method={RequestMethod.POST}, produces={"application/json"})
    public ZKResultMsg getPersonDetailReport(@RequestBody ZKMessage message) {
        Map data = message.getContent();
        String pin = MapUtils.getString((Map)data, (Object)"pin");
        String dayStart = MapUtils.getString((Map)data, (Object)"startTime");
        String dayEnd = MapUtils.getString((Map)data, (Object)"endTime");
        Date dayStartDate = DateUtil.stringToDate((String)dayStart);
        Date dayEndDate = DateUtil.stringToDate((String)dayEnd);
        if (StringUtils.isBlank((CharSequence)pin)) {
            return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.failMsg((String)"pers_import_pinNotEmpty", (Object[])new Object[0]));
        }
        if (dayStartDate == null || dayEndDate == null) {
            return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.failMsg((String)"common_dsTime_timeValid2", (Object[])new Object[0]));
        }
        if (dayStartDate.getTime() > dayEndDate.getTime()) {
            return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.failMsg((String)"common_dsTime_timeValid4", (Object[])new Object[0]));
        }
        ZKResultMsg resultMsg = ZKResultMsg.successMsg();
        AttApiDayDetailReportItem attDayDetailReportItem = this.attRecordService.getPersonDetailReport(pin, dayStartDate, dayEndDate);
        resultMsg.setData((Object)attDayDetailReportItem);
        return resultMsg;
    }
}

