/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.park.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.park.constants.ParkConstants;
import com.zkteco.zkbiosecurity.park.remote.ParkParkingSpaceRemote;
import com.zkteco.zkbiosecurity.park.service.ParkCloudService;
import com.zkteco.zkbiosecurity.park.service.ParkParamsService;
import com.zkteco.zkbiosecurity.park.service.ParkParkingAreaService;
import com.zkteco.zkbiosecurity.park.service.ParkParkingSpaceService;
import com.zkteco.zkbiosecurity.park.vo.ParkParkingSpaceItem;
import com.zkteco.zkbiosecurity.park.vo.ParkParkingSpaceSelectItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class ParkParkingSpaceController
extends BaseController
implements ParkParkingSpaceRemote {
    @Autowired
    private ParkParkingSpaceService parkParkingSpaceService;
    @Autowired
    private ParkParamsService parkParamsService;
    @Autowired
    private ParkParkingAreaService parkingAreaService;
    @Autowired
    private ParkCloudService parkCloudService;

    @RequiresPermissions(value={"park:parkingSpace"})
    public ModelAndView index() {
        return new ModelAndView("park/parkingSpace/parkParkingSpace");
    }

    @RequiresPermissions(value={"park:parkingSpace:add"})
    @LogRequest(module="park_module", object="park_parkingSpace", opType="park_parkingSpace_add", requestParams={"prefix", "start", "total"}, opContent="park_parkingSpace_spaceName")
    public ZKResultMsg save(ParkParkingSpaceItem item) {
        this.parkParkingSpaceService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public DxGrid list(ParkParkingSpaceItem codition) {
        Pager pager = this.parkParkingSpaceService.getItemsByPage((BaseItem)codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @RequiresPermissions(value={"park:parkingSpace:del"})
    @LogRequest(module="park_module", object="park_parkingSpace", opType="park_parkingSpace_del", requestParams={"names"}, opContent="park_parkingSpace_del")
    public ZKResultMsg delete(@RequestParam(value="ids") String ids) {
        this.parkParkingSpaceService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public DxGrid getSelectList(ParkParkingSpaceSelectItem codition) {
        Pager pager = this.parkParkingSpaceService.getSelectList(codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    public ZKResultMsg getCountByAreaIdAndUnused(@RequestParam(value="parkingAreaId", required=false) String parkingAreaId) {
        return new ZKResultMsg((Object)this.parkParkingSpaceService.getCountByAreaIdAndStatus(parkingAreaId, ParkConstants.PARKINGSPACE_UNUSED));
    }

    public ZKResultMsg getRandomParkingSpace(@RequestParam(value="parkingAreaId", required=false) String parkingAreaId, @RequestParam(value="editIds", required=false) String editIds) {
        return new ZKResultMsg((Object)this.parkParkingSpaceService.getRandomParkingSpace(parkingAreaId, editIds));
    }
}

