/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.park.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.park.remote.ParkDeviceOpRecordRemote;
import com.zkteco.zkbiosecurity.park.service.ParkDeviceOpRecordService;
import com.zkteco.zkbiosecurity.park.vo.ParkDeviceOpRecordItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class ParkDeviceOpRecordController
extends BaseController
implements ParkDeviceOpRecordRemote {
    @Autowired
    private ParkDeviceOpRecordService parkDeviceOpRecordService;

    @RequiresPermissions(value={"park:deviceOpRecord"})
    public ModelAndView index() {
        return new ModelAndView("park/deviceOpRecord/parkDeviceOpRecord");
    }

    public DxGrid list(ParkDeviceOpRecordItem codition) {
        codition.setOpRet(null);
        Pager pager = this.parkDeviceOpRecordService.getItemsByPage((BaseItem)codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @RequiresPermissions(value={"park:deviceOpRecord:del"})
    @LogRequest(module="park_module", object="park_deviceOpRecord", opType="park_deviceOpRecord_del", requestParams={"names"}, opContent="park_deviceOpRecord_del")
    public ZKResultMsg delete(@RequestParam(value="ids") String ids) {
        this.parkDeviceOpRecordService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }
}

