/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.park.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.TreeItem;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.park.remote.ParkCarTypeRemote;
import com.zkteco.zkbiosecurity.park.service.ParkCarTypeService;
import com.zkteco.zkbiosecurity.park.vo.ParkCarTypeItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class ParkCarTypeController
extends BaseController
implements ParkCarTypeRemote {
    @Autowired
    private ParkCarTypeService parkCarTypeService;

    @RequiresPermissions(value={"park:carType"})
    public ModelAndView index() {
        return new ModelAndView("park/carType/parkCarType");
    }

    @RequiresPermissions(value={"park:carType:add"})
    public ModelAndView edit(@RequestParam(value="id", required=false) String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.parkCarTypeService.getItemById(id));
        }
        return new ModelAndView("park/carType/editParkCarType");
    }

    @RequiresPermissions(value={"park:carType:edit"})
    @LogRequest(module="park_module", object="park_carType", opType="park_carType_edit", requestParams={"name"}, opContent="park_carType_name")
    public ZKResultMsg save(ParkCarTypeItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.parkCarTypeService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    public DxGrid list(ParkCarTypeItem codition) {
        Pager pager = this.parkCarTypeService.getItemsByPage((BaseItem)codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @RequiresPermissions(value={"park:carType:del"})
    @LogRequest(module="park_module", object="park_carType", opType="park_carType_del", requestParams={"names"}, opContent="park_carType_del")
    public ZKResultMsg delete(@RequestParam(value="ids") String ids) {
        this.parkCarTypeService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public boolean isNotExist(@RequestParam(value="name", required=false) String name) {
        return this.parkCarTypeService.isNotExist(name);
    }

    public TreeItem getTreeByDisplayParkingSpace(@RequestParam(value="displayParkingSpace") String displayParkingSpace) {
        return this.parkCarTypeService.getTreeByDisplayParkingSpace(Boolean.valueOf(displayParkingSpace).booleanValue());
    }

    public ZKResultMsg getTypeSelectByFilter(@RequestParam(value="filter") String filter) {
        List selectItems = this.parkCarTypeService.getTypeSelectByFilter(filter);
        return new ZKResultMsg((Object)selectItems);
    }

    public ZKResultMsg getEnableFixType() {
        List selectItems = this.parkCarTypeService.getEnableFixType();
        return new ZKResultMsg((Object)selectItems);
    }

    public ZKResultMsg getEnableFixTypeEX() {
        List selectItems = this.parkCarTypeService.getEnableFixTypeEx();
        return new ZKResultMsg((Object)selectItems);
    }

    public ZKResultMsg getForTemporaryCharge(@RequestParam(value="editId", required=false) String editId) {
        List selectItems = this.parkCarTypeService.getForTemporaryCharge(editId);
        return new ZKResultMsg((Object)selectItems);
    }

    public ZKResultMsg getExistTemporaryCharge() {
        List selectItems = this.parkCarTypeService.getExistTemporaryCharge();
        return new ZKResultMsg((Object)selectItems);
    }

    public ZKResultMsg getExistOverTimeCharge() {
        List selectItems = this.parkCarTypeService.getExistOverTimeCharge();
        return new ZKResultMsg((Object)selectItems);
    }
}

