/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.park.api.controller;

import com.zkteco.zkbiosecurity.base.vo.ApiResultMessage;
import com.zkteco.zkbiosecurity.core.utils.DateUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.park.constants.ParkConstants;
import com.zkteco.zkbiosecurity.park.service.ParkBlackWhiteService;
import com.zkteco.zkbiosecurity.park.service.ParkCarNumberService;
import com.zkteco.zkbiosecurity.park.vo.ParkBlackWhiteItem;
import io.swagger.annotations.Api;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/parkAuthorize"})
@Api(tags={"ParkAuthorize"}, description="park authorize")
public class ParkApiAuthorizeController {
    private static final Logger log = LoggerFactory.getLogger(ParkApiAuthorizeController.class);
    @Autowired
    private ParkBlackWhiteService parkBlackWhiteService;
    @Autowired
    private ParkCarNumberService parkCarNumberService;

    @ResponseBody
    @RequestMapping(value={"/addBlackWhite"}, method={RequestMethod.POST}, produces={"application/json"})
    public ApiResultMessage addBlackWhite(@RequestParam String type, @RequestParam String carNumber, @RequestParam(required=false) String fromTime, @RequestParam(required=false) String toTime) {
        ApiResultMessage rm = null;
        try {
            ParkBlackWhiteItem parkBlackWhiteItem = this.parkBlackWhiteService.getItemByCarNumber(carNumber);
            if (parkBlackWhiteItem != null) {
                return ApiResultMessage.message((int)-224, (String)I18nUtil.i18nCode((String)"park_api_balckWhiteExists", (Object[])new Object[0]));
            }
            rm = this.operaBlackWhite(new ParkBlackWhiteItem(), carNumber, type, fromTime, toTime);
        }
        catch (Exception e) {
            log.error("api parkAuthorize/addBlackWhite error", (Throwable)e);
            rm = ApiResultMessage.message((int)-1, (String)I18nUtil.i18nCode((String)"common_api_programError", (Object[])new Object[0]));
        }
        return rm;
    }

    @ResponseBody
    @RequestMapping(value={"/delBlackWhite"}, method={RequestMethod.POST}, produces={"application/json"})
    public ApiResultMessage delBlackWhite(@RequestParam String carNumber) {
        ApiResultMessage rm = ApiResultMessage.successMessage();
        try {
            if (!this.parkCarNumberService.validCarNumber(carNumber)) {
                return ApiResultMessage.message((int)-223, (String)I18nUtil.i18nCode((String)"park_api_wrongCarNumber", (Object[])new Object[0]));
            }
            ParkBlackWhiteItem parkBlackWhiteItem = this.parkBlackWhiteService.getItemByCarNumber(carNumber);
            if (parkBlackWhiteItem == null) {
                return ApiResultMessage.message((int)-225, (String)I18nUtil.i18nCode((String)"park_api_balckWhiteNotExists", (Object[])new Object[0]));
            }
            this.parkBlackWhiteService.delByIds(parkBlackWhiteItem.getId());
        }
        catch (Exception e) {
            log.error("api parkAuthorize/delBlackWhite error", (Throwable)e);
            rm = ApiResultMessage.message((int)-1, (String)I18nUtil.i18nCode((String)"common_api_programError", (Object[])new Object[0]));
        }
        return rm;
    }

    @ResponseBody
    @RequestMapping(value={"/editBlackWhite"}, method={RequestMethod.POST}, produces={"application/json"})
    public ApiResultMessage editBlackWhite(@RequestParam String type, @RequestParam String carNumber, @RequestParam String oldCarNumber, @RequestParam(required=false) String fromTime, @RequestParam(required=false) String toTime) {
        ApiResultMessage rm = null;
        try {
            ParkBlackWhiteItem parkBlackWhiteItem = this.parkBlackWhiteService.getItemByCarNumber(oldCarNumber);
            if (parkBlackWhiteItem == null) {
                return ApiResultMessage.message((int)-225, (String)I18nUtil.i18nCode((String)"park_api_balckWhiteNotExists", (Object[])new Object[0]));
            }
            rm = this.operaBlackWhite(parkBlackWhiteItem, carNumber, type, fromTime, toTime);
        }
        catch (Exception e) {
            log.error("api parkAuthorize/editBlackWhite error", (Throwable)e);
            rm = new ApiResultMessage(-1, I18nUtil.i18nCode((String)"common_api_programError", (Object[])new Object[0]));
        }
        return rm;
    }

    private ApiResultMessage operaBlackWhite(ParkBlackWhiteItem parkBlackWhiteItem, String carNumber, String type, String fromTime, String toTime) {
        String carArea = "";
        carArea = carNumber.startsWith("WJ") ? carNumber.substring(0, 2) : carNumber.substring(0, 1);
        String number = carNumber.substring(carArea.length(), carNumber.length());
        if (!this.parkCarNumberService.validCarNumber(carNumber)) {
            return ApiResultMessage.message((int)-223, (String)I18nUtil.i18nCode((String)"park_api_wrongCarNumber", (Object[])new Object[0]));
        }
        parkBlackWhiteItem.setCarArea(carArea);
        parkBlackWhiteItem.setNumber(number);
        parkBlackWhiteItem.setCarNumber(carNumber);
        if (ParkConstants.OPEN_TYPE_WHITE.toString().equals(type)) {
            if (StringUtils.isBlank((CharSequence)fromTime) || StringUtils.isBlank((CharSequence)toTime)) {
                return ApiResultMessage.message((int)-227, (String)I18nUtil.i18nCode((String)"park_api_emptyTime", (Object[])new Object[0]));
            }
            Date fromDate = DateUtil.stringToDate((String)fromTime, (DateUtil.DateStyle)DateUtil.DateStyle.YYYY_MM_DD);
            Date toDate = DateUtil.stringToDate((String)toTime, (DateUtil.DateStyle)DateUtil.DateStyle.YYYY_MM_DD);
            if (fromDate == null || toDate == null || fromDate.getTime() > toDate.getTime()) {
                return ApiResultMessage.message((int)-222, (String)I18nUtil.i18nCode((String)"park_api_wrongTime", (Object[])new Object[0]));
            }
            parkBlackWhiteItem.setStartTime(fromDate);
            parkBlackWhiteItem.setEndTime(toDate);
        } else if (!ParkConstants.OPEN_TYPE_BLACK.toString().equals(type)) {
            return ApiResultMessage.message((int)-221, (String)I18nUtil.i18nCode((String)"park_api_wrongType", (Object[])new Object[0]));
        }
        parkBlackWhiteItem.setState(Short.valueOf(Short.parseShort(type)));
        List parkDeviceOpRecordItemList = (List)this.parkBlackWhiteService.saveItem(parkBlackWhiteItem).getData();
        if (parkDeviceOpRecordItemList.isEmpty()) {
            return ApiResultMessage.message((int)-226, (String)I18nUtil.i18nCode((String)"park_api_sendDeviceError", (Object[])new Object[0]));
        }
        return ApiResultMessage.successMessage();
    }
}

