/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ele.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.ProcessBean;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.cache.ProgressCache;
import com.zkteco.zkbiosecurity.ele.remote.EleLevelRemote;
import com.zkteco.zkbiosecurity.ele.service.EleDeviceService;
import com.zkteco.zkbiosecurity.ele.service.EleFloorService;
import com.zkteco.zkbiosecurity.ele.service.EleLevelService;
import com.zkteco.zkbiosecurity.ele.vo.EleDeptLevelItem;
import com.zkteco.zkbiosecurity.ele.vo.EleDeptSelectLevelItem;
import com.zkteco.zkbiosecurity.ele.vo.EleLevelItem;
import com.zkteco.zkbiosecurity.ele.vo.EleLevelSelectFloorItem;
import com.zkteco.zkbiosecurity.ele.vo.ElePersonLevelItem;
import com.zkteco.zkbiosecurity.ele.vo.ElePersonSelectLevelItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class EleLevelController
extends BaseController
implements EleLevelRemote {
    @Autowired
    private EleLevelService eleLevelService;
    @Autowired
    private EleDeviceService eleDeviceService;
    @Autowired
    private EleFloorService eleFloorService;
    @Autowired
    private ProgressCache progressCache;

    @RequiresPermissions(value={"ele:level"})
    public ModelAndView index() {
        return new ModelAndView("ele/level/eleLevel");
    }

    @RequiresPermissions(value={"ele:level:add", "ele:level:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("personCount", (Object)this.eleLevelService.getLevelPersonCount(id));
            this.request.setAttribute("item", (Object)this.eleLevelService.getItemById(id));
        }
        return new ModelAndView("ele/level/editEleLevel");
    }

    @RequiresPermissions(value={"ele:level:add", "ele:level:edit"})
    @LogRequest(module="ele_module", object="ele_leftMenu_level", opType="common_op_edit", requestParams={"name"}, opContent="common_level_name")
    public ZKResultMsg save(EleLevelItem item) {
        ZKResultMsg res = new ZKResultMsg();
        String levelId = (item = this.eleLevelService.saveItem(item)).getId();
        if (StringUtils.isNotBlank((CharSequence)levelId)) {
            this.eleLevelService.syncTimeSegVisLevelToDev(levelId);
            if (item.getChangeLevel() != null && item.getChangeLevel().booleanValue()) {
                List personIdList = this.eleLevelService.getPersonIdsByLevelId(levelId);
                List deviceIdList = this.eleLevelService.getDevIdsByLevelId(levelId);
                ArrayList tempPersonIdList = new ArrayList();
                int devSize = deviceIdList.size();
                for (int i = 0; i < devSize; ++i) {
                    int total = (int)((double)i * 100.0 / (double)devSize);
                    total = total == 100 ? 99 : total;
                    int personSize = personIdList.size();
                    for (int j = 0; j < personSize; ++j) {
                        tempPersonIdList.add(personIdList.get(j));
                        if (tempPersonIdList.size() % 200 != 0) continue;
                        this.eleLevelService.syncTimeSegLevelToDev((String)deviceIdList.get(i), tempPersonIdList);
                        this.progressCache.setProcess(new ProcessBean((int)((double)j * 100.0 / (double)personSize), total, "", I18nUtil.i18nCode((String)"common_op_currProgress", (Object[])new Object[0])));
                        tempPersonIdList = new ArrayList();
                    }
                    if (tempPersonIdList.size() <= 0) continue;
                    this.eleLevelService.syncTimeSegLevelToDev((String)deviceIdList.get(i), tempPersonIdList);
                    this.progressCache.setProcess(new ProcessBean(100, total, "", I18nUtil.i18nCode((String)"common_op_currProgress", (Object[])new Object[0])));
                    tempPersonIdList = new ArrayList();
                }
            }
        }
        this.progressCache.finishProcess(I18nUtil.i18nCode((String)"common_progress_finish", (Object[])new Object[0]), "", I18nUtil.i18nCode((String)"common_op_currProgress", (Object[])new Object[0]));
        res.setData((Object)item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"ele:level:refresh"})
    public DxGrid list(EleLevelItem condition) {
        String authAreaIds = this.eleDeviceService.getAreaIdsByAuthFilter(this.request.getSession().getId());
        if (StringUtils.isNotBlank((CharSequence)authAreaIds)) {
            condition.setAuthAreaIdIn(authAreaIds);
        }
        Pager pager = this.eleLevelService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"ele:level:del"})
    @LogRequest(module="ele_module", object="ele_leftMenu_level", opType="common_op_del", requestParams={"names"}, opContent="common_level_name")
    public ZKResultMsg del(String ids) {
        ZKResultMsg resultMsg = new ZKResultMsg();
        if (StringUtils.isNotBlank((CharSequence)ids)) {
            ArrayList<String> levelIdList = new ArrayList<String>(Arrays.asList(ids.split(",")));
            EleLevelItem eleLevelItem = new EleLevelItem();
            eleLevelItem.setInitFlag(Boolean.valueOf(true));
            this.progressCache.beginProcess(I18nUtil.i18nCode((String)"common_op_startProcessing", (Object[])new Object[0]) + "<br/>", "", I18nUtil.i18nCode((String)"common_op_currProgress", (Object[])new Object[0]));
            ArrayList tempPersonIdList = new ArrayList();
            int levelSize = levelIdList.size();
            for (int i = 0; i < levelSize; ++i) {
                int total = (int)((double)i * 100.0 / (double)levelSize);
                total = total == 100 ? 99 : total;
                List personIdList = this.eleLevelService.getPersonIdsByLevelId((String)levelIdList.get(i));
                if (personIdList != null && personIdList.size() > 0) {
                    int personSize = personIdList.size();
                    for (int j = 0; j < personSize; ++j) {
                        tempPersonIdList.add(personIdList.get(j));
                        if (tempPersonIdList.size() % 200 != 0) continue;
                        this.eleLevelService.immeDelLevel((String)levelIdList.get(i), personIdList);
                        this.progressCache.setProcess(new ProcessBean((int)((double)j * 100.0 / (double)personSize), total, "", I18nUtil.i18nCode((String)"common_op_currProgress", (Object[])new Object[0])));
                        tempPersonIdList = new ArrayList();
                    }
                    if (tempPersonIdList.size() <= 0) continue;
                    this.eleLevelService.immeDelLevel((String)levelIdList.get(i), personIdList);
                    tempPersonIdList = new ArrayList();
                    this.progressCache.setProcess(new ProcessBean(100, total, "", I18nUtil.i18nCode((String)"common_op_currProgress", (Object[])new Object[0])));
                    continue;
                }
                this.eleLevelService.delEleLevelFloorByLevelId((String)levelIdList.get(i));
            }
            this.eleLevelService.deleteByIds(ids);
            this.progressCache.finishProcess(I18nUtil.i18nCode((String)"common_progress_finish", (Object[])new Object[0]) + "<br/>", "", I18nUtil.i18nCode((String)"common_op_currProgress", (Object[])new Object[0]));
        }
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }

    public DxGrid getPersonLevel(ElePersonLevelItem condition) {
        String authAreaIds = this.eleDeviceService.getAreaIdsByAuthFilter(this.request.getSession().getId());
        if (StringUtils.isNotBlank((CharSequence)authAreaIds)) {
            condition.setAuthAreaIdIn(authAreaIds);
        }
        Pager pager = this.eleLevelService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public DxGrid getPersonSelectLevel(ElePersonSelectLevelItem condition) {
        if (StringUtils.isBlank((CharSequence)condition.getSelectId())) {
            condition.setSelectId("-1");
        }
        ArrayList<String> selectLevelIds = new ArrayList<String>(Arrays.asList(condition.getSelectId().split(",")));
        if (condition.getType().equals("noSelected")) {
            StringBuilder notInLevelId = new StringBuilder();
            notInLevelId.append(StringUtils.join(selectLevelIds, (String)","));
            if (StringUtils.isNotBlank((CharSequence)condition.getNotInId())) {
                notInLevelId.append(",").append(condition.getNotInId());
            }
            condition.setNotInId(notInLevelId.toString());
        } else if (condition.getType().equals("selected")) {
            condition.setInId(StringUtils.join(selectLevelIds, (String)","));
        }
        condition.setFilterId(condition.getPersonId());
        String authAreaIds = this.eleDeviceService.getAreaIdsByAuthFilter(this.request.getSession().getId());
        if (StringUtils.isNotBlank((CharSequence)authAreaIds)) {
            condition.setAuthAreaIdIn(authAreaIds);
        }
        Pager pager = this.eleLevelService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public DxGrid getDeptSelectLevel(EleDeptSelectLevelItem condition) {
        Pager pager = null;
        if ("noSelected".equals(condition.getType())) {
            String authAreaIds;
            if (StringUtils.isNotBlank((CharSequence)condition.getSelectId())) {
                condition.setNotInId(condition.getSelectId());
            }
            if (StringUtils.isNotBlank((CharSequence)(authAreaIds = this.eleDeviceService.getAreaIdsByAuthFilter(this.request.getSession().getId())))) {
                condition.setAuthAreaIdIn(authAreaIds);
            }
            pager = this.eleLevelService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        } else {
            pager = new Pager();
            pager.setData(new ArrayList());
        }
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public DxGrid getDeptLevel(EleDeptLevelItem condition) {
        String authAreaIds = this.eleDeviceService.getAreaIdsByAuthFilter(this.request.getSession().getId());
        if (StringUtils.isNotBlank((CharSequence)authAreaIds)) {
            condition.setAuthAreaIdIn(authAreaIds);
        }
        Pager pager = this.eleLevelService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"ele:level:delFloor"})
    @LogRequest(module="ele_module", object="ele_leftMenu_level", opType="ele_level_addFloor", requestParams={"levelName", "floorNames"}, opContent="common_level_name")
    public ZKResultMsg delFloor(String levelId, String floorIds) {
        if (StringUtils.isNotBlank((CharSequence)levelId) && StringUtils.isNotBlank((CharSequence)floorIds)) {
            this.progressCache.beginProcess(I18nUtil.i18nCode((String)"common_op_startProcessing", (Object[])new Object[0]) + "<br/>", "", I18nUtil.i18nCode((String)"common_op_currProgress", (Object[])new Object[0]));
            ArrayList<String> floorIdList = new ArrayList<String>(Arrays.asList(floorIds.split(",")));
            List deviceIdList = this.eleFloorService.getDevIdsByFloorIds(floorIdList);
            Long personCount = this.eleLevelService.getLevelPersonCount(levelId);
            if (personCount > 0L) {
                List personIdList = this.eleLevelService.getPersonIdsByLevelId(levelId);
                if (personIdList.size() > 0) {
                    ArrayList tempPersonIdList = new ArrayList();
                    int devSize = deviceIdList.size();
                    for (int i = 0; i < devSize; ++i) {
                        int total = (int)((double)i * 100.0 / (double)devSize);
                        total = total == 100 ? 99 : total;
                        int personSize = personIdList.size();
                        for (int j = 0; j < personSize; ++j) {
                            tempPersonIdList.add(personIdList.get(j));
                            if (tempPersonIdList.size() % 200 != 0) continue;
                            this.eleLevelService.handleLevelDelFloor(levelId, tempPersonIdList, (String)deviceIdList.get(i), floorIdList);
                            this.progressCache.setProcess(new ProcessBean((int)((double)j * 100.0 / (double)personSize), total, "", I18nUtil.i18nCode((String)"common_op_currProgress", (Object[])new Object[0])));
                            tempPersonIdList = new ArrayList();
                        }
                        if (tempPersonIdList.size() <= 0) continue;
                        this.eleLevelService.handleLevelDelFloor(levelId, tempPersonIdList, (String)deviceIdList.get(i), floorIdList);
                        this.progressCache.setProcess(new ProcessBean(100, total, "", I18nUtil.i18nCode((String)"common_op_currProgress", (Object[])new Object[0])));
                        tempPersonIdList = new ArrayList();
                    }
                }
            } else {
                this.eleLevelService.delLevelFloorByParams(levelId, floorIdList);
            }
            this.eleLevelService.delVisitorToDev(levelId, deviceIdList);
            this.progressCache.finishProcess(I18nUtil.i18nCode((String)"common_progress_finish", (Object[])new Object[0]) + "<br/>", "", I18nUtil.i18nCode((String)"common_op_currProgress", (Object[])new Object[0]));
        }
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"ele:level:addFloor"})
    @LogRequest(module="ele_module", object="ele_leftMenu_level", opType="ele_level_addFloor", requestParams={"levelName", "floorNames"}, opContent="ele_floor_name")
    public ZKResultMsg addFloor(String levelId, String floorIds) {
        if (StringUtils.isNotBlank((CharSequence)levelId) && StringUtils.isNotBlank((CharSequence)floorIds)) {
            ArrayList<String> floorIdList = new ArrayList<String>(Arrays.asList(floorIds.split(",")));
            this.eleLevelService.addLevelByParamIds(StringUtils.join(floorIdList, (String)","), levelId, "floor");
            this.progressCache.beginProcess(I18nUtil.i18nCode((String)"common_op_startProcessing", (Object[])new Object[0]) + "<br/>", "", I18nUtil.i18nCode((String)"common_op_currProgress", (Object[])new Object[0]));
            List deviceIdList = this.eleFloorService.getDevIdsByFloorIds(floorIdList);
            List personIdList = this.eleLevelService.getPersonIdsByLevelId(levelId);
            if (personIdList.size() > 0) {
                ArrayList tempPersonIdList = new ArrayList();
                int devSize = deviceIdList.size();
                for (int i = 0; i < devSize; ++i) {
                    int total = (int)((double)i * 100.0 / (double)devSize);
                    total = total == 100 ? 99 : total;
                    int personSize = personIdList.size();
                    for (int j = 0; j < personSize; ++j) {
                        tempPersonIdList.add(personIdList.get(j));
                        if (tempPersonIdList.size() % 200 != 0) continue;
                        this.eleLevelService.handleLevelAddFloor(tempPersonIdList, (String)deviceIdList.get(i));
                        this.progressCache.setProcess(new ProcessBean((int)((double)j * 100.0 / (double)personSize), total, "", I18nUtil.i18nCode((String)"common_op_currProgress", (Object[])new Object[0])));
                        tempPersonIdList = new ArrayList();
                    }
                    if (tempPersonIdList.size() <= 0) continue;
                    this.eleLevelService.handleLevelAddFloor(tempPersonIdList, (String)deviceIdList.get(i));
                    this.progressCache.setProcess(new ProcessBean(100, total, "", I18nUtil.i18nCode((String)"common_op_currProgress", (Object[])new Object[0])));
                    tempPersonIdList = new ArrayList();
                }
            }
            this.eleLevelService.setVisitorToDev(levelId, deviceIdList);
            this.progressCache.finishProcess(I18nUtil.i18nCode((String)"common_progress_finish", (Object[])new Object[0]) + "<br/>", "", I18nUtil.i18nCode((String)"common_op_currProgress", (Object[])new Object[0]));
        }
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public boolean isExistLevelName(String name) {
        EleLevelItem levelItem = this.eleLevelService.getItemByName(name);
        return levelItem == null;
    }

    @RequiresPermissions(value={"ele:floor:refresh"})
    public DxGrid selectFloorlist(EleLevelSelectFloorItem codition) {
        String levelId = codition.getLevelId();
        if (StringUtils.isBlank((CharSequence)codition.getSelectId())) {
            codition.setSelectId("-1");
        }
        if (codition.getType().equals("noSelected")) {
            codition.setSelectFloorIdsNotIn(codition.getSelectId());
        } else if (codition.getType().equals("selected")) {
            codition.setSelectFloorIdsIn(codition.getSelectId());
        }
        codition.setFilterId(levelId);
        Pager pager = this.eleFloorService.getPagerFilterAuth(this.request.getSession().getId(), codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    public ZKResultMsg getPersonCount(String levelId) {
        Long personCount = this.eleLevelService.getLevelPersonCount(levelId);
        return new ZKResultMsg((Object)personCount);
    }

    public ZKResultMsg levelIsDelete(String ids) {
        ZKResultMsg zkResultMsg = this.eleLevelService.levelIsDelete(ids);
        if ("vis".equals(zkResultMsg.getData())) {
            zkResultMsg.setMsg(I18nUtil.i18nCode((String)"ele_level_visUsed", (Object[])new Object[]{zkResultMsg.getMsg()}));
        }
        return zkResultMsg;
    }
}

