/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ele.controller;

import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.utils.LocaleMessageSourceUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.ele.remote.EleAlarmMonitorRemote;
import com.zkteco.zkbiosecurity.ele.service.EleAlarmMonitorService;
import com.zkteco.zkbiosecurity.ele.service.EleTransactionService;
import com.zkteco.zkbiosecurity.ele.vo.EleTransactionItem;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
public class EleAlarmMonitorController
extends ExportController
implements EleAlarmMonitorRemote,
EleAlarmMonitorService {
    @Autowired
    private EleTransactionService eleTransactionService;

    public void sendAlarmMail(String subject, EleTransactionItem eleTransactionItem, String type) {
        StringBuilder content = new StringBuilder();
        SimpleDateFormat longDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if ("cancelAlarm".equals(type)) {
            content.append(I18nUtil.i18nCode((String)"ele_rtMonitor_ackAlarmTime", (Object[])new Object[0]) + ": " + longDateFormat.format(new Date()) + "<br/>");
            content.append(I18nUtil.i18nCode((String)"ele_rtMonitor_alarmEvent", (Object[])new Object[0]) + ": <br/>");
        }
        content.append(I18nUtil.i18nCode((String)"common_time", (Object[])new Object[0]) + ": " + longDateFormat.format(eleTransactionItem.getEventTime()) + "<br/>");
        content.append(I18nUtil.i18nCode((String)"common_dev_name", (Object[])new Object[0]) + ": " + eleTransactionItem.getDevAlias() + "<br/>");
        content.append(I18nUtil.i18nCode((String)"common_eventPoint", (Object[])new Object[0]) + ": " + eleTransactionItem.getEventPointName() + "<br/>");
        content.append(I18nUtil.i18nCode((String)"common_eventDescription", (Object[])new Object[0]) + ": " + I18nUtil.i18nCode((String)eleTransactionItem.getEventName(), (Object[])new Object[0]) + "<br/>");
        if (StringUtils.isNotBlank((CharSequence)eleTransactionItem.getPin())) {
            String name = "";
            if (StringUtils.isNotBlank((CharSequence)eleTransactionItem.getName())) {
                name = eleTransactionItem.getName().trim();
                if (!"zh_CN".equals(LocaleMessageSourceUtil.language) && StringUtils.isNotBlank((CharSequence)eleTransactionItem.getLastName())) {
                    name = (eleTransactionItem.getName() + " " + eleTransactionItem.getLastName()).trim();
                }
                name = "(" + name + ")";
            }
            content.append(I18nUtil.i18nCode((String)"pers_person", (Object[])new Object[0]) + ": " + eleTransactionItem.getPin() + name + "<br/>");
        }
        if (StringUtils.isNotBlank((CharSequence)eleTransactionItem.getCardNo())) {
            content.append(I18nUtil.i18nCode((String)"pers_card_cardNo", (Object[])new Object[0]) + ": " + eleTransactionItem.getCardNo() + "<br/>");
        }
        this.eleTransactionService.sendAlarmMail(I18nUtil.i18nCode((String)subject, (Object[])new Object[0]), content.toString());
    }
}

