/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.auth.model;

import com.zkteco.zkbiosecurity.auth.model.AuthUser;
import com.zkteco.zkbiosecurity.core.model.BaseModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;

@Entity
@Table(name="AUTH_AREA", indexes={@Index(name="AUTH_AREA_CRT_IDX", columnList="CREATE_TIME"), @Index(name="AUTH_AREA_UPT_IDX", columnList="UPDATE_TIME")})
public class AuthArea
extends BaseModel
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Column(name="CODE", length=30, nullable=false)
    private String code;
    @Column(name="NAME", length=100, nullable=false)
    private String name;
    @Column(name="REMARK", length=50)
    private String remark;
    @Column(name="INIT_FLAG")
    private Boolean initFlag;
    @ManyToOne
    @JoinColumn(name="PARENT_ID")
    private AuthArea parent;
    @OneToMany(mappedBy="parent")
    private List<AuthArea> children = new ArrayList<AuthArea>();
    @ManyToMany(targetEntity=AuthUser.class)
    @JoinTable(name="AUTH_USER_AREA", joinColumns={@JoinColumn(name="AUTH_AREA_ID", referencedColumnName="ID")}, inverseJoinColumns={@JoinColumn(name="AUTH_USER_ID", referencedColumnName="ID")})
    private Set<AuthUser> authUsers = new HashSet<AuthUser>();

    public String getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public String getRemark() {
        return this.remark;
    }

    public Boolean getInitFlag() {
        return this.initFlag;
    }

    public AuthArea getParent() {
        return this.parent;
    }

    public List<AuthArea> getChildren() {
        return this.children;
    }

    public Set<AuthUser> getAuthUsers() {
        return this.authUsers;
    }

    public AuthArea setCode(String code) {
        this.code = code;
        return this;
    }

    public AuthArea setName(String name) {
        this.name = name;
        return this;
    }

    public AuthArea setRemark(String remark) {
        this.remark = remark;
        return this;
    }

    public AuthArea setInitFlag(Boolean initFlag) {
        this.initFlag = initFlag;
        return this;
    }

    public AuthArea setParent(AuthArea parent) {
        this.parent = parent;
        return this;
    }

    public AuthArea setChildren(List<AuthArea> children) {
        this.children = children;
        return this;
    }

    public AuthArea setAuthUsers(Set<AuthUser> authUsers) {
        this.authUsers = authUsers;
        return this;
    }
}

