/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.cloud.sdk.websocket;

import com.zkteco.cloud.sdk.websocket.MessageHandler;
import com.zkteco.cloud.sdk.websocket.ZKCloudTmcClient;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.EventLoop;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionListener
implements ChannelFutureListener {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private ZKCloudTmcClient client;
    private MessageHandler messageHandler;
    private URI uri;

    public ConnectionListener() {
    }

    public ConnectionListener(URI uri, String appId, String appKey) {
        this.client = new ZKCloudTmcClient(appId, appKey);
        this.uri = uri;
    }

    public ConnectionListener(URI uri, String appId, String appKey, MessageHandler messageHandler) {
        this.client = new ZKCloudTmcClient(appId, appKey);
        this.uri = uri;
        this.messageHandler = messageHandler;
    }

    public void operationComplete(ChannelFuture channelFuture) throws Exception {
        if (!channelFuture.isSuccess()) {
            EventLoop loop = channelFuture.channel().eventLoop();
            loop.schedule(new Runnable(){

                @Override
                public void run() {
                    ConnectionListener.this.log.info("ConnectionListener \u670d\u52a1\u7aef\u94fe\u63a5\u4e0d\u4e0a\uff0c\u5f00\u59cb\u91cd\u8fde\u64cd\u4f5c...");
                    ConnectionListener.this.client.addMessageHander(ConnectionListener.this.messageHandler);
                    ConnectionListener.this.client.connect(ConnectionListener.this.uri);
                }
            }, 10L, TimeUnit.SECONDS);
        } else {
            this.log.info("ConnectionListener + \u670d\u52a1\u7aef\u94fe\u63a5\u6210\u529f...");
        }
    }

    public MessageHandler getMessageHandler() {
        return this.messageHandler;
    }

    public void setMessageHandler(MessageHandler messageHandler) {
        this.messageHandler = messageHandler;
    }

    public ZKCloudTmcClient getClient() {
        return this.client;
    }

    public void setClient(ZKCloudTmcClient client) {
        this.client = client;
    }

    public URI getUri() {
        return this.uri;
    }

    public void setUri(URI uri) {
        this.uri = uri;
    }
}

