/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.cloud.sdk.util;

import java.security.Key;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class EncrypAESUtil {
    private static byte[] decryptNative(byte[] encrypt, byte[] key, byte[] initVector) throws Exception {
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        SecretKeySpec keySpec = new SecretKeySpec(key, "AES");
        IvParameterSpec ivSpec = new IvParameterSpec(initVector);
        cipher.init(2, (Key)keySpec, ivSpec);
        byte[] decrypted = cipher.doFinal(encrypt);
        return decrypted;
    }

    private static byte[] encrypt(byte[] encrypt, byte[] keyByte, byte[] ivByte) throws Exception {
        SecretKeySpec keySpec = new SecretKeySpec(keyByte, "AES");
        IvParameterSpec ivSpec = new IvParameterSpec(ivByte);
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        cipher.init(1, (Key)keySpec, ivSpec);
        byte[] encrypted = cipher.doFinal(encrypt);
        return encrypted;
    }

    public static String encryptAESB64(String key, String initVector, String encrypt) {
        try {
            byte[] bytes = Base64.getEncoder().encode(EncrypAESUtil.encrypt(encrypt.getBytes(), key.getBytes(), initVector.getBytes()));
            return new String(bytes, "UTF-8");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String decryptAESB64(String key, String initVector, String decrypt) {
        try {
            byte[] bytes = EncrypAESUtil.decryptNative(Base64.getDecoder().decode(decrypt.getBytes("UTF-8")), key.getBytes(), initVector.getBytes());
            return new String(bytes, "UTF-8");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args) {
        System.out.println(EncrypAESUtil.encryptHMACSHA256("123", "123"));
        System.out.println((double)Float.parseFloat("2.1") > 2.0);
    }

    public static String encryptHMACSHA256(String data, String secret) {
        try {
            SecretKeySpec secretKey = new SecretKeySpec(secret.getBytes("UTF-8"), "HmacSHA256");
            Mac mac = Mac.getInstance(secretKey.getAlgorithm());
            mac.init(secretKey);
            byte[] bytes = mac.doFinal(data.getBytes("UTF-8"));
            return EncrypAESUtil.bytesToHexString(bytes);
        }
        catch (Exception gse) {
            throw new RuntimeException();
        }
    }

    public static String bytesToHexString(byte[] src) {
        StringBuilder stringBuilder = new StringBuilder("");
        if (src == null || src.length <= 0) {
            return null;
        }
        for (int i = 0; i < src.length; ++i) {
            int v = src[i] & 0xFF;
            String hv = Integer.toHexString(v);
            if (hv.length() < 2) {
                stringBuilder.append(0);
            }
            stringBuilder.append(hv);
        }
        return stringBuilder.toString();
    }

    public static String encryptHMACSHA256B64(String data, String secret) {
        try {
            SecretKeySpec secretKey = new SecretKeySpec(secret.getBytes("UTF-8"), "HmacSHA256");
            Mac mac = Mac.getInstance(secretKey.getAlgorithm());
            mac.init(secretKey);
            byte[] bytes = mac.doFinal(data.getBytes("UTF-8"));
            byte[] b64bytes = Base64.getEncoder().encode(bytes);
            return new String(b64bytes, "UTF-8");
        }
        catch (Exception gse) {
            throw new RuntimeException();
        }
    }

    public static String encryptHMACSHA256(byte[] encrypt, String secret) {
        try {
            SecretKeySpec secretKey = new SecretKeySpec(secret.getBytes("UTF-8"), "HmacSHA256");
            Mac mac = Mac.getInstance(secretKey.getAlgorithm());
            mac.init(secretKey);
            byte[] bytes = mac.doFinal(encrypt);
            return EncrypAESUtil.bytesToHexString(bytes);
        }
        catch (Exception var5) {
            throw new RuntimeException();
        }
    }
}

