/*
 * Decompiled with CFR 0.152.
 */
package sun.util.locale.provider;

import java.util.Locale;
import java.util.Set;
import java.util.spi.CurrencyNameProvider;
import sun.util.locale.provider.AvailableLanguageTags;
import sun.util.locale.provider.LocaleProviderAdapter;

public class CurrencyNameProviderImpl
extends CurrencyNameProvider
implements AvailableLanguageTags {
    private final LocaleProviderAdapter.Type type;
    private final Set<String> langtags;

    public CurrencyNameProviderImpl(LocaleProviderAdapter.Type type, Set<String> langtags) {
        this.type = type;
        this.langtags = langtags;
    }

    @Override
    public Set<String> getAvailableLanguageTags() {
        return this.langtags;
    }

    @Override
    public Locale[] getAvailableLocales() {
        return LocaleProviderAdapter.toLocaleArray(this.langtags);
    }

    @Override
    public String getSymbol(String currencyCode, Locale locale) {
        return this.getString(currencyCode.toUpperCase(Locale.ROOT), locale);
    }

    @Override
    public String getDisplayName(String currencyCode, Locale locale) {
        return this.getString(currencyCode.toLowerCase(Locale.ROOT), locale);
    }

    private String getString(String key, Locale locale) {
        if (locale == null) {
            throw new NullPointerException();
        }
        return LocaleProviderAdapter.forType(this.type).getLocaleResources(locale).getCurrencyName(key);
    }
}

