/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal.tools;

import java.net.InetAddress;
import java.util.List;
import sun.security.krb5.EncryptionKey;
import sun.security.krb5.PrincipalName;
import sun.security.krb5.RealmException;
import sun.security.krb5.internal.KerberosTime;
import sun.security.krb5.internal.Krb5;
import sun.security.krb5.internal.ccache.Credentials;
import sun.security.krb5.internal.ccache.CredentialsCache;
import sun.security.krb5.internal.crypto.EType;
import sun.security.krb5.internal.ktab.KeyTab;
import sun.security.krb5.internal.ktab.KeyTabEntry;

public class Klist {
    Object target;
    char[] options = new char[4];
    String name;
    char action;
    private static boolean DEBUG = Krb5.DEBUG;

    public static void main(String[] args) {
        Klist klist = new Klist();
        if (args == null || args.length == 0) {
            klist.action = (char)99;
        } else {
            klist.processArgs(args);
        }
        switch (klist.action) {
            case 'c': {
                if (klist.name == null) {
                    klist.target = CredentialsCache.getInstance();
                    klist.name = CredentialsCache.cacheName();
                } else {
                    klist.target = CredentialsCache.getInstance(klist.name);
                }
                if (klist.target != null) {
                    klist.displayCache();
                    break;
                }
                klist.displayMessage("Credentials cache");
                System.exit(-1);
                break;
            }
            case 'k': {
                KeyTab ktab = KeyTab.getInstance(klist.name);
                if (ktab.isMissing()) {
                    System.out.println("KeyTab " + klist.name + " not found.");
                    System.exit(-1);
                } else if (!ktab.isValid()) {
                    System.out.println("KeyTab " + klist.name + " format not supported.");
                    System.exit(-1);
                }
                klist.target = ktab;
                klist.name = ktab.tabName();
                klist.displayTab();
                break;
            }
            default: {
                if (klist.name != null) {
                    klist.printHelp();
                    System.exit(-1);
                    break;
                }
                klist.target = CredentialsCache.getInstance();
                klist.name = CredentialsCache.cacheName();
                if (klist.target != null) {
                    klist.displayCache();
                    break;
                }
                klist.displayMessage("Credentials cache");
                System.exit(-1);
            }
        }
    }

    void processArgs(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            Character arg;
            if (args[i].length() >= 2 && args[i].startsWith("-")) {
                arg = new Character(args[i].charAt(1));
                switch (arg.charValue()) {
                    case 'c': {
                        this.action = (char)99;
                        break;
                    }
                    case 'k': {
                        this.action = (char)107;
                        break;
                    }
                    case 'a': {
                        this.options[2] = 97;
                        break;
                    }
                    case 'n': {
                        this.options[3] = 110;
                        break;
                    }
                    case 'f': {
                        this.options[1] = 102;
                        break;
                    }
                    case 'e': {
                        this.options[0] = 101;
                        break;
                    }
                    case 'K': {
                        this.options[1] = 75;
                        break;
                    }
                    case 't': {
                        this.options[2] = 116;
                        break;
                    }
                    default: {
                        this.printHelp();
                        System.exit(-1);
                        break;
                    }
                }
                continue;
            }
            if (!args[i].startsWith("-") && i == args.length - 1) {
                this.name = args[i];
                arg = null;
                continue;
            }
            this.printHelp();
            System.exit(-1);
        }
    }

    void displayTab() {
        KeyTab table = (KeyTab)this.target;
        KeyTabEntry[] entries = table.getEntries();
        if (entries.length == 0) {
            System.out.println("\nKey tab: " + this.name + ",  0 entries found.\n");
        } else {
            if (entries.length == 1) {
                System.out.println("\nKey tab: " + this.name + ", " + entries.length + " entry found.\n");
            } else {
                System.out.println("\nKey tab: " + this.name + ", " + entries.length + " entries found.\n");
            }
            for (int i = 0; i < entries.length; ++i) {
                EncryptionKey key;
                System.out.println("[" + (i + 1) + "] Service principal: " + entries[i].getService().toString());
                System.out.println("\t KVNO: " + entries[i].getKey().getKeyVersionNumber());
                if (this.options[0] == 'e') {
                    key = entries[i].getKey();
                    System.out.println("\t Key type: " + key.getEType());
                }
                if (this.options[1] == 'K') {
                    key = entries[i].getKey();
                    System.out.println("\t Key: " + entries[i].getKeyString());
                }
                if (this.options[2] != 't') continue;
                System.out.println("\t Time stamp: " + this.format(entries[i].getTimeStamp()));
            }
        }
    }

    void displayCache() {
        CredentialsCache cache = (CredentialsCache)this.target;
        Credentials[] creds = cache.getCredsList();
        if (creds == null) {
            System.out.println("No credentials available in the cache " + this.name);
            System.exit(-1);
        }
        System.out.println("\nCredentials cache: " + this.name);
        String defaultPrincipal = cache.getPrimaryPrincipal().toString();
        int num = creds.length;
        if (num == 1) {
            System.out.println("\nDefault principal: " + defaultPrincipal + ", " + creds.length + " entry found.\n");
        } else {
            System.out.println("\nDefault principal: " + defaultPrincipal + ", " + creds.length + " entries found.\n");
        }
        if (creds != null) {
            for (int i = 0; i < creds.length; ++i) {
                try {
                    String clientPrincipal;
                    String starttime = creds[i].getStartTime() != null ? this.format(creds[i].getStartTime()) : this.format(creds[i].getAuthTime());
                    String endtime = this.format(creds[i].getEndTime());
                    String servicePrincipal = creds[i].getServicePrincipal().toString();
                    System.out.println("[" + (i + 1) + "]  Service Principal:  " + servicePrincipal);
                    PrincipalName servicePrincipal2 = creds[i].getServicePrincipal2();
                    if (servicePrincipal2 != null) {
                        System.out.println("     Second Service:     " + servicePrincipal2);
                    }
                    if (!(clientPrincipal = creds[i].getClientPrincipal().toString()).equals(defaultPrincipal)) {
                        System.out.println("     Client Principal:   " + clientPrincipal);
                    }
                    System.out.println("     Valid starting:     " + starttime);
                    System.out.println("     Expires:            " + endtime);
                    if (creds[i].getRenewTill() != null) {
                        String renewTill = this.format(creds[i].getRenewTill());
                        System.out.println("     Renew until:        " + renewTill);
                    }
                    if (this.options[0] == 'e') {
                        String eskey = EType.toString(creds[i].getEType());
                        String etkt = EType.toString(creds[i].getTktEType());
                        if (creds[i].getTktEType2() == 0) {
                            System.out.println("     EType (skey, tkt):  " + eskey + ", " + etkt);
                        } else {
                            String etkt2 = EType.toString(creds[i].getTktEType2());
                            System.out.println("     EType (skey, tkts): " + eskey + ", " + etkt + ", " + etkt2);
                        }
                    }
                    if (this.options[1] == 'f') {
                        System.out.println("     Flags:              " + creds[i].getTicketFlags().toString());
                    }
                    if (this.options[2] != 'a') continue;
                    boolean first = true;
                    InetAddress[] caddr = creds[i].setKrbCreds().getClientAddresses();
                    if (caddr != null) {
                        for (InetAddress ia : caddr) {
                            String out = this.options[3] == 'n' ? ia.getHostAddress() : ia.getCanonicalHostName();
                            System.out.println("     " + (first ? "Addresses:" : "          ") + "       " + out);
                            first = false;
                        }
                        continue;
                    }
                    System.out.println("     [No host addresses info]");
                    continue;
                }
                catch (RealmException e) {
                    System.out.println("Error reading principal from the entry.");
                    if (DEBUG) {
                        e.printStackTrace();
                    }
                    System.exit(-1);
                }
            }
        } else {
            System.out.println("\nNo entries found.");
        }
        List<CredentialsCache.ConfigEntry> configEntries = cache.getConfigEntries();
        if (configEntries != null && !configEntries.isEmpty()) {
            System.out.println("\nConfig entries:");
            for (CredentialsCache.ConfigEntry e : configEntries) {
                System.out.println("     " + e);
            }
        }
    }

    void displayMessage(String target) {
        if (this.name == null) {
            System.out.println("Default " + target + " not found.");
        } else {
            System.out.println(target + " " + this.name + " not found.");
        }
    }

    private String format(KerberosTime kt) {
        String date = kt.toDate().toString();
        return date.substring(4, 7) + " " + date.substring(8, 10) + ", " + date.substring(24) + " " + date.substring(11, 19);
    }

    void printHelp() {
        System.out.println("\nUsage: klist [[-c] [-f] [-e] [-a [-n]]] [-k [-t] [-K]] [name]");
        System.out.println("   name\t name of credentials cache or  keytab with the prefix. File-based cache or keytab's prefix is FILE:.");
        System.out.println("   -c specifies that credential cache is to be listed");
        System.out.println("   -k specifies that key tab is to be listed");
        System.out.println("   options for credentials caches:");
        System.out.println("\t-f \t shows credentials flags");
        System.out.println("\t-e \t shows the encryption type");
        System.out.println("\t-a \t shows addresses");
        System.out.println("\t  -n \t   do not reverse-resolve addresses");
        System.out.println("   options for keytabs:");
        System.out.println("\t-t \t shows keytab entry timestamps");
        System.out.println("\t-K \t shows keytab entry key value");
        System.out.println("\t-e \t shows keytab entry key type");
        System.out.println("\nUsage: java sun.security.krb5.tools.Klist -help for help.");
    }
}

