/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5;

import java.io.IOException;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Locale;
import java.util.Vector;
import sun.misc.Unsafe;
import sun.security.krb5.Asn1Exception;
import sun.security.krb5.Config;
import sun.security.krb5.KrbException;
import sun.security.krb5.Realm;
import sun.security.krb5.RealmException;
import sun.security.krb5.internal.ccache.CCacheOutputStream;
import sun.security.krb5.internal.util.KerberosString;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;

public class PrincipalName
implements Cloneable {
    public static final int KRB_NT_UNKNOWN = 0;
    public static final int KRB_NT_PRINCIPAL = 1;
    public static final int KRB_NT_SRV_INST = 2;
    public static final int KRB_NT_SRV_HST = 3;
    public static final int KRB_NT_SRV_XHST = 4;
    public static final int KRB_NT_UID = 5;
    public static final String TGS_DEFAULT_SRV_NAME = "krbtgt";
    public static final int TGS_DEFAULT_NT = 2;
    public static final char NAME_COMPONENT_SEPARATOR = '/';
    public static final char NAME_REALM_SEPARATOR = '@';
    public static final char REALM_COMPONENT_SEPARATOR = '.';
    public static final String NAME_COMPONENT_SEPARATOR_STR = "/";
    public static final String NAME_REALM_SEPARATOR_STR = "@";
    public static final String REALM_COMPONENT_SEPARATOR_STR = ".";
    private final int nameType;
    private final String[] nameStrings;
    private final Realm nameRealm;
    private final boolean realmDeduced;
    private transient String salt = null;
    private static final long NAME_STRINGS_OFFSET;
    private static final Unsafe UNSAFE;

    public PrincipalName(int nameType, String[] nameStrings, Realm nameRealm) {
        if (nameRealm == null) {
            throw new IllegalArgumentException("Null realm not allowed");
        }
        PrincipalName.validateNameStrings(nameStrings);
        this.nameType = nameType;
        this.nameStrings = (String[])nameStrings.clone();
        this.nameRealm = nameRealm;
        this.realmDeduced = false;
    }

    public PrincipalName(String[] nameParts, String realm) throws RealmException {
        this(0, nameParts, new Realm(realm));
    }

    private static void validateNameStrings(String[] ns) {
        if (ns == null) {
            throw new IllegalArgumentException("Null nameStrings not allowed");
        }
        if (ns.length == 0) {
            throw new IllegalArgumentException("Empty nameStrings not allowed");
        }
        for (String s : ns) {
            if (s == null) {
                throw new IllegalArgumentException("Null nameString not allowed");
            }
            if (!s.isEmpty()) continue;
            throw new IllegalArgumentException("Empty nameString not allowed");
        }
    }

    public Object clone() {
        try {
            PrincipalName pName = (PrincipalName)super.clone();
            UNSAFE.putObject((Object)this, NAME_STRINGS_OFFSET, this.nameStrings.clone());
            return pName;
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError((Object)"Should never happen");
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof PrincipalName) {
            PrincipalName other = (PrincipalName)o;
            return this.nameRealm.equals(other.nameRealm) && Arrays.equals(this.nameStrings, other.nameStrings);
        }
        return false;
    }

    public PrincipalName(DerValue encoding, Realm realm) throws Asn1Exception, IOException {
        Vector<String> v;
        if (realm == null) {
            throw new IllegalArgumentException("Null realm not allowed");
        }
        this.realmDeduced = false;
        this.nameRealm = realm;
        if (encoding == null) {
            throw new IllegalArgumentException("Null encoding not allowed");
        }
        if (encoding.getTag() != 48) {
            throw new Asn1Exception(906);
        }
        DerValue der = encoding.getData().getDerValue();
        if ((der.getTag() & 0x1F) != 0) {
            throw new Asn1Exception(906);
        }
        BigInteger bint = der.getData().getBigInteger();
        this.nameType = bint.intValue();
        der = encoding.getData().getDerValue();
        if ((der.getTag() & 0x1F) == 1) {
            DerValue subDer = der.getData().getDerValue();
            if (subDer.getTag() != 48) {
                throw new Asn1Exception(906);
            }
            v = new Vector<String>();
            while (subDer.getData().available() > 0) {
                DerValue subSubDer = subDer.getData().getDerValue();
                String namePart = new KerberosString(subSubDer).toString();
                v.addElement(namePart);
            }
        } else {
            throw new Asn1Exception(906);
        }
        this.nameStrings = new String[v.size()];
        v.copyInto(this.nameStrings);
        PrincipalName.validateNameStrings(this.nameStrings);
    }

    public static PrincipalName parse(DerInputStream data, byte explicitTag, boolean optional, Realm realm) throws Asn1Exception, IOException, RealmException {
        if (optional && ((byte)data.peekByte() & 0x1F) != explicitTag) {
            return null;
        }
        DerValue der = data.getDerValue();
        if (explicitTag != (der.getTag() & 0x1F)) {
            throw new Asn1Exception(906);
        }
        DerValue subDer = der.getData().getDerValue();
        if (realm == null) {
            realm = Realm.getDefault();
        }
        return new PrincipalName(subDer, realm);
    }

    private static String[] parseName(String name) {
        String component;
        Vector<String> tempStrings = new Vector<String>();
        String temp = name;
        int i = 0;
        int componentStart = 0;
        while (i < temp.length()) {
            if (temp.charAt(i) == '/') {
                if (i > 0 && temp.charAt(i - 1) == '\\') {
                    temp = temp.substring(0, i - 1) + temp.substring(i, temp.length());
                    continue;
                }
                if (componentStart <= i) {
                    component = temp.substring(componentStart, i);
                    tempStrings.addElement(component);
                }
                componentStart = i + 1;
            } else if (temp.charAt(i) == '@') {
                if (i > 0 && temp.charAt(i - 1) == '\\') {
                    temp = temp.substring(0, i - 1) + temp.substring(i, temp.length());
                    continue;
                }
                if (componentStart < i) {
                    component = temp.substring(componentStart, i);
                    tempStrings.addElement(component);
                }
                componentStart = i + 1;
                break;
            }
            ++i;
        }
        if (i == temp.length()) {
            component = temp.substring(componentStart, i);
            tempStrings.addElement(component);
        }
        Object[] result = new String[tempStrings.size()];
        tempStrings.copyInto(result);
        return result;
    }

    public PrincipalName(String name, int type, String realm) throws RealmException {
        if (name == null) {
            throw new IllegalArgumentException("Null name not allowed");
        }
        String[] nameParts = PrincipalName.parseName(name);
        PrincipalName.validateNameStrings(nameParts);
        if (realm == null) {
            realm = Realm.parseRealmAtSeparator(name);
        }
        this.realmDeduced = realm == null;
        switch (type) {
            case 3: {
                if (nameParts.length >= 2) {
                    String hostName = nameParts[1];
                    try {
                        String canonicalized = InetAddress.getByName(hostName).getCanonicalHostName();
                        if (canonicalized.toLowerCase(Locale.ENGLISH).startsWith(hostName.toLowerCase(Locale.ENGLISH) + REALM_COMPONENT_SEPARATOR_STR)) {
                            hostName = canonicalized;
                        }
                    }
                    catch (SecurityException | UnknownHostException exception) {
                        // empty catch block
                    }
                    if (hostName.endsWith(REALM_COMPONENT_SEPARATOR_STR)) {
                        hostName = hostName.substring(0, hostName.length() - 1);
                    }
                    nameParts[1] = hostName.toLowerCase(Locale.ENGLISH);
                }
                this.nameStrings = nameParts;
                this.nameType = type;
                if (realm != null) {
                    this.nameRealm = new Realm(realm);
                    break;
                }
                String mapRealm = PrincipalName.mapHostToRealm(nameParts[1]);
                if (mapRealm != null) {
                    this.nameRealm = new Realm(mapRealm);
                    break;
                }
                this.nameRealm = Realm.getDefault();
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                this.nameStrings = nameParts;
                this.nameType = type;
                if (realm != null) {
                    this.nameRealm = new Realm(realm);
                    break;
                }
                this.nameRealm = Realm.getDefault();
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal name type");
            }
        }
    }

    public PrincipalName(String name, int type) throws RealmException {
        this(name, type, (String)null);
    }

    public PrincipalName(String name) throws RealmException {
        this(name, 0);
    }

    public PrincipalName(String name, String realm) throws RealmException {
        this(name, 0, realm);
    }

    public static PrincipalName tgsService(String r1, String r2) throws KrbException {
        return new PrincipalName(2, new String[]{TGS_DEFAULT_SRV_NAME, r1}, new Realm(r2));
    }

    public String getRealmAsString() {
        return this.getRealmString();
    }

    public String getPrincipalNameAsString() {
        StringBuffer temp = new StringBuffer(this.nameStrings[0]);
        for (int i = 1; i < this.nameStrings.length; ++i) {
            temp.append(this.nameStrings[i]);
        }
        return temp.toString();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String getName() {
        return this.toString();
    }

    public int getNameType() {
        return this.nameType;
    }

    public String[] getNameStrings() {
        return (String[])this.nameStrings.clone();
    }

    public byte[][] toByteArray() {
        byte[][] result = new byte[this.nameStrings.length][];
        for (int i = 0; i < this.nameStrings.length; ++i) {
            result[i] = new byte[this.nameStrings[i].length()];
            result[i] = this.nameStrings[i].getBytes();
        }
        return result;
    }

    public String getRealmString() {
        return this.nameRealm.toString();
    }

    public Realm getRealm() {
        return this.nameRealm;
    }

    public String getSalt() {
        if (this.salt == null) {
            StringBuffer salt = new StringBuffer();
            salt.append(this.nameRealm.toString());
            for (int i = 0; i < this.nameStrings.length; ++i) {
                salt.append(this.nameStrings[i]);
            }
            return salt.toString();
        }
        return this.salt;
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        for (int i = 0; i < this.nameStrings.length; ++i) {
            if (i > 0) {
                str.append(NAME_COMPONENT_SEPARATOR_STR);
            }
            str.append(this.nameStrings[i]);
        }
        str.append(NAME_REALM_SEPARATOR_STR);
        str.append(this.nameRealm.toString());
        return str.toString();
    }

    public String getNameString() {
        StringBuffer str = new StringBuffer();
        for (int i = 0; i < this.nameStrings.length; ++i) {
            if (i > 0) {
                str.append(NAME_COMPONENT_SEPARATOR_STR);
            }
            str.append(this.nameStrings[i]);
        }
        return str.toString();
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        DerOutputStream bytes = new DerOutputStream();
        DerOutputStream temp = new DerOutputStream();
        BigInteger bint = BigInteger.valueOf(this.nameType);
        temp.putInteger(bint);
        bytes.write(DerValue.createTag((byte)-128, true, (byte)0), temp);
        temp = new DerOutputStream();
        DerValue[] der = new DerValue[this.nameStrings.length];
        for (int i = 0; i < this.nameStrings.length; ++i) {
            der[i] = new KerberosString(this.nameStrings[i]).toDerValue();
        }
        temp.putSequence(der);
        bytes.write(DerValue.createTag((byte)-128, true, (byte)1), temp);
        temp = new DerOutputStream();
        temp.write((byte)48, bytes);
        return temp.toByteArray();
    }

    public boolean match(PrincipalName pname) {
        boolean matched = true;
        if (this.nameRealm != null && pname.nameRealm != null && !this.nameRealm.toString().equalsIgnoreCase(pname.nameRealm.toString())) {
            matched = false;
        }
        if (this.nameStrings.length != pname.nameStrings.length) {
            matched = false;
        } else {
            for (int i = 0; i < this.nameStrings.length; ++i) {
                if (this.nameStrings[i].equalsIgnoreCase(pname.nameStrings[i])) continue;
                matched = false;
            }
        }
        return matched;
    }

    public void writePrincipal(CCacheOutputStream cos) throws IOException {
        cos.write32(this.nameType);
        cos.write32(this.nameStrings.length);
        byte[] realmBytes = null;
        realmBytes = this.nameRealm.toString().getBytes();
        cos.write32(realmBytes.length);
        cos.write(realmBytes, 0, realmBytes.length);
        byte[] bytes = null;
        for (int i = 0; i < this.nameStrings.length; ++i) {
            bytes = this.nameStrings[i].getBytes();
            cos.write32(bytes.length);
            cos.write(bytes, 0, bytes.length);
        }
    }

    public String getInstanceComponent() {
        if (this.nameStrings != null && this.nameStrings.length >= 2) {
            return new String(this.nameStrings[1]);
        }
        return null;
    }

    static String mapHostToRealm(String name) {
        String result = null;
        try {
            String subname = null;
            Config c = Config.getInstance();
            result = c.get("domain_realm", name);
            if (result != null) {
                return result;
            }
            for (int i = 1; i < name.length(); ++i) {
                if (name.charAt(i) != '.' || i == name.length() - 1) continue;
                subname = name.substring(i);
                result = c.get("domain_realm", subname);
                if (result == null) {
                    subname = name.substring(i + 1);
                    result = c.get("domain_realm", subname);
                    if (result == null) {
                        continue;
                    }
                }
                break;
            }
        }
        catch (KrbException krbException) {
            // empty catch block
        }
        return result;
    }

    public boolean isRealmDeduced() {
        return this.realmDeduced;
    }

    static {
        try {
            Unsafe unsafe = Unsafe.getUnsafe();
            NAME_STRINGS_OFFSET = unsafe.objectFieldOffset(PrincipalName.class.getDeclaredField("nameStrings"));
            UNSAFE = unsafe;
        }
        catch (ReflectiveOperationException e) {
            throw new Error(e);
        }
    }
}

