/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.protocol.file;

import java.io.File;
import java.io.IOException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import sun.net.www.ParseUtil;
import sun.net.www.protocol.file.FileURLConnection;
import sun.net.www.protocol.file.UNCFileURLConnection;

public class Handler
extends URLStreamHandler {
    private String getHost(URL url) {
        String host = url.getHost();
        if (host == null) {
            host = "";
        }
        return host;
    }

    @Override
    protected void parseURL(URL u, String spec, int start, int limit) {
        super.parseURL(u, spec.replace(File.separatorChar, '/'), start, limit);
    }

    @Override
    public synchronized URLConnection openConnection(URL url) throws IOException {
        return this.openConnection(url, null);
    }

    @Override
    public synchronized URLConnection openConnection(URL url, Proxy p) throws IOException {
        URLConnection uc;
        String file = url.getFile();
        String host = url.getHost();
        String path = ParseUtil.decode(file);
        path = path.replace('/', '\\');
        path = path.replace('|', ':');
        if (host == null || host.equals("") || host.equalsIgnoreCase("localhost") || host.equals("~")) {
            return this.createFileURLConnection(url, new File(path));
        }
        path = "\\\\" + host + path;
        File f = new File(path);
        if (f.exists()) {
            return new UNCFileURLConnection(url, f, path);
        }
        try {
            URL newurl = new URL("ftp", host, file + (url.getRef() == null ? "" : "#" + url.getRef()));
            uc = p != null ? newurl.openConnection(p) : newurl.openConnection();
        }
        catch (IOException e) {
            uc = null;
        }
        if (uc == null) {
            throw new IOException("Unable to connect to: " + url.toExternalForm());
        }
        return uc;
    }

    protected URLConnection createFileURLConnection(URL url, File file) {
        return new FileURLConnection(url, file);
    }

    @Override
    protected boolean hostsEqual(URL u1, URL u2) {
        String s1 = u1.getHost();
        String s2 = u2.getHost();
        if ("localhost".equalsIgnoreCase(s1) && (s2 == null || "".equals(s2))) {
            return true;
        }
        if ("localhost".equalsIgnoreCase(s2) && (s1 == null || "".equals(s1))) {
            return true;
        }
        return super.hostsEqual(u1, u2);
    }
}

