/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.opengl;

import java.awt.AWTException;
import java.awt.BufferCapabilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.ImageCapabilities;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.VolatileImage;
import sun.awt.Win32GraphicsConfig;
import sun.awt.Win32GraphicsDevice;
import sun.awt.image.SunVolatileImage;
import sun.awt.image.SurfaceManager;
import sun.awt.windows.WComponentPeer;
import sun.java2d.Disposer;
import sun.java2d.DisposerRecord;
import sun.java2d.SunGraphics2D;
import sun.java2d.Surface;
import sun.java2d.SurfaceData;
import sun.java2d.opengl.OGLContext;
import sun.java2d.opengl.OGLGraphicsConfig;
import sun.java2d.opengl.OGLRenderQueue;
import sun.java2d.opengl.OGLSurfaceData;
import sun.java2d.opengl.WGLSurfaceData;
import sun.java2d.pipe.hw.AccelDeviceEventListener;
import sun.java2d.pipe.hw.AccelDeviceEventNotifier;
import sun.java2d.pipe.hw.AccelSurface;
import sun.java2d.pipe.hw.AccelTypedVolatileImage;
import sun.java2d.pipe.hw.ContextCapabilities;
import sun.java2d.windows.GDIWindowSurfaceData;

public class WGLGraphicsConfig
extends Win32GraphicsConfig
implements OGLGraphicsConfig {
    protected static boolean wglAvailable;
    private static ImageCapabilities imageCaps;
    private BufferCapabilities bufferCaps;
    private long pConfigInfo;
    private ContextCapabilities oglCaps;
    private OGLContext context;
    private Object disposerReferent = new Object();

    public static native int getDefaultPixFmt(int var0);

    private static native boolean initWGL();

    private static native long getWGLConfigInfo(int var0, int var1);

    private static native int getOGLCapabilities(long var0);

    protected WGLGraphicsConfig(Win32GraphicsDevice device, int visualnum, long configInfo, ContextCapabilities oglCaps) {
        super(device, visualnum);
        this.pConfigInfo = configInfo;
        this.oglCaps = oglCaps;
        this.context = new OGLContext(OGLRenderQueue.getInstance(), this);
        Disposer.addRecord(this.disposerReferent, new WGLGCDisposerRecord(this.pConfigInfo, device.getScreen()));
    }

    @Override
    public Object getProxyKey() {
        return this;
    }

    @Override
    public SurfaceData createManagedSurface(int w, int h, int transparency) {
        return WGLSurfaceData.createData(this, w, h, this.getColorModel(transparency), null, 3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WGLGraphicsConfig getConfig(Win32GraphicsDevice device, int pixfmt) {
        if (!wglAvailable) {
            return null;
        }
        long cfginfo = 0L;
        final String[] ids = new String[1];
        OGLRenderQueue rq = OGLRenderQueue.getInstance();
        rq.lock();
        try {
            OGLContext.invalidateCurrentContext();
            WGLGetConfigInfo action = new WGLGetConfigInfo(device.getScreen(), pixfmt);
            rq.flushAndInvokeNow(action);
            cfginfo = action.getConfigInfo();
            if (cfginfo != 0L) {
                OGLContext.setScratchSurface(cfginfo);
                rq.flushAndInvokeNow(new Runnable(){

                    @Override
                    public void run() {
                        ids[0] = OGLContext.getOGLIdString();
                    }
                });
            }
        }
        finally {
            rq.unlock();
        }
        if (cfginfo == 0L) {
            return null;
        }
        int oglCaps = WGLGraphicsConfig.getOGLCapabilities(cfginfo);
        OGLContext.OGLContextCaps caps = new OGLContext.OGLContextCaps(oglCaps, ids[0]);
        return new WGLGraphicsConfig(device, pixfmt, cfginfo, caps);
    }

    public static boolean isWGLAvailable() {
        return wglAvailable;
    }

    @Override
    public final boolean isCapPresent(int cap) {
        return (this.oglCaps.getCaps() & cap) != 0;
    }

    @Override
    public final long getNativeConfigInfo() {
        return this.pConfigInfo;
    }

    @Override
    public final OGLContext getContext() {
        return this.context;
    }

    @Override
    public synchronized void displayChanged() {
        super.displayChanged();
        OGLRenderQueue rq = OGLRenderQueue.getInstance();
        rq.lock();
        try {
            OGLContext.invalidateCurrentContext();
        }
        finally {
            rq.unlock();
        }
    }

    @Override
    public ColorModel getColorModel(int transparency) {
        switch (transparency) {
            case 1: {
                return new DirectColorModel(24, 0xFF0000, 65280, 255);
            }
            case 2: {
                return new DirectColorModel(25, 0xFF0000, 65280, 255, 0x1000000);
            }
            case 3: {
                ColorSpace cs = ColorSpace.getInstance(1000);
                return new DirectColorModel(cs, 32, 0xFF0000, 65280, 255, -16777216, true, 3);
            }
        }
        return null;
    }

    @Override
    public String toString() {
        return "WGLGraphicsConfig[dev=" + this.screen + ",pixfmt=" + this.visual + "]";
    }

    @Override
    public SurfaceData createSurfaceData(WComponentPeer peer, int numBackBuffers) {
        SurfaceData sd = WGLSurfaceData.createData(peer);
        if (sd == null) {
            sd = GDIWindowSurfaceData.createData(peer);
        }
        return sd;
    }

    @Override
    public void assertOperationSupported(Component target, int numBuffers, BufferCapabilities caps) throws AWTException {
        if (numBuffers > 2) {
            throw new AWTException("Only double or single buffering is supported");
        }
        BufferCapabilities configCaps = this.getBufferCapabilities();
        if (!configCaps.isPageFlipping()) {
            throw new AWTException("Page flipping is not supported");
        }
        if (caps.getFlipContents() == BufferCapabilities.FlipContents.PRIOR) {
            throw new AWTException("FlipContents.PRIOR is not supported");
        }
    }

    @Override
    public VolatileImage createBackBuffer(WComponentPeer peer) {
        Component target = (Component)peer.getTarget();
        int w = Math.max(1, target.getWidth());
        int h = Math.max(1, target.getHeight());
        return new SunVolatileImage(target, w, h, Boolean.TRUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flip(WComponentPeer peer, Component target, VolatileImage backBuffer, int x1, int y1, int x2, int y2, BufferCapabilities.FlipContents flipAction) {
        if (flipAction == BufferCapabilities.FlipContents.COPIED) {
            SurfaceManager vsm = SurfaceManager.getManager(backBuffer);
            SurfaceData sd = vsm.getPrimarySurfaceData();
            if (sd instanceof WGLSurfaceData.WGLVSyncOffScreenSurfaceData) {
                WGLSurfaceData.WGLVSyncOffScreenSurfaceData vsd = (WGLSurfaceData.WGLVSyncOffScreenSurfaceData)sd;
                SurfaceData bbsd = vsd.getFlipSurface();
                SunGraphics2D bbg = new SunGraphics2D(bbsd, Color.black, Color.white, null);
                try {
                    ((Graphics)bbg).drawImage(backBuffer, 0, 0, null);
                }
                finally {
                    ((Graphics)bbg).dispose();
                }
            }
            Graphics g = peer.getGraphics();
            try {
                g.drawImage(backBuffer, x1, y1, x2, y2, x1, y1, x2, y2, null);
            }
            finally {
                g.dispose();
            }
            return;
        }
        if (flipAction == BufferCapabilities.FlipContents.PRIOR) {
            return;
        }
        OGLSurfaceData.swapBuffers(peer.getData());
        if (flipAction == BufferCapabilities.FlipContents.BACKGROUND) {
            Graphics g = backBuffer.getGraphics();
            try {
                g.setColor(target.getBackground());
                g.fillRect(0, 0, backBuffer.getWidth(), backBuffer.getHeight());
            }
            finally {
                g.dispose();
            }
        }
    }

    @Override
    public BufferCapabilities getBufferCapabilities() {
        if (this.bufferCaps == null) {
            boolean dblBuf = this.isCapPresent(65536);
            this.bufferCaps = new WGLBufferCaps(dblBuf);
        }
        return this.bufferCaps;
    }

    @Override
    public ImageCapabilities getImageCapabilities() {
        return imageCaps;
    }

    @Override
    public VolatileImage createCompatibleVolatileImage(int width, int height, int transparency, int type) {
        AccelTypedVolatileImage vi;
        Surface sd;
        if (type == 4 || type == 1 || type == 0 || transparency == 2) {
            return null;
        }
        if (type == 5) {
            if (!this.isCapPresent(12)) {
                return null;
            }
        } else if (type == 2) {
            boolean isOpaque;
            boolean bl = isOpaque = transparency == 1;
            if (!isOpaque && !this.isCapPresent(2)) {
                return null;
            }
        }
        if (!((sd = (vi = new AccelTypedVolatileImage((GraphicsConfiguration)this, width, height, transparency, type)).getDestSurface()) instanceof AccelSurface) || ((AccelSurface)sd).getType() != type) {
            vi.flush();
            vi = null;
        }
        return vi;
    }

    @Override
    public ContextCapabilities getContextCapabilities() {
        return this.oglCaps;
    }

    @Override
    public void addDeviceEventListener(AccelDeviceEventListener l) {
        AccelDeviceEventNotifier.addListener(l, this.screen.getScreen());
    }

    @Override
    public void removeDeviceEventListener(AccelDeviceEventListener l) {
        AccelDeviceEventNotifier.removeListener(l);
    }

    static {
        imageCaps = new WGLImageCaps();
        wglAvailable = WGLGraphicsConfig.initWGL();
    }

    private static class WGLImageCaps
    extends ImageCapabilities {
        private WGLImageCaps() {
            super(true);
        }

        @Override
        public boolean isTrueVolatile() {
            return true;
        }
    }

    private static class WGLBufferCaps
    extends BufferCapabilities {
        public WGLBufferCaps(boolean dblBuf) {
            super(imageCaps, imageCaps, dblBuf ? BufferCapabilities.FlipContents.UNDEFINED : null);
        }
    }

    private static class WGLGCDisposerRecord
    implements DisposerRecord {
        private long pCfgInfo;
        private int screen;

        public WGLGCDisposerRecord(long pCfgInfo, int screen) {
            this.pCfgInfo = pCfgInfo;
        }

        @Override
        public void dispose() {
            OGLRenderQueue rq = OGLRenderQueue.getInstance();
            rq.lock();
            try {
                rq.flushAndInvokeNow(new Runnable(){

                    @Override
                    public void run() {
                        AccelDeviceEventNotifier.eventOccured(screen, 0);
                        AccelDeviceEventNotifier.eventOccured(screen, 1);
                    }
                });
            }
            finally {
                rq.unlock();
            }
            if (this.pCfgInfo != 0L) {
                OGLRenderQueue.disposeGraphicsConfig(this.pCfgInfo);
                this.pCfgInfo = 0L;
            }
        }
    }

    private static class WGLGetConfigInfo
    implements Runnable {
        private int screen;
        private int pixfmt;
        private long cfginfo;

        private WGLGetConfigInfo(int screen, int pixfmt) {
            this.screen = screen;
            this.pixfmt = pixfmt;
        }

        @Override
        public void run() {
            this.cfginfo = WGLGraphicsConfig.getWGLConfigInfo(this.screen, this.pixfmt);
        }

        public long getConfigInfo() {
            return this.cfginfo;
        }
    }
}

