/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.image;

import java.awt.Image;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import sun.awt.AppContext;

public final class ImageCache {
    private final LinkedHashMap<PixelsKey, ImageSoftReference> map = new LinkedHashMap(16, 0.75f, true);
    private final int maxPixelCount;
    private int currentPixelCount = 0;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final ReferenceQueue<Image> referenceQueue = new ReferenceQueue();

    public static ImageCache getInstance() {
        return AppContext.getSoftReferenceValue(ImageCache.class, () -> new ImageCache());
    }

    ImageCache(int maxPixelCount) {
        this.maxPixelCount = maxPixelCount;
    }

    ImageCache() {
        this(0x200000);
    }

    public void flush() {
        this.lock.writeLock().lock();
        try {
            this.map.clear();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public Image getImage(PixelsKey key) {
        ImageSoftReference ref;
        this.lock.readLock().lock();
        try {
            ref = this.map.get(key);
        }
        finally {
            this.lock.readLock().unlock();
        }
        return ref == null ? null : (Image)ref.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setImage(PixelsKey key, Image image) {
        this.lock.writeLock().lock();
        try {
            ImageSoftReference ref = this.map.get(key);
            if (ref != null) {
                if (ref.get() != null) {
                    return;
                }
                this.currentPixelCount -= key.getPixelCount();
                this.map.remove(key);
            }
            int newPixelCount = key.getPixelCount();
            this.currentPixelCount += newPixelCount;
            if (this.currentPixelCount > this.maxPixelCount) {
                while ((ref = (ImageSoftReference)this.referenceQueue.poll()) != null) {
                    this.map.remove(ref.key);
                    this.currentPixelCount -= ref.key.getPixelCount();
                }
            }
            if (this.currentPixelCount > this.maxPixelCount) {
                Iterator<Map.Entry<PixelsKey, ImageSoftReference>> mapIter = this.map.entrySet().iterator();
                while (this.currentPixelCount > this.maxPixelCount && mapIter.hasNext()) {
                    Map.Entry<PixelsKey, ImageSoftReference> entry = mapIter.next();
                    mapIter.remove();
                    Image img = (Image)entry.getValue().get();
                    if (img != null) {
                        img.flush();
                    }
                    this.currentPixelCount -= entry.getValue().key.getPixelCount();
                }
            }
            this.map.put(key, new ImageSoftReference(key, image, this.referenceQueue));
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private static class ImageSoftReference
    extends SoftReference<Image> {
        final PixelsKey key;

        ImageSoftReference(PixelsKey key, Image referent, ReferenceQueue<? super Image> q) {
            super(referent, q);
            this.key = key;
        }
    }

    public static interface PixelsKey {
        public int getPixelCount();
    }
}

