/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.io.PrintStream;
import java.text.AttributedCharacterIterator;
import javax.swing.DebugGraphicsFilter;
import javax.swing.DebugGraphicsInfo;
import javax.swing.DebugGraphicsObserver;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class DebugGraphics
extends Graphics {
    Graphics graphics;
    Image buffer = null;
    int debugOptions;
    int graphicsID = graphicsCount++;
    int xOffset = 0;
    int yOffset = 0;
    private static int graphicsCount = 0;
    private static ImageIcon imageLoadingIcon = new ImageIcon();
    public static final int LOG_OPTION = 1;
    public static final int FLASH_OPTION = 2;
    public static final int BUFFERED_OPTION = 4;
    public static final int NONE_OPTION = -1;
    private static final Class debugGraphicsInfoKey;

    public DebugGraphics() {
    }

    public DebugGraphics(Graphics graphics, JComponent component) {
        this(graphics);
        this.setDebugOptions(component.shouldDebugGraphics());
    }

    public DebugGraphics(Graphics graphics) {
        this();
        this.graphics = graphics;
    }

    @Override
    public Graphics create() {
        DebugGraphics debugGraphics = new DebugGraphics();
        debugGraphics.graphics = this.graphics.create();
        debugGraphics.debugOptions = this.debugOptions;
        debugGraphics.buffer = this.buffer;
        return debugGraphics;
    }

    @Override
    public Graphics create(int x, int y, int width, int height) {
        DebugGraphics debugGraphics = new DebugGraphics();
        debugGraphics.graphics = this.graphics.create(x, y, width, height);
        debugGraphics.debugOptions = this.debugOptions;
        debugGraphics.buffer = this.buffer;
        debugGraphics.xOffset = this.xOffset + x;
        debugGraphics.yOffset = this.yOffset + y;
        return debugGraphics;
    }

    public static void setFlashColor(Color flashColor) {
        DebugGraphics.info().flashColor = flashColor;
    }

    public static Color flashColor() {
        return DebugGraphics.info().flashColor;
    }

    public static void setFlashTime(int flashTime) {
        DebugGraphics.info().flashTime = flashTime;
    }

    public static int flashTime() {
        return DebugGraphics.info().flashTime;
    }

    public static void setFlashCount(int flashCount) {
        DebugGraphics.info().flashCount = flashCount;
    }

    public static int flashCount() {
        return DebugGraphics.info().flashCount;
    }

    public static void setLogStream(PrintStream stream) {
        DebugGraphics.info().stream = stream;
    }

    public static PrintStream logStream() {
        return DebugGraphics.info().stream;
    }

    @Override
    public void setFont(Font aFont) {
        if (this.debugLog()) {
            DebugGraphics.info().log(this.toShortString() + " Setting font: " + aFont);
        }
        this.graphics.setFont(aFont);
    }

    @Override
    public Font getFont() {
        return this.graphics.getFont();
    }

    @Override
    public void setColor(Color aColor) {
        if (this.debugLog()) {
            DebugGraphics.info().log(this.toShortString() + " Setting color: " + aColor);
        }
        this.graphics.setColor(aColor);
    }

    @Override
    public Color getColor() {
        return this.graphics.getColor();
    }

    @Override
    public FontMetrics getFontMetrics() {
        return this.graphics.getFontMetrics();
    }

    @Override
    public FontMetrics getFontMetrics(Font f) {
        return this.graphics.getFontMetrics(f);
    }

    @Override
    public void translate(int x, int y) {
        if (this.debugLog()) {
            DebugGraphics.info().log(this.toShortString() + " Translating by: " + new Point(x, y));
        }
        this.xOffset += x;
        this.yOffset += y;
        this.graphics.translate(x, y);
    }

    @Override
    public void setPaintMode() {
        if (this.debugLog()) {
            DebugGraphics.info().log(this.toShortString() + " Setting paint mode");
        }
        this.graphics.setPaintMode();
    }

    @Override
    public void setXORMode(Color aColor) {
        if (this.debugLog()) {
            DebugGraphics.info().log(this.toShortString() + " Setting XOR mode: " + aColor);
        }
        this.graphics.setXORMode(aColor);
    }

    @Override
    public Rectangle getClipBounds() {
        return this.graphics.getClipBounds();
    }

    @Override
    public void clipRect(int x, int y, int width, int height) {
        this.graphics.clipRect(x, y, width, height);
        if (this.debugLog()) {
            DebugGraphics.info().log(this.toShortString() + " Setting clipRect: " + new Rectangle(x, y, width, height) + " New clipRect: " + this.graphics.getClip());
        }
    }

    @Override
    public void setClip(int x, int y, int width, int height) {
        this.graphics.setClip(x, y, width, height);
        if (this.debugLog()) {
            DebugGraphics.info().log(this.toShortString() + " Setting new clipRect: " + this.graphics.getClip());
        }
    }

    @Override
    public Shape getClip() {
        return this.graphics.getClip();
    }

    @Override
    public void setClip(Shape clip) {
        this.graphics.setClip(clip);
        if (this.debugLog()) {
            DebugGraphics.info().log(this.toShortString() + " Setting new clipRect: " + this.graphics.getClip());
        }
    }

    @Override
    public void drawRect(int x, int y, int width, int height) {
        DebugGraphicsInfo info = DebugGraphics.info();
        if (this.debugLog()) {
            DebugGraphics.info().log(this.toShortString() + " Drawing rect: " + new Rectangle(x, y, width, height));
        }
        if (this.isDrawingBuffer()) {
            if (this.debugBuffered()) {
                Graphics debugGraphics = this.debugGraphics();
                debugGraphics.drawRect(x, y, width, height);
                debugGraphics.dispose();
            }
        } else if (this.debugFlash()) {
            Color oldColor = this.getColor();
            int count = info.flashCount * 2 - 1;
            for (int i = 0; i < count; ++i) {
                this.graphics.setColor(i % 2 == 0 ? info.flashColor : oldColor);
                this.graphics.drawRect(x, y, width, height);
                Toolkit.getDefaultToolkit().sync();
                this.sleep(info.flashTime);
            }
            this.graphics.setColor(oldColor);
        }
        this.graphics.drawRect(x, y, width, height);
    }

    @Override
    public void fillRect(int x, int y, int width, int height) {
        DebugGraphicsInfo info = DebugGraphics.info();
        if (this.debugLog()) {
            DebugGraphics.info().log(this.toShortString() + " Filling rect: " + new Rectangle(x, y, width, height));
        }
        if (this.isDrawingBuffer()) {
            if (this.debugBuffered()) {
                Graphics debugGraphics = this.debugGraphics();
                debugGraphics.fillRect(x, y, width, height);
                debugGraphics.dispose();
            }
        } else if (this.debugFlash()) {
            Color oldColor = this.getColor();
            int count = info.flashCount * 2 - 1;
            for (int i = 0; i < count; ++i) {
                this.graphics.setColor(i % 2 == 0 ? info.flashColor : oldColor);
                this.graphics.fillRect(x, y, width, height);
                Toolkit.getDefaultToolkit().sync();
                this.sleep(info.flashTime);
            }
            this.graphics.setColor(oldColor);
        }
        this.graphics.fillRect(x, y, width, height);
    }

    @Override
    public void clearRect(int x, int y, int width, int height) {
        DebugGraphicsInfo info = DebugGraphics.info();
        if (this.debugLog()) {
            DebugGraphics.info().log(this.toShortString() + " Clearing rect: " + new Rectangle(x, y, width, height));
        }
        if (this.isDrawingBuffer()) {
            if (this.debugBuffered()) {
                Graphics debugGraphics = this.debugGraphics();
                debugGraphics.clearRect(x, y, width, height);
                debugGraphics.dispose();
            }
        } else if (this.debugFlash()) {
            Color oldColor = this.getColor();
            int count = info.flashCount * 2 - 1;
            for (int i = 0; i < count; ++i) {
                this.graphics.setColor(i % 2 == 0 ? info.flashColor : oldColor);
                this.graphics.clearRect(x, y, width, height);
                Toolkit.getDefaultToolkit().sync();
                this.sleep(info.flashTime);
            }
            this.graphics.setColor(oldColor);
        }
        this.graphics.clearRect(x, y, width, height);
    }

    @Override
    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        DebugGraphicsInfo info = DebugGraphics.info();
        if (this.debugLog()) {
            DebugGraphics.info().log(this.toShortString() + " Drawing round rect: " + new Rectangle(x, y, width, height) + " arcWidth: " + arcWidth + " archHeight: " + arcHeight);
        }
        if (this.isDrawingBuffer()) {
            if (this.debugBuffered()) {
                Graphics debugGraphics = this.debugGraphics();
                debugGraphics.drawRoundRect(x, y, width, height, arcWidth, arcHeight);
                debugGraphics.dispose();
            }
        } else if (this.debugFlash()) {
            Color oldColor = this.getColor();
            int count = info.flashCount * 2 - 1;
            for (int i = 0; i < count; ++i) {
                this.graphics.setColor(i % 2 == 0 ? info.flashColor : oldColor);
                this.graphics.drawRoundRect(x, y, width, height, arcWidth, arcHeight);
                Toolkit.getDefaultToolkit().sync();
                this.sleep(info.flashTime);
            }
            this.graphics.setColor(oldColor);
        }
        this.graphics.drawRoundRect(x, y, width, height, arcWidth, arcHeight);
    }

    @Override
    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        DebugGraphicsInfo info = DebugGraphics.info();
        if (this.debugLog()) {
            DebugGraphics.info().log(this.toShortString() + " Filling round rect: " + new Rectangle(x, y, width, height) + " arcWidth: " + arcWidth + " archHeight: " + arcHeight);
        }
        if (this.isDrawingBuffer()) {
            if (this.debugBuffered()) {
                Graphics debugGraphics = this.debugGraphics();
                debugGraphics.fillRoundRect(x, y, width, height, arcWidth, arcHeight);
                debugGraphics.dispose();
            }
        } else if (this.debugFlash()) {
            Color oldColor = this.getColor();
            int count = info.flashCount * 2 - 1;
            for (int i = 0; i < count; ++i) {
                this.graphics.setColor(i % 2 == 0 ? info.flashColor : oldColor);
                this.graphics.fillRoundRect(x, y, width, height, arcWidth, arcHeight);
                Toolkit.getDefaultToolkit().sync();
                this.sleep(info.flashTime);
            }
            this.graphics.setColor(oldColor);
        }
        this.graphics.fillRoundRect(x, y, width, height, arcWidth, arcHeight);
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2) {
        DebugGraphicsInfo info = DebugGraphics.info();
        if (this.debugLog()) {
            DebugGraphics.info().log(this.toShortString() + " Drawing line: from " + this.pointToString(x1, y1) + " to " + this.pointToString(x2, y2));
        }
        if (this.isDrawingBuffer()) {
            if (this.debugBuffered()) {
                Graphics debugGraphics = this.debugGraphics();
                debugGraphics.drawLine(x1, y1, x2, y2);
                debugGraphics.dispose();
            }
        } else if (this.debugFlash()) {
            Color oldColor = this.getColor();
            int count = info.flashCount * 2 - 1;
            for (int i = 0; i < count; ++i) {
                this.graphics.setColor(i % 2 == 0 ? info.flashColor : oldColor);
                this.graphics.drawLine(x1, y1, x2, y2);
                Toolkit.getDefaultToolkit().sync();
                this.sleep(info.flashTime);
            }
            this.graphics.setColor(oldColor);
        }
        this.graphics.drawLine(x1, y1, x2, y2);
    }

    @Override
    public void draw3DRect(int x, int y, int width, int height, boolean raised) {
        DebugGraphicsInfo info = DebugGraphics.info();
        if (this.debugLog()) {
            DebugGraphics.info().log(this.toShortString() + " Drawing 3D rect: " + new Rectangle(x, y, width, height) + " Raised bezel: " + raised);
        }
        if (this.isDrawingBuffer()) {
            if (this.debugBuffered()) {
                Graphics debugGraphics = this.debugGraphics();
                debugGraphics.draw3DRect(x, y, width, height, raised);
                debugGraphics.dispose();
            }
        } else if (this.debugFlash()) {
            Color oldColor = this.getColor();
            int count = info.flashCount * 2 - 1;
            for (int i = 0; i < count; ++i) {
                this.graphics.setColor(i % 2 == 0 ? info.flashColor : oldColor);
                this.graphics.draw3DRect(x, y, width, height, raised);
                Toolkit.getDefaultToolkit().sync();
                this.sleep(info.flashTime);
            }
            this.graphics.setColor(oldColor);
        }
        this.graphics.draw3DRect(x, y, width, height, raised);
    }

    @Override
    public void fill3DRect(int x, int y, int width, int height, boolean raised) {
        DebugGraphicsInfo info = DebugGraphics.info();
        if (this.debugLog()) {
            DebugGraphics.info().log(this.toShortString() + " Filling 3D rect: " + new Rectangle(x, y, width, height) + " Raised bezel: " + raised);
        }
        if (this.isDrawingBuffer()) {
            if (this.debugBuffered()) {
                Graphics debugGraphics = this.debugGraphics();
                debugGraphics.fill3DRect(x, y, width, height, raised);
                debugGraphics.dispose();
            }
        } else if (this.debugFlash()) {
            Color oldColor = this.getColor();
            int count = info.flashCount * 2 - 1;
            for (int i = 0; i < count; ++i) {
                this.graphics.setColor(i % 2 == 0 ? info.flashColor : oldColor);
                this.graphics.fill3DRect(x, y, width, height, raised);
                Toolkit.getDefaultToolkit().sync();
                this.sleep(info.flashTime);
            }
            this.graphics.setColor(oldColor);
        }
        this.graphics.fill3DRect(x, y, width, height, raised);
    }

    @Override
    public void drawOval(int x, int y, int width, int height) {
        DebugGraphicsInfo info = DebugGraphics.info();
        if (this.debugLog()) {
            DebugGraphics.info().log(this.toShortString() + " Drawing oval: " + new Rectangle(x, y, width, height));
        }
        if (this.isDrawingBuffer()) {
            if (this.debugBuffered()) {
                Graphics debugGraphics = this.debugGraphics();
                debugGraphics.drawOval(x, y, width, height);
                debugGraphics.dispose();
            }
        } else if (this.debugFlash()) {
            Color oldColor = this.getColor();
            int count = info.flashCount * 2 - 1;
            for (int i = 0; i < count; ++i) {
                this.graphics.setColor(i % 2 == 0 ? info.flashColor : oldColor);
                this.graphics.drawOval(x, y, width, height);
                Toolkit.getDefaultToolkit().sync();
                this.sleep(info.flashTime);
            }
            this.graphics.setColor(oldColor);
        }
        this.graphics.drawOval(x, y, width, height);
    }

    @Override
    public void fillOval(int x, int y, int width, int height) {
        DebugGraphicsInfo info = DebugGraphics.info();
        if (this.debugLog()) {
            DebugGraphics.info().log(this.toShortString() + " Filling oval: " + new Rectangle(x, y, width, height));
        }
        if (this.isDrawingBuffer()) {
            if (this.debugBuffered()) {
                Graphics debugGraphics = this.debugGraphics();
                debugGraphics.fillOval(x, y, width, height);
                debugGraphics.dispose();
            }
        } else if (this.debugFlash()) {
            Color oldColor = this.getColor();
            int count = info.flashCount * 2 - 1;
            for (int i = 0; i < count; ++i) {
                this.graphics.setColor(i % 2 == 0 ? info.flashColor : oldColor);
                this.graphics.fillOval(x, y, width, height);
                Toolkit.getDefaultToolkit().sync();
                this.sleep(info.flashTime);
            }
            this.graphics.setColor(oldColor);
        }
        this.graphics.fillOval(x, y, width, height);
    }

    @Override
    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        DebugGraphicsInfo info = DebugGraphics.info();
        if (this.debugLog()) {
            DebugGraphics.info().log(this.toShortString() + " Drawing arc: " + new Rectangle(x, y, width, height) + " startAngle: " + startAngle + " arcAngle: " + arcAngle);
        }
        if (this.isDrawingBuffer()) {
            if (this.debugBuffered()) {
                Graphics debugGraphics = this.debugGraphics();
                debugGraphics.drawArc(x, y, width, height, startAngle, arcAngle);
                debugGraphics.dispose();
            }
        } else if (this.debugFlash()) {
            Color oldColor = this.getColor();
            int count = info.flashCount * 2 - 1;
            for (int i = 0; i < count; ++i) {
                this.graphics.setColor(i % 2 == 0 ? info.flashColor : oldColor);
                this.graphics.drawArc(x, y, width, height, startAngle, arcAngle);
                Toolkit.getDefaultToolkit().sync();
                this.sleep(info.flashTime);
            }
            this.graphics.setColor(oldColor);
        }
        this.graphics.drawArc(x, y, width, height, startAngle, arcAngle);
    }

    @Override
    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        DebugGraphicsInfo info = DebugGraphics.info();
        if (this.debugLog()) {
            DebugGraphics.info().log(this.toShortString() + " Filling arc: " + new Rectangle(x, y, width, height) + " startAngle: " + startAngle + " arcAngle: " + arcAngle);
        }
        if (this.isDrawingBuffer()) {
            if (this.debugBuffered()) {
                Graphics debugGraphics = this.debugGraphics();
                debugGraphics.fillArc(x, y, width, height, startAngle, arcAngle);
                debugGraphics.dispose();
            }
        } else if (this.debugFlash()) {
            Color oldColor = this.getColor();
            int count = info.flashCount * 2 - 1;
            for (int i = 0; i < count; ++i) {
                this.graphics.setColor(i % 2 == 0 ? info.flashColor : oldColor);
                this.graphics.fillArc(x, y, width, height, startAngle, arcAngle);
                Toolkit.getDefaultToolkit().sync();
                this.sleep(info.flashTime);
            }
            this.graphics.setColor(oldColor);
        }
        this.graphics.fillArc(x, y, width, height, startAngle, arcAngle);
    }

    @Override
    public void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {
        DebugGraphicsInfo info = DebugGraphics.info();
        if (this.debugLog()) {
            DebugGraphics.info().log(this.toShortString() + " Drawing polyline:  nPoints: " + nPoints + " X's: " + xPoints + " Y's: " + yPoints);
        }
        if (this.isDrawingBuffer()) {
            if (this.debugBuffered()) {
                Graphics debugGraphics = this.debugGraphics();
                debugGraphics.drawPolyline(xPoints, yPoints, nPoints);
                debugGraphics.dispose();
            }
        } else if (this.debugFlash()) {
            Color oldColor = this.getColor();
            int count = info.flashCount * 2 - 1;
            for (int i = 0; i < count; ++i) {
                this.graphics.setColor(i % 2 == 0 ? info.flashColor : oldColor);
                this.graphics.drawPolyline(xPoints, yPoints, nPoints);
                Toolkit.getDefaultToolkit().sync();
                this.sleep(info.flashTime);
            }
            this.graphics.setColor(oldColor);
        }
        this.graphics.drawPolyline(xPoints, yPoints, nPoints);
    }

    @Override
    public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        DebugGraphicsInfo info = DebugGraphics.info();
        if (this.debugLog()) {
            DebugGraphics.info().log(this.toShortString() + " Drawing polygon:  nPoints: " + nPoints + " X's: " + xPoints + " Y's: " + yPoints);
        }
        if (this.isDrawingBuffer()) {
            if (this.debugBuffered()) {
                Graphics debugGraphics = this.debugGraphics();
                debugGraphics.drawPolygon(xPoints, yPoints, nPoints);
                debugGraphics.dispose();
            }
        } else if (this.debugFlash()) {
            Color oldColor = this.getColor();
            int count = info.flashCount * 2 - 1;
            for (int i = 0; i < count; ++i) {
                this.graphics.setColor(i % 2 == 0 ? info.flashColor : oldColor);
                this.graphics.drawPolygon(xPoints, yPoints, nPoints);
                Toolkit.getDefaultToolkit().sync();
                this.sleep(info.flashTime);
            }
            this.graphics.setColor(oldColor);
        }
        this.graphics.drawPolygon(xPoints, yPoints, nPoints);
    }

    @Override
    public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        DebugGraphicsInfo info = DebugGraphics.info();
        if (this.debugLog()) {
            DebugGraphics.info().log(this.toShortString() + " Filling polygon:  nPoints: " + nPoints + " X's: " + xPoints + " Y's: " + yPoints);
        }
        if (this.isDrawingBuffer()) {
            if (this.debugBuffered()) {
                Graphics debugGraphics = this.debugGraphics();
                debugGraphics.fillPolygon(xPoints, yPoints, nPoints);
                debugGraphics.dispose();
            }
        } else if (this.debugFlash()) {
            Color oldColor = this.getColor();
            int count = info.flashCount * 2 - 1;
            for (int i = 0; i < count; ++i) {
                this.graphics.setColor(i % 2 == 0 ? info.flashColor : oldColor);
                this.graphics.fillPolygon(xPoints, yPoints, nPoints);
                Toolkit.getDefaultToolkit().sync();
                this.sleep(info.flashTime);
            }
            this.graphics.setColor(oldColor);
        }
        this.graphics.fillPolygon(xPoints, yPoints, nPoints);
    }

    @Override
    public void drawString(String aString, int x, int y) {
        DebugGraphicsInfo info = DebugGraphics.info();
        if (this.debugLog()) {
            DebugGraphics.info().log(this.toShortString() + " Drawing string: \"" + aString + "\" at: " + new Point(x, y));
        }
        if (this.isDrawingBuffer()) {
            if (this.debugBuffered()) {
                Graphics debugGraphics = this.debugGraphics();
                debugGraphics.drawString(aString, x, y);
                debugGraphics.dispose();
            }
        } else if (this.debugFlash()) {
            Color oldColor = this.getColor();
            int count = info.flashCount * 2 - 1;
            for (int i = 0; i < count; ++i) {
                this.graphics.setColor(i % 2 == 0 ? info.flashColor : oldColor);
                this.graphics.drawString(aString, x, y);
                Toolkit.getDefaultToolkit().sync();
                this.sleep(info.flashTime);
            }
            this.graphics.setColor(oldColor);
        }
        this.graphics.drawString(aString, x, y);
    }

    @Override
    public void drawString(AttributedCharacterIterator iterator, int x, int y) {
        DebugGraphicsInfo info = DebugGraphics.info();
        if (this.debugLog()) {
            DebugGraphics.info().log(this.toShortString() + " Drawing text: \"" + iterator + "\" at: " + new Point(x, y));
        }
        if (this.isDrawingBuffer()) {
            if (this.debugBuffered()) {
                Graphics debugGraphics = this.debugGraphics();
                debugGraphics.drawString(iterator, x, y);
                debugGraphics.dispose();
            }
        } else if (this.debugFlash()) {
            Color oldColor = this.getColor();
            int count = info.flashCount * 2 - 1;
            for (int i = 0; i < count; ++i) {
                this.graphics.setColor(i % 2 == 0 ? info.flashColor : oldColor);
                this.graphics.drawString(iterator, x, y);
                Toolkit.getDefaultToolkit().sync();
                this.sleep(info.flashTime);
            }
            this.graphics.setColor(oldColor);
        }
        this.graphics.drawString(iterator, x, y);
    }

    @Override
    public void drawBytes(byte[] data, int offset, int length, int x, int y) {
        DebugGraphicsInfo info = DebugGraphics.info();
        Font font = this.graphics.getFont();
        if (this.debugLog()) {
            DebugGraphics.info().log(this.toShortString() + " Drawing bytes at: " + new Point(x, y));
        }
        if (this.isDrawingBuffer()) {
            if (this.debugBuffered()) {
                Graphics debugGraphics = this.debugGraphics();
                debugGraphics.drawBytes(data, offset, length, x, y);
                debugGraphics.dispose();
            }
        } else if (this.debugFlash()) {
            Color oldColor = this.getColor();
            int count = info.flashCount * 2 - 1;
            for (int i = 0; i < count; ++i) {
                this.graphics.setColor(i % 2 == 0 ? info.flashColor : oldColor);
                this.graphics.drawBytes(data, offset, length, x, y);
                Toolkit.getDefaultToolkit().sync();
                this.sleep(info.flashTime);
            }
            this.graphics.setColor(oldColor);
        }
        this.graphics.drawBytes(data, offset, length, x, y);
    }

    @Override
    public void drawChars(char[] data, int offset, int length, int x, int y) {
        DebugGraphicsInfo info = DebugGraphics.info();
        Font font = this.graphics.getFont();
        if (this.debugLog()) {
            DebugGraphics.info().log(this.toShortString() + " Drawing chars at " + new Point(x, y));
        }
        if (this.isDrawingBuffer()) {
            if (this.debugBuffered()) {
                Graphics debugGraphics = this.debugGraphics();
                debugGraphics.drawChars(data, offset, length, x, y);
                debugGraphics.dispose();
            }
        } else if (this.debugFlash()) {
            Color oldColor = this.getColor();
            int count = info.flashCount * 2 - 1;
            for (int i = 0; i < count; ++i) {
                this.graphics.setColor(i % 2 == 0 ? info.flashColor : oldColor);
                this.graphics.drawChars(data, offset, length, x, y);
                Toolkit.getDefaultToolkit().sync();
                this.sleep(info.flashTime);
            }
            this.graphics.setColor(oldColor);
        }
        this.graphics.drawChars(data, offset, length, x, y);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
        DebugGraphicsInfo info = DebugGraphics.info();
        if (this.debugLog()) {
            info.log(this.toShortString() + " Drawing image: " + img + " at: " + new Point(x, y));
        }
        if (this.isDrawingBuffer()) {
            if (this.debugBuffered()) {
                Graphics debugGraphics = this.debugGraphics();
                debugGraphics.drawImage(img, x, y, observer);
                debugGraphics.dispose();
            }
        } else if (this.debugFlash()) {
            int count = info.flashCount * 2 - 1;
            ImageProducer oldProducer = img.getSource();
            FilteredImageSource newProducer = new FilteredImageSource(oldProducer, new DebugGraphicsFilter(info.flashColor));
            Image newImage = Toolkit.getDefaultToolkit().createImage(newProducer);
            DebugGraphicsObserver imageObserver = new DebugGraphicsObserver();
            for (int i = 0; i < count; ++i) {
                Image imageToDraw = i % 2 == 0 ? newImage : img;
                DebugGraphics.loadImage(imageToDraw);
                this.graphics.drawImage(imageToDraw, x, y, imageObserver);
                Toolkit.getDefaultToolkit().sync();
                this.sleep(info.flashTime);
            }
        }
        return this.graphics.drawImage(img, x, y, observer);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver observer) {
        DebugGraphicsInfo info = DebugGraphics.info();
        if (this.debugLog()) {
            info.log(this.toShortString() + " Drawing image: " + img + " at: " + new Rectangle(x, y, width, height));
        }
        if (this.isDrawingBuffer()) {
            if (this.debugBuffered()) {
                Graphics debugGraphics = this.debugGraphics();
                debugGraphics.drawImage(img, x, y, width, height, observer);
                debugGraphics.dispose();
            }
        } else if (this.debugFlash()) {
            int count = info.flashCount * 2 - 1;
            ImageProducer oldProducer = img.getSource();
            FilteredImageSource newProducer = new FilteredImageSource(oldProducer, new DebugGraphicsFilter(info.flashColor));
            Image newImage = Toolkit.getDefaultToolkit().createImage(newProducer);
            DebugGraphicsObserver imageObserver = new DebugGraphicsObserver();
            for (int i = 0; i < count; ++i) {
                Image imageToDraw = i % 2 == 0 ? newImage : img;
                DebugGraphics.loadImage(imageToDraw);
                this.graphics.drawImage(imageToDraw, x, y, width, height, imageObserver);
                Toolkit.getDefaultToolkit().sync();
                this.sleep(info.flashTime);
            }
        }
        return this.graphics.drawImage(img, x, y, width, height, observer);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, Color bgcolor, ImageObserver observer) {
        DebugGraphicsInfo info = DebugGraphics.info();
        if (this.debugLog()) {
            info.log(this.toShortString() + " Drawing image: " + img + " at: " + new Point(x, y) + ", bgcolor: " + bgcolor);
        }
        if (this.isDrawingBuffer()) {
            if (this.debugBuffered()) {
                Graphics debugGraphics = this.debugGraphics();
                debugGraphics.drawImage(img, x, y, bgcolor, observer);
                debugGraphics.dispose();
            }
        } else if (this.debugFlash()) {
            int count = info.flashCount * 2 - 1;
            ImageProducer oldProducer = img.getSource();
            FilteredImageSource newProducer = new FilteredImageSource(oldProducer, new DebugGraphicsFilter(info.flashColor));
            Image newImage = Toolkit.getDefaultToolkit().createImage(newProducer);
            DebugGraphicsObserver imageObserver = new DebugGraphicsObserver();
            for (int i = 0; i < count; ++i) {
                Image imageToDraw = i % 2 == 0 ? newImage : img;
                DebugGraphics.loadImage(imageToDraw);
                this.graphics.drawImage(imageToDraw, x, y, bgcolor, imageObserver);
                Toolkit.getDefaultToolkit().sync();
                this.sleep(info.flashTime);
            }
        }
        return this.graphics.drawImage(img, x, y, bgcolor, observer);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int width, int height, Color bgcolor, ImageObserver observer) {
        DebugGraphicsInfo info = DebugGraphics.info();
        if (this.debugLog()) {
            info.log(this.toShortString() + " Drawing image: " + img + " at: " + new Rectangle(x, y, width, height) + ", bgcolor: " + bgcolor);
        }
        if (this.isDrawingBuffer()) {
            if (this.debugBuffered()) {
                Graphics debugGraphics = this.debugGraphics();
                debugGraphics.drawImage(img, x, y, width, height, bgcolor, observer);
                debugGraphics.dispose();
            }
        } else if (this.debugFlash()) {
            int count = info.flashCount * 2 - 1;
            ImageProducer oldProducer = img.getSource();
            FilteredImageSource newProducer = new FilteredImageSource(oldProducer, new DebugGraphicsFilter(info.flashColor));
            Image newImage = Toolkit.getDefaultToolkit().createImage(newProducer);
            DebugGraphicsObserver imageObserver = new DebugGraphicsObserver();
            for (int i = 0; i < count; ++i) {
                Image imageToDraw = i % 2 == 0 ? newImage : img;
                DebugGraphics.loadImage(imageToDraw);
                this.graphics.drawImage(imageToDraw, x, y, width, height, bgcolor, imageObserver);
                Toolkit.getDefaultToolkit().sync();
                this.sleep(info.flashTime);
            }
        }
        return this.graphics.drawImage(img, x, y, width, height, bgcolor, observer);
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        DebugGraphicsInfo info = DebugGraphics.info();
        if (this.debugLog()) {
            info.log(this.toShortString() + " Drawing image: " + img + " destination: " + new Rectangle(dx1, dy1, dx2, dy2) + " source: " + new Rectangle(sx1, sy1, sx2, sy2));
        }
        if (this.isDrawingBuffer()) {
            if (this.debugBuffered()) {
                Graphics debugGraphics = this.debugGraphics();
                debugGraphics.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, observer);
                debugGraphics.dispose();
            }
        } else if (this.debugFlash()) {
            int count = info.flashCount * 2 - 1;
            ImageProducer oldProducer = img.getSource();
            FilteredImageSource newProducer = new FilteredImageSource(oldProducer, new DebugGraphicsFilter(info.flashColor));
            Image newImage = Toolkit.getDefaultToolkit().createImage(newProducer);
            DebugGraphicsObserver imageObserver = new DebugGraphicsObserver();
            for (int i = 0; i < count; ++i) {
                Image imageToDraw = i % 2 == 0 ? newImage : img;
                DebugGraphics.loadImage(imageToDraw);
                this.graphics.drawImage(imageToDraw, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, imageObserver);
                Toolkit.getDefaultToolkit().sync();
                this.sleep(info.flashTime);
            }
        }
        return this.graphics.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, observer);
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver observer) {
        DebugGraphicsInfo info = DebugGraphics.info();
        if (this.debugLog()) {
            info.log(this.toShortString() + " Drawing image: " + img + " destination: " + new Rectangle(dx1, dy1, dx2, dy2) + " source: " + new Rectangle(sx1, sy1, sx2, sy2) + ", bgcolor: " + bgcolor);
        }
        if (this.isDrawingBuffer()) {
            if (this.debugBuffered()) {
                Graphics debugGraphics = this.debugGraphics();
                debugGraphics.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, bgcolor, observer);
                debugGraphics.dispose();
            }
        } else if (this.debugFlash()) {
            int count = info.flashCount * 2 - 1;
            ImageProducer oldProducer = img.getSource();
            FilteredImageSource newProducer = new FilteredImageSource(oldProducer, new DebugGraphicsFilter(info.flashColor));
            Image newImage = Toolkit.getDefaultToolkit().createImage(newProducer);
            DebugGraphicsObserver imageObserver = new DebugGraphicsObserver();
            for (int i = 0; i < count; ++i) {
                Image imageToDraw = i % 2 == 0 ? newImage : img;
                DebugGraphics.loadImage(imageToDraw);
                this.graphics.drawImage(imageToDraw, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, bgcolor, imageObserver);
                Toolkit.getDefaultToolkit().sync();
                this.sleep(info.flashTime);
            }
        }
        return this.graphics.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, bgcolor, observer);
    }

    static void loadImage(Image img) {
        imageLoadingIcon.loadImage(img);
    }

    @Override
    public void copyArea(int x, int y, int width, int height, int destX, int destY) {
        if (this.debugLog()) {
            DebugGraphics.info().log(this.toShortString() + " Copying area from: " + new Rectangle(x, y, width, height) + " to: " + new Point(destX, destY));
        }
        this.graphics.copyArea(x, y, width, height, destX, destY);
    }

    final void sleep(int mSecs) {
        try {
            Thread.sleep(mSecs);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void dispose() {
        this.graphics.dispose();
        this.graphics = null;
    }

    public boolean isDrawingBuffer() {
        return this.buffer != null;
    }

    String toShortString() {
        return "Graphics" + (this.isDrawingBuffer() ? "<B>" : "") + "(" + this.graphicsID + "-" + this.debugOptions + ")";
    }

    String pointToString(int x, int y) {
        return "(" + x + ", " + y + ")";
    }

    public void setDebugOptions(int options) {
        if (options != 0) {
            if (options == -1) {
                if (this.debugOptions != 0) {
                    System.err.println(this.toShortString() + " Disabling debug");
                    this.debugOptions = 0;
                }
            } else if (this.debugOptions != options) {
                this.debugOptions |= options;
                if (this.debugLog()) {
                    System.err.println(this.toShortString() + " Enabling debug");
                }
            }
        }
    }

    public int getDebugOptions() {
        return this.debugOptions;
    }

    static void setDebugOptions(JComponent component, int options) {
        DebugGraphics.info().setDebugOptions(component, options);
    }

    static int getDebugOptions(JComponent component) {
        DebugGraphicsInfo debugGraphicsInfo = DebugGraphics.info();
        if (debugGraphicsInfo == null) {
            return 0;
        }
        return debugGraphicsInfo.getDebugOptions(component);
    }

    static int shouldComponentDebug(JComponent component) {
        DebugGraphicsInfo info = DebugGraphics.info();
        if (info == null) {
            return 0;
        }
        int debugOptions = 0;
        for (Container container = component; container != null && container instanceof JComponent; container = container.getParent()) {
            debugOptions |= info.getDebugOptions((JComponent)container);
        }
        return debugOptions;
    }

    static int debugComponentCount() {
        DebugGraphicsInfo debugGraphicsInfo = DebugGraphics.info();
        if (debugGraphicsInfo != null && debugGraphicsInfo.componentToDebug != null) {
            return debugGraphicsInfo.componentToDebug.size();
        }
        return 0;
    }

    boolean debugLog() {
        return (this.debugOptions & 1) == 1;
    }

    boolean debugFlash() {
        return (this.debugOptions & 2) == 2;
    }

    boolean debugBuffered() {
        return (this.debugOptions & 4) == 4;
    }

    private Graphics debugGraphics() {
        DebugGraphicsInfo info = DebugGraphics.info();
        if (info.debugFrame == null) {
            info.debugFrame = new JFrame();
            info.debugFrame.setSize(500, 500);
        }
        JFrame debugFrame = info.debugFrame;
        debugFrame.show();
        DebugGraphics debugGraphics = new DebugGraphics(debugFrame.getGraphics());
        debugGraphics.setFont(this.getFont());
        debugGraphics.setColor(this.getColor());
        debugGraphics.translate(this.xOffset, this.yOffset);
        debugGraphics.setClip(this.getClipBounds());
        if (this.debugFlash()) {
            debugGraphics.setDebugOptions(2);
        }
        return debugGraphics;
    }

    static DebugGraphicsInfo info() {
        DebugGraphicsInfo debugGraphicsInfo = (DebugGraphicsInfo)SwingUtilities.appContextGet(debugGraphicsInfoKey);
        if (debugGraphicsInfo == null) {
            debugGraphicsInfo = new DebugGraphicsInfo();
            SwingUtilities.appContextPut(debugGraphicsInfoKey, debugGraphicsInfo);
        }
        return debugGraphicsInfo;
    }

    static {
        JComponent.DEBUG_GRAPHICS_LOADED = true;
        debugGraphicsInfoKey = DebugGraphicsInfo.class;
    }
}

