/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import com.sun.java.swing.plaf.windows.TMSchema;
import com.sun.java.swing.plaf.windows.XPStyle;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.plaf.basic.BasicScrollBarUI;

public class WindowsScrollBarUI
extends BasicScrollBarUI {
    private Grid thumbGrid;
    private Grid highlightGrid;
    private Dimension horizontalThumbSize;
    private Dimension verticalThumbSize;

    public static ComponentUI createUI(JComponent c) {
        return new WindowsScrollBarUI();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        XPStyle xp = XPStyle.getXP();
        if (xp != null) {
            this.scrollbar.setBorder(null);
            this.horizontalThumbSize = WindowsScrollBarUI.getSize(this.scrollbar, xp, TMSchema.Part.SBP_THUMBBTNHORZ);
            this.verticalThumbSize = WindowsScrollBarUI.getSize(this.scrollbar, xp, TMSchema.Part.SBP_THUMBBTNVERT);
        } else {
            this.horizontalThumbSize = null;
            this.verticalThumbSize = null;
        }
    }

    private static Dimension getSize(Component component, XPStyle xp, TMSchema.Part part) {
        XPStyle.Skin skin = xp.getSkin(component, part);
        return new Dimension(skin.getWidth(), skin.getHeight());
    }

    @Override
    protected Dimension getMinimumThumbSize() {
        if (this.horizontalThumbSize == null || this.verticalThumbSize == null) {
            return super.getMinimumThumbSize();
        }
        return 0 == this.scrollbar.getOrientation() ? this.horizontalThumbSize : this.verticalThumbSize;
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        this.highlightGrid = null;
        this.thumbGrid = null;
    }

    @Override
    protected void configureScrollBarColors() {
        super.configureScrollBarColors();
        Color color = UIManager.getColor("ScrollBar.trackForeground");
        if (color != null && this.trackColor != null) {
            this.thumbGrid = Grid.getGrid(color, this.trackColor);
        }
        if ((color = UIManager.getColor("ScrollBar.trackHighlightForeground")) != null && this.trackHighlightColor != null) {
            this.highlightGrid = Grid.getGrid(color, this.trackHighlightColor);
        }
    }

    @Override
    protected JButton createDecreaseButton(int orientation) {
        return new WindowsArrowButton(orientation, UIManager.getColor("ScrollBar.thumb"), UIManager.getColor("ScrollBar.thumbShadow"), UIManager.getColor("ScrollBar.thumbDarkShadow"), UIManager.getColor("ScrollBar.thumbHighlight"));
    }

    @Override
    protected JButton createIncreaseButton(int orientation) {
        return new WindowsArrowButton(orientation, UIManager.getColor("ScrollBar.thumb"), UIManager.getColor("ScrollBar.thumbShadow"), UIManager.getColor("ScrollBar.thumbDarkShadow"), UIManager.getColor("ScrollBar.thumbHighlight"));
    }

    @Override
    protected BasicScrollBarUI.ArrowButtonListener createArrowButtonListener() {
        if (XPStyle.isVista()) {
            return new BasicScrollBarUI.ArrowButtonListener(){

                @Override
                public void mouseEntered(MouseEvent evt) {
                    this.repaint();
                    super.mouseEntered(evt);
                }

                @Override
                public void mouseExited(MouseEvent evt) {
                    this.repaint();
                    super.mouseExited(evt);
                }

                private void repaint() {
                    WindowsScrollBarUI.this.scrollbar.repaint();
                }
            };
        }
        return super.createArrowButtonListener();
    }

    @Override
    protected void paintTrack(Graphics g, JComponent c, Rectangle trackBounds) {
        boolean v = this.scrollbar.getOrientation() == 1;
        XPStyle xp = XPStyle.getXP();
        if (xp != null) {
            JScrollBar sb = (JScrollBar)c;
            TMSchema.State state = TMSchema.State.NORMAL;
            if (!sb.isEnabled()) {
                state = TMSchema.State.DISABLED;
            }
            TMSchema.Part part = v ? TMSchema.Part.SBP_LOWERTRACKVERT : TMSchema.Part.SBP_LOWERTRACKHORZ;
            xp.getSkin(sb, part).paintSkin(g, trackBounds, state);
        } else if (this.thumbGrid == null) {
            super.paintTrack(g, c, trackBounds);
        } else {
            this.thumbGrid.paint(g, trackBounds.x, trackBounds.y, trackBounds.width, trackBounds.height);
            if (this.trackHighlight == 1) {
                this.paintDecreaseHighlight(g);
            } else if (this.trackHighlight == 2) {
                this.paintIncreaseHighlight(g);
            }
        }
    }

    @Override
    protected void paintThumb(Graphics g, JComponent c, Rectangle thumbBounds) {
        boolean v = this.scrollbar.getOrientation() == 1;
        XPStyle xp = XPStyle.getXP();
        if (xp != null) {
            JScrollBar sb = (JScrollBar)c;
            TMSchema.State state = TMSchema.State.NORMAL;
            if (!sb.isEnabled()) {
                state = TMSchema.State.DISABLED;
            } else if (this.isDragging) {
                state = TMSchema.State.PRESSED;
            } else if (this.isThumbRollover()) {
                state = TMSchema.State.HOT;
            } else if (XPStyle.isVista() && (this.incrButton != null && this.incrButton.getModel().isRollover() || this.decrButton != null && this.decrButton.getModel().isRollover())) {
                state = TMSchema.State.HOVER;
            }
            TMSchema.Part thumbPart = v ? TMSchema.Part.SBP_THUMBBTNVERT : TMSchema.Part.SBP_THUMBBTNHORZ;
            xp.getSkin(sb, thumbPart).paintSkin(g, thumbBounds, state);
            TMSchema.Part gripperPart = v ? TMSchema.Part.SBP_GRIPPERVERT : TMSchema.Part.SBP_GRIPPERHORZ;
            XPStyle.Skin skin = xp.getSkin(sb, gripperPart);
            Insets gripperInsets = xp.getMargin(c, thumbPart, null, TMSchema.Prop.CONTENTMARGINS);
            if (gripperInsets == null || v && thumbBounds.height - gripperInsets.top - gripperInsets.bottom >= skin.getHeight() || !v && thumbBounds.width - gripperInsets.left - gripperInsets.right >= skin.getWidth()) {
                skin.paintSkin(g, thumbBounds.x + (thumbBounds.width - skin.getWidth()) / 2, thumbBounds.y + (thumbBounds.height - skin.getHeight()) / 2, skin.getWidth(), skin.getHeight(), state);
            }
        } else {
            super.paintThumb(g, c, thumbBounds);
        }
    }

    @Override
    protected void paintDecreaseHighlight(Graphics g) {
        if (this.highlightGrid == null) {
            super.paintDecreaseHighlight(g);
        } else {
            int h;
            int w;
            int y;
            int x;
            Insets insets = this.scrollbar.getInsets();
            Rectangle thumbR = this.getThumbBounds();
            if (this.scrollbar.getOrientation() == 1) {
                x = insets.left;
                y = this.decrButton.getY() + this.decrButton.getHeight();
                w = this.scrollbar.getWidth() - (insets.left + insets.right);
                h = thumbR.y - y;
            } else {
                x = this.decrButton.getX() + this.decrButton.getHeight();
                y = insets.top;
                w = thumbR.x - x;
                h = this.scrollbar.getHeight() - (insets.top + insets.bottom);
            }
            this.highlightGrid.paint(g, x, y, w, h);
        }
    }

    @Override
    protected void paintIncreaseHighlight(Graphics g) {
        if (this.highlightGrid == null) {
            super.paintDecreaseHighlight(g);
        } else {
            int h;
            int w;
            int y;
            int x;
            Insets insets = this.scrollbar.getInsets();
            Rectangle thumbR = this.getThumbBounds();
            if (this.scrollbar.getOrientation() == 1) {
                x = insets.left;
                y = thumbR.y + thumbR.height;
                w = this.scrollbar.getWidth() - (insets.left + insets.right);
                h = this.incrButton.getY() - y;
            } else {
                x = thumbR.x + thumbR.width;
                y = insets.top;
                w = this.incrButton.getX() - x;
                h = this.scrollbar.getHeight() - (insets.top + insets.bottom);
            }
            this.highlightGrid.paint(g, x, y, w, h);
        }
    }

    @Override
    protected void setThumbRollover(boolean active) {
        boolean old = this.isThumbRollover();
        super.setThumbRollover(active);
        if (XPStyle.isVista() && active != old) {
            this.scrollbar.repaint();
        }
    }

    private static class Grid {
        private static final int BUFFER_SIZE = 64;
        private static HashMap<String, WeakReference<Grid>> map = new HashMap();
        private BufferedImage image;

        public static Grid getGrid(Color fg, Color bg) {
            Grid grid;
            String key = fg.getRGB() + " " + bg.getRGB();
            WeakReference<Grid> ref = map.get(key);
            Grid grid2 = grid = ref == null ? null : (Grid)ref.get();
            if (grid == null) {
                grid = new Grid(fg, bg);
                map.put(key, new WeakReference<Grid>(grid));
            }
            return grid;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Grid(Color fg, Color bg) {
            int[] cmap = new int[]{fg.getRGB(), bg.getRGB()};
            IndexColorModel icm = new IndexColorModel(8, 2, cmap, 0, false, -1, 0);
            this.image = new BufferedImage(64, 64, 13, icm);
            Graphics g = this.image.getGraphics();
            try {
                g.setClip(0, 0, 64, 64);
                this.paintGrid(g, fg, bg);
            }
            finally {
                g.dispose();
            }
        }

        public void paint(Graphics g, int x, int y, int w, int h) {
            Rectangle clipRect = g.getClipBounds();
            int minX = Math.max(x, clipRect.x);
            int minY = Math.max(y, clipRect.y);
            int maxX = Math.min(clipRect.x + clipRect.width, x + w);
            int maxY = Math.min(clipRect.y + clipRect.height, y + h);
            if (maxX <= minX || maxY <= minY) {
                return;
            }
            int xOffset = (minX - x) % 2;
            for (int xCounter = minX; xCounter < maxX; xCounter += 64) {
                int yOffset = (minY - y) % 2;
                int width = Math.min(64 - xOffset, maxX - xCounter);
                for (int yCounter = minY; yCounter < maxY; yCounter += 64) {
                    int height = Math.min(64 - yOffset, maxY - yCounter);
                    g.drawImage(this.image, xCounter, yCounter, xCounter + width, yCounter + height, xOffset, yOffset, xOffset + width, yOffset + height, null);
                    if (yOffset == 0) continue;
                    yCounter -= yOffset;
                    yOffset = 0;
                }
                if (xOffset == 0) continue;
                xCounter -= xOffset;
                xOffset = 0;
            }
        }

        private void paintGrid(Graphics g, Color fg, Color bg) {
            int yCounter;
            int xCounter;
            Rectangle clipRect = g.getClipBounds();
            g.setColor(bg);
            g.fillRect(clipRect.x, clipRect.y, clipRect.width, clipRect.height);
            g.setColor(fg);
            g.translate(clipRect.x, clipRect.y);
            int width = clipRect.width;
            int height = clipRect.height;
            int end = width - height;
            for (xCounter = clipRect.x % 2; xCounter < end; xCounter += 2) {
                g.drawLine(xCounter, 0, xCounter + height, height);
            }
            end = width;
            while (xCounter < end) {
                g.drawLine(xCounter, 0, width, width - xCounter);
                xCounter += 2;
            }
            int end2 = height - width;
            for (yCounter = clipRect.x % 2 == 0 ? 2 : 1; yCounter < end2; yCounter += 2) {
                g.drawLine(0, yCounter, width, yCounter + width);
            }
            end2 = height;
            while (yCounter < end2) {
                g.drawLine(0, yCounter, height - yCounter, height);
                yCounter += 2;
            }
            g.translate(-clipRect.x, -clipRect.y);
        }
    }

    private class WindowsArrowButton
    extends BasicArrowButton {
        public WindowsArrowButton(int direction, Color background, Color shadow, Color darkShadow, Color highlight) {
            super(direction, background, shadow, darkShadow, highlight);
        }

        public WindowsArrowButton(int direction) {
            super(direction);
        }

        @Override
        public void paint(Graphics g) {
            XPStyle xp = XPStyle.getXP();
            if (xp != null) {
                boolean jointRollover;
                ButtonModel model = this.getModel();
                XPStyle.Skin skin = xp.getSkin(this, TMSchema.Part.SBP_ARROWBTN);
                TMSchema.State state = null;
                boolean bl = jointRollover = XPStyle.isVista() && (WindowsScrollBarUI.this.isThumbRollover() || this == WindowsScrollBarUI.this.incrButton && WindowsScrollBarUI.this.decrButton.getModel().isRollover() || this == WindowsScrollBarUI.this.decrButton && WindowsScrollBarUI.this.incrButton.getModel().isRollover());
                if (model.isArmed() && model.isPressed()) {
                    switch (this.direction) {
                        case 1: {
                            state = TMSchema.State.UPPRESSED;
                            break;
                        }
                        case 5: {
                            state = TMSchema.State.DOWNPRESSED;
                            break;
                        }
                        case 7: {
                            state = TMSchema.State.LEFTPRESSED;
                            break;
                        }
                        case 3: {
                            state = TMSchema.State.RIGHTPRESSED;
                        }
                    }
                } else if (!model.isEnabled()) {
                    switch (this.direction) {
                        case 1: {
                            state = TMSchema.State.UPDISABLED;
                            break;
                        }
                        case 5: {
                            state = TMSchema.State.DOWNDISABLED;
                            break;
                        }
                        case 7: {
                            state = TMSchema.State.LEFTDISABLED;
                            break;
                        }
                        case 3: {
                            state = TMSchema.State.RIGHTDISABLED;
                        }
                    }
                } else if (model.isRollover() || model.isPressed()) {
                    switch (this.direction) {
                        case 1: {
                            state = TMSchema.State.UPHOT;
                            break;
                        }
                        case 5: {
                            state = TMSchema.State.DOWNHOT;
                            break;
                        }
                        case 7: {
                            state = TMSchema.State.LEFTHOT;
                            break;
                        }
                        case 3: {
                            state = TMSchema.State.RIGHTHOT;
                        }
                    }
                } else if (jointRollover) {
                    switch (this.direction) {
                        case 1: {
                            state = TMSchema.State.UPHOVER;
                            break;
                        }
                        case 5: {
                            state = TMSchema.State.DOWNHOVER;
                            break;
                        }
                        case 7: {
                            state = TMSchema.State.LEFTHOVER;
                            break;
                        }
                        case 3: {
                            state = TMSchema.State.RIGHTHOVER;
                        }
                    }
                } else {
                    switch (this.direction) {
                        case 1: {
                            state = TMSchema.State.UPNORMAL;
                            break;
                        }
                        case 5: {
                            state = TMSchema.State.DOWNNORMAL;
                            break;
                        }
                        case 7: {
                            state = TMSchema.State.LEFTNORMAL;
                            break;
                        }
                        case 3: {
                            state = TMSchema.State.RIGHTNORMAL;
                        }
                    }
                }
                skin.paintSkin(g, 0, 0, this.getWidth(), this.getHeight(), state);
            } else {
                super.paint(g);
            }
        }

        @Override
        public Dimension getPreferredSize() {
            int size = 16;
            if (WindowsScrollBarUI.this.scrollbar != null) {
                switch (WindowsScrollBarUI.this.scrollbar.getOrientation()) {
                    case 1: {
                        size = WindowsScrollBarUI.this.scrollbar.getWidth();
                        break;
                    }
                    case 0: {
                        size = WindowsScrollBarUI.this.scrollbar.getHeight();
                    }
                }
                size = Math.max(size, 5);
            }
            return new Dimension(size, size);
        }
    }
}

