/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.sis.controller.sms;

import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.SecuritySubject;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import com.zkteco.zkbiosecurity.sis.remote.sms.SisSmsConfigRemote;
import com.zkteco.zkbiosecurity.sis.service.sms.SisSmsConfigService;
import com.zkteco.zkbiosecurity.sis.service.sms.SisSmsTemplateService;
import com.zkteco.zkbiosecurity.sis.vo.sms.SisSmsConfigItem;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class SisSmsConfigController
extends BaseController
implements SisSmsConfigRemote {
    @Autowired
    private SisSmsConfigService sisSmsConfigService;
    @Autowired
    private SisSmsTemplateService sisSmsTemplateService;

    @RequiresPermissions(value={"sms:config"})
    public ModelAndView index() {
        return new ModelAndView("sis/smsConfig/sisSmsConfig");
    }

    @RequiresPermissions(value={"sms:config:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.sisSmsConfigService.getItemById(id));
        }
        return new ModelAndView("sis/smsConfig/editSisSmsConfig");
    }

    @RequiresPermissions(value={"sms:config:edit"})
    public ZKResultMsg save(SisSmsConfigItem item) {
        ZKResultMsg res = new ZKResultMsg();
        SecuritySubject user = (SecuritySubject)this.request.getSession().getAttribute("user");
        item.setCompanyId(user.getCompanyId());
        this.sisSmsConfigService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"sms:config:refresh"})
    public DxGrid list(SisSmsConfigItem codition) {
        SecuritySubject user = (SecuritySubject)this.request.getSession().getAttribute("user");
        codition.setCompanyId(user.getCompanyId());
        Pager pager = this.sisSmsConfigService.getItemsByPage((BaseItem)codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @RequiresPermissions(value={"sms:config:del"})
    public ZKResultMsg delete(String ids) {
        ZKResultMsg retMsg = new ZKResultMsg();
        if (this.sisSmsTemplateService.isExistFkData(ids)) {
            return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.failMsg((String)I18nUtil.i18nCode((String)"common_sendSms_failed", (Object[])new Object[0]), (Object[])new Object[0]));
        }
        this.sisSmsConfigService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)retMsg);
    }
}

