/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.sis.controller;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

@ServerEndpoint(value="/sisWebSocketMsg")
public class SisWebSocket {
    private static final Logger loger = Logger.getLogger(SisWebSocket.class);
    public static final Set<SisWebSocket> onlineClients = new CopyOnWriteArraySet<SisWebSocket>();
    private Session session;
    private Set<Integer> devIdSet = new HashSet<Integer>();

    @OnOpen
    public void onOpen(Session session) {
        this.session = session;
        onlineClients.add(this);
    }

    @OnMessage
    public void receiveMessage(String message) {
        if (StringUtils.isNotBlank((CharSequence)message)) {
            for (String devId : message.split(",")) {
                this.devIdSet.add(Integer.parseInt(devId));
            }
        }
    }

    public boolean needSendSocket(int devId) {
        return this.devIdSet.contains(devId);
    }

    public static void sendAllMsg(String sendInfo) {
        for (SisWebSocket client : onlineClients) {
            client.sendMsg(sendInfo);
        }
    }

    public void sendMsg(String sendInfo) {
        try {
            this.session.getBasicRemote().sendText(sendInfo);
        }
        catch (Exception e) {
            loger.debug((Object)"error: send message error!", (Throwable)e);
        }
    }

    @OnError
    public void onError(Session session, Throwable error) {
        loger.error((Object)("error: " + error.getMessage()));
    }

    @OnClose
    public void onClose(Session session) {
        try {
            onlineClients.remove(this);
        }
        catch (Exception e) {
            loger.info((Object)"********destory***************");
        }
    }

    public Session getSession() {
        return this.session;
    }

    public void setSession(Session session) {
        this.session = session;
    }
}

