/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.sis.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import com.zkteco.zkbiosecurity.sis.remote.SisRTMonitorRemote;
import com.zkteco.zkbiosecurity.sis.service.SisDeviceService;
import com.zkteco.zkbiosecurity.sis.service.SisRTMonitorService;
import com.zkteco.zkbiosecurity.sis.vo.SisDeviceItem;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class SisRTMonitorController
extends ExportController
implements SisRTMonitorRemote {
    private static Logger logger = Logger.getLogger(SisRTMonitorController.class);
    @Autowired
    private SisRTMonitorService sisRTMonitorService;
    @Autowired
    private SisDeviceService sisDeviceService;

    @RequiresPermissions(value={"sis:rtMonitor"})
    public ModelAndView index() {
        return new ModelAndView("sis/monitor/sisRTMonitor");
    }

    public ModelAndView sisDeviceDetailInfo() {
        return new ModelAndView("sis/monitor/sisDeviceDetailInfo");
    }

    public DxGrid list(SisDeviceItem codition) {
        Pager pager = this.sisDeviceService.loadPagerByAuthFilter(this.request.getSession().getId(), codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    public ZKResultMsg getAllDevice() {
        ZKResultMsg resultMsg = new ZKResultMsg();
        try {
            List devList = this.list(new SisDeviceItem()).getRows();
            JSONArray dataArray = new JSONArray();
            String loadText = "${common_paging_loading}";
            for (SisDeviceItem dev : devList) {
                if (dev.getState().booleanValue()) continue;
                JSONObject objJson = new JSONObject();
                objJson.put("id", (Object)dev.getId());
                objJson.put("areaId", (Object)dev.getAuthAreaId());
                objJson.put("name", (Object)dev.getName());
                objJson.put("devSn", (Object)dev.getSn());
                objJson.put("workMode", (Object)loadText);
                objJson.put("motorState", (Object)loadText);
                objJson.put("image", (Object)"closed");
                objJson.put("connect", (Object)-1);
                objJson.put("display", (Object)"none");
                dataArray.add((Object)objJson);
            }
            resultMsg.setData((Object)dataArray);
        }
        catch (Exception e) {
            logger.error((Object)"exception", (Throwable)e);
        }
        return resultMsg;
    }

    public ZKResultMsg getDeviceStatusJson(String model, String devSn, String areaId) {
        ZKResultMsg resultMsg = new ZKResultMsg();
        SisDeviceItem sisDeviceItem = new SisDeviceItem();
        if (StringUtils.isNotBlank((CharSequence)model)) {
            sisDeviceItem.setModel(model);
        } else if (StringUtils.isNotBlank((CharSequence)devSn)) {
            sisDeviceItem.setSn(devSn);
        } else if (StringUtils.isNotBlank((CharSequence)areaId)) {
            sisDeviceItem.setAuthAreaId(areaId);
        }
        List devList = this.sisDeviceService.getByCondition(sisDeviceItem);
        JSONObject jsonObject = this.sisDeviceService.getDeviceStatusCount(devList);
        resultMsg.setData((Object)jsonObject);
        return resultMsg;
    }

    public ZKResultMsg startControl(String ids) {
        ZKResultMsg resultMsg = new ZKResultMsg();
        JSONObject json = new JSONObject();
        String msgStr = this.sisRTMonitorService.operateDevice("startControl", null, ids);
        SisDeviceItem dev = this.sisDeviceService.findById(ids);
        if (msgStr.equals(I18nUtil.i18nCode((String)"common_op_succeed", (Object[])new Object[0]))) {
            this.sisRTMonitorService.startControl(dev);
        }
        resultMsg.setMsg(msgStr);
        json.put("ctrlState", (Object)"1");
        resultMsg.setData((Object)json);
        return resultMsg;
    }

    public ZKResultMsg stopControl(String ids) {
        ZKResultMsg resultMsg = new ZKResultMsg();
        JSONObject json = new JSONObject();
        String msgStr = this.sisRTMonitorService.operateDevice("stopControl", null, ids);
        SisDeviceItem dev = this.sisDeviceService.findById(ids);
        if (msgStr.equals(I18nUtil.i18nCode((String)"common_op_succeed", (Object[])new Object[0]))) {
            this.sisRTMonitorService.stopControl(dev);
        }
        resultMsg.setMsg(msgStr);
        json.put("ctrlState", (Object)"2");
        resultMsg.setData((Object)json);
        return resultMsg;
    }

    public ZKResultMsg reverseMotor(String ids) {
        ZKResultMsg resultMsg = new ZKResultMsg();
        JSONObject json = new JSONObject();
        String timeout = this.request.getParameter("openTimeout");
        String msgStr = this.sisRTMonitorService.operateDevice("reverseMotor", timeout, ids);
        SisDeviceItem dev = this.sisDeviceService.findById(ids);
        if (msgStr.equals(I18nUtil.i18nCode((String)"common_op_succeed", (Object[])new Object[0]))) {
            this.sisRTMonitorService.reverseMotor(dev);
        }
        resultMsg.setMsg(msgStr);
        json.put("ctrlState", (Object)"4");
        resultMsg.setData((Object)json);
        return resultMsg;
    }

    public ZKResultMsg stopMotor(String ids) {
        ZKResultMsg resultMsg = new ZKResultMsg();
        JSONObject json = new JSONObject();
        String msgStr = this.sisRTMonitorService.operateDevice("stopMotor", null, ids);
        SisDeviceItem dev = this.sisDeviceService.findById(ids);
        if (msgStr.equals(I18nUtil.i18nCode((String)"common_op_succeed", (Object[])new Object[0]))) {
            this.sisRTMonitorService.stopMotor(dev);
        }
        resultMsg.setMsg(msgStr);
        json.put("ctrlState", (Object)"3");
        resultMsg.setData((Object)json);
        return resultMsg;
    }

    public ZKResultMsg forwardMotor(String ids) {
        ZKResultMsg resultMsg = new ZKResultMsg();
        String timeout = this.request.getParameter("openTimeout");
        String msgStr = this.sisRTMonitorService.operateDevice("forwardMotor", timeout, ids);
        SisDeviceItem dev = this.sisDeviceService.findById(ids);
        if (msgStr.equals(I18nUtil.i18nCode((String)"common_op_succeed", (Object[])new Object[0]))) {
            this.sisRTMonitorService.forwardMotor(dev);
        }
        resultMsg.setMsg(msgStr);
        return resultMsg;
    }

    public ZKResultMsg startMaintain(String ids) {
        ZKResultMsg resultMsg = new ZKResultMsg();
        String msgStr = this.sisRTMonitorService.operateDevice("startMaintain", null, ids);
        SisDeviceItem dev = this.sisDeviceService.findById(ids);
        if (msgStr.equals(I18nUtil.i18nCode((String)"common_op_succeed", (Object[])new Object[0]))) {
            this.sisRTMonitorService.startMaintain(dev);
        }
        resultMsg.setMsg(msgStr);
        return resultMsg;
    }

    public ZKResultMsg stopMaintain(String ids) {
        ZKResultMsg resultMsg = new ZKResultMsg();
        this.sisRTMonitorService.operateDevice("stopControl", null, ids);
        String msgStr = this.sisRTMonitorService.operateDevice("stopMaintain", null, ids);
        SisDeviceItem dev = this.sisDeviceService.findById(ids);
        if (msgStr.equals(I18nUtil.i18nCode((String)"common_op_succeed", (Object[])new Object[0]))) {
            this.sisRTMonitorService.stopMaintain(dev);
        }
        resultMsg.setMsg(msgStr);
        return resultMsg;
    }

    public ZKResultMsg startRay(String ids) {
        ZKResultMsg resultMsg = new ZKResultMsg();
        String msgStr = this.sisRTMonitorService.operateDevice("startRay", null, ids);
        SisDeviceItem dev = this.sisDeviceService.findById(ids);
        if (msgStr.equals(I18nUtil.i18nCode((String)"common_op_succeed", (Object[])new Object[0]))) {
            this.sisRTMonitorService.startRay(dev);
        }
        resultMsg.setMsg(msgStr);
        return resultMsg;
    }

    public ZKResultMsg stopRay(String ids) {
        ZKResultMsg resultMsg = new ZKResultMsg();
        String msgStr = this.sisRTMonitorService.operateDevice("stopRay", null, ids);
        SisDeviceItem dev = this.sisDeviceService.findById(ids);
        if (msgStr.equals(I18nUtil.i18nCode((String)"common_op_succeed", (Object[])new Object[0]))) {
            this.sisRTMonitorService.stopRay(dev);
        }
        resultMsg.setMsg(msgStr);
        return resultMsg;
    }

    public ModelAndView openMaintain(String devId) {
        this.request.setAttribute("devId", (Object)devId);
        return new ModelAndView("sis/monitor/sisMaintain");
    }

    public ModelAndView toMaintain(String devId) {
        this.request.setAttribute("devId", (Object)devId);
        return new ModelAndView("sis/monitor/sisMaintain");
    }
}

