/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.sis.controller;

import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.ProcessBean;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.cache.ProgressCache;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import com.zkteco.zkbiosecurity.sis.remote.SisDeviceAddPersonRemote;
import com.zkteco.zkbiosecurity.sis.service.SisDeviceAddPersonService;
import com.zkteco.zkbiosecurity.sis.service.SisPersonAddDeviceService;
import com.zkteco.zkbiosecurity.sis.vo.SisDeviceAddPersonItem;
import com.zkteco.zkbiosecurity.sis.vo.SisDeviceSelectPersonItem;
import com.zkteco.zkbiosecurity.sis.vo.SisPersonInDeviceItem;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class SisDeviceAddPersonController
extends BaseController
implements SisDeviceAddPersonRemote {
    Logger logger = Logger.getLogger(SisDeviceAddPersonController.class);
    @Autowired
    private ProgressCache progressCache;
    @Autowired
    private SisDeviceAddPersonService sisDeviceAddPersonService;
    @Autowired
    private SisPersonAddDeviceService sisPersonAddDeviceService;

    @RequiresPermissions(value={"sis:deviceAddPerson"})
    public ModelAndView index() {
        return new ModelAndView("sis/deviceAddPerson/sisDeviceAddPerson");
    }

    @RequiresPermissions(value={"sis:deviceAddPerson:edit"})
    public ModelAndView edit(String id) {
        return null;
    }

    @RequiresPermissions(value={"sis:deviceAddPerson:edit"})
    public ZKResultMsg addPerson(String deviceId, String personIds, String deptIds) {
        String clientId = this.request.getParameter("clientId");
        this.progressCache.beginProcess(I18nUtil.i18nCode((String)"common_op_startProcessing", (Object[])new Object[0]) + "<br/>");
        if (StringUtils.isNotBlank((CharSequence)deptIds)) {
            personIds = this.sisPersonAddDeviceService.getPersonIdsByDeptIds(deptIds);
        }
        if (StringUtils.isNotBlank((CharSequence)deviceId) && StringUtils.isNotBlank((CharSequence)personIds)) {
            try {
                List personArrayIds = this.sisPersonAddDeviceService.splitIds(personIds, 200);
                int[] currentCount = new int[]{0};
                int[] totalCount = new int[]{personArrayIds.size()};
                personArrayIds.parallelStream().forEach(personArrayId -> {
                    this.sisPersonAddDeviceService.addDeviceByPersonIds(personArrayId, deviceId);
                    currentCount[0] = currentCount[0] + 1;
                    this.progressCache.setProcess(new ProcessBean(0, (int)((double)currentCount[0] * 100.0 / (double)totalCount[0])), clientId);
                });
            }
            catch (Exception e) {
                this.logger.error((Object)"addPerson with device error", (Throwable)e);
            }
        }
        this.progressCache.finishProcess(I18nUtil.i18nCode((String)"common_progress_finish", (Object[])new Object[0]) + "<br/>", "", I18nUtil.i18nCode((String)"common_op_currProgress", (Object[])new Object[0]));
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"sis:deviceAddPerson:refresh"})
    public DxGrid list(SisDeviceAddPersonItem condition) {
        Pager pager = this.sisDeviceAddPersonService.loadPagerBySisDeviceFilter(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"sis:deviceAddPerson:del"})
    public ZKResultMsg del(String ids) {
        String deviceSn = this.request.getParameter("deviceSn");
        this.sisDeviceAddPersonService.removePerson(deviceSn, ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"sis:deviceAddPerson:refresh"})
    public DxGrid getDevicePersonList(SisPersonInDeviceItem condition) {
        Pager pager = this.sisDeviceAddPersonService.getPersonItemList(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public DxGrid selectPersonlist(SisDeviceSelectPersonItem codition) {
        Pager pager = new Pager();
        if (StringUtils.equals((CharSequence)codition.getType(), (CharSequence)"noSelected")) {
            pager = this.sisDeviceAddPersonService.getNoExistPerson(this.request.getSession().getId(), codition, this.getPageNo(), this.getPageSize());
        } else if (StringUtils.equals((CharSequence)codition.getType(), (CharSequence)"selected")) {
            pager.setData(new ArrayList());
        }
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    public ZKResultMsg getPersonCountByDept(String deptIds) {
        long personCount = this.sisDeviceAddPersonService.getPersonCountByDept(deptIds);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg((Object)personCount));
    }
}

