/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.sis.controller;

import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import com.zkteco.zkbiosecurity.sis.remote.SisCarUnderInfoRemote;
import com.zkteco.zkbiosecurity.sis.service.SisCarUnderInfoService;
import com.zkteco.zkbiosecurity.sis.vo.SisCarUnderInfoItem;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class SisCarUnderInfoController
extends ExportController
implements SisCarUnderInfoRemote {
    @Autowired
    SisCarUnderInfoService sisCarUnderInfoService;

    @RequiresPermissions(value={"sis:carUnderInfo"})
    public ModelAndView index() {
        return new ModelAndView("sis/carUnder/sisCarUnderInfo");
    }

    @RequiresPermissions(value={"sis:carUnderInfo:refresh"})
    public DxGrid list(SisCarUnderInfoItem condition) {
        Pager pager = this.sisCarUnderInfoService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"sis:carUnderInfo:edit"})
    public ZKResultMsg save(SisCarUnderInfoItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.sisCarUnderInfoService.save(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    public ZKResultMsg getCarUnderInfoPhoto(String id, String colIndex) {
        String photo = this.sisCarUnderInfoService.getCarUnderInfoPhoto(id, colIndex);
        return new ZKResultMsg((Object)photo);
    }
}

