/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ele.controller;

import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.ele.remote.EleGlobalLinkageInRemote;
import com.zkteco.zkbiosecurity.ele.service.EleGlobalLinkageInService;
import com.zkteco.zkbiosecurity.ele.vo.EleGlobalLinkageInItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class EleGlobalLinkageInController
extends BaseController
implements EleGlobalLinkageInRemote {
    @Autowired
    private EleGlobalLinkageInService eleGlobalLinkageInService;

    @RequiresPermissions(value={"ele:globalLinkageIn"})
    public ModelAndView index() {
        return new ModelAndView("ele/globalLinkageIn/eleGlobalLinkageIn");
    }

    @RequiresPermissions(value={"ele:globalLinkageIn:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.eleGlobalLinkageInService.getItemById(id));
        }
        return new ModelAndView("ele/globalLinkageIn/editEleGlobalLinkageIn");
    }

    @RequiresPermissions(value={"ele:globalLinkageIn:edit"})
    public ZKResultMsg save(EleGlobalLinkageInItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.eleGlobalLinkageInService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"ele:globalLinkageIn:refresh"})
    public DxGrid list(EleGlobalLinkageInItem condition) {
        Pager pager = this.eleGlobalLinkageInService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"ele:globalLinkageIn:del"})
    public ZKResultMsg del(String ids) {
        this.eleGlobalLinkageInService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }
}

