/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ele.controller;

import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.ele.remote.EleDeviceOptionRemote;
import com.zkteco.zkbiosecurity.ele.service.EleDeviceOptionService;
import com.zkteco.zkbiosecurity.ele.vo.EleDeviceOptionItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class EleDeviceOptionController
extends BaseController
implements EleDeviceOptionRemote {
    @Autowired
    private EleDeviceOptionService eleDeviceOptionService;

    @RequiresPermissions(value={"ele:deviceOption"})
    public ModelAndView index() {
        return new ModelAndView("ele/deviceOption/eleDeviceOption");
    }

    @RequiresPermissions(value={"ele:deviceOption:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.eleDeviceOptionService.getItemById(id));
        }
        return new ModelAndView("ele/deviceOption/editEleDeviceOption");
    }

    @RequiresPermissions(value={"ele:deviceOption:edit"})
    public ZKResultMsg save(EleDeviceOptionItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.eleDeviceOptionService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"ele:deviceOption:refresh"})
    public DxGrid list(EleDeviceOptionItem condition) {
        Pager pager = this.eleDeviceOptionService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"ele:deviceOption:del"})
    public ZKResultMsg del(String ids) {
        this.eleDeviceOptionService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }
}

