/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ele.api.controller;

import com.zkteco.zkbiosecurity.base.vo.ApiResultMessage;
import com.zkteco.zkbiosecurity.core.utils.DateUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.ele.service.EleTransactionService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/eleTransaction"})
@Api(tags={"EleTransaction"}, description="ele transaction")
public class EleApiTransactionController {
    private static final Logger log = LoggerFactory.getLogger(EleApiTransactionController.class);
    @Autowired
    private EleTransactionService eleTransactionService;

    @ResponseBody
    @RequestMapping(value={"/list"}, method={RequestMethod.GET}, produces={"application/json"})
    @ApiOperation(value="Get Ele Transactions List", notes="Return Ele Transactions List", response=ApiResultMessage.class)
    public ApiResultMessage listEleTransaction(@RequestParam(name="personPin", required=false) String personPin, @RequestParam(name="startDate", required=false) String startDate, @RequestParam(name="endDate", required=false) String endDate, @RequestParam Integer pageNo, @RequestParam Integer pageSize) {
        Date startTime = null;
        Date endTime = null;
        ApiResultMessage rs = ApiResultMessage.successMessage();
        try {
            if (pageNo <= 0 || pageSize <= 0) {
                return ApiResultMessage.message((int)-90, (String)I18nUtil.i18nCode((String)"common_api_pageValid", (Object[])new Object[0]));
            }
            if (pageSize > 1000) {
                return ApiResultMessage.message((int)-91, (String)I18nUtil.i18nCode((String)"common_api_pageSizeOver", (Object[])new Object[0]));
            }
            if (StringUtils.isNotBlank((CharSequence)startDate) && StringUtils.isNotBlank((CharSequence)endDate)) {
                startTime = DateUtil.stringToDate((String)startDate);
                endTime = DateUtil.stringToDate((String)endDate);
                if (startTime == null || endTime == null) {
                    return ApiResultMessage.message((int)-100, (String)I18nUtil.i18nCode((String)"common_dsTime_timeValid2", (Object[])new Object[0]));
                }
                if (startTime.getTime() > endTime.getTime()) {
                    return ApiResultMessage.message((int)-101, (String)I18nUtil.i18nCode((String)"common_dsTime_timeValid4", (Object[])new Object[0]));
                }
            }
            List eleApiTransactionItemList = this.eleTransactionService.getApiTransactionList(personPin, startTime, endTime, pageNo, pageSize);
            rs.setData((Object)eleApiTransactionItemList);
        }
        catch (Exception e) {
            log.error("api eleTransaction/listEleTransaction error", (Throwable)e);
            rs = ApiResultMessage.message((int)-1, (String)I18nUtil.i18nCode((String)"common_api_programError", (Object[])new Object[0]));
        }
        return rs;
    }
}

