/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.pos.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.pos.remote.PosRechargeCardRemote;
import com.zkteco.zkbiosecurity.pos.service.PosCardKindService;
import com.zkteco.zkbiosecurity.pos.service.PosCardManageService;
import com.zkteco.zkbiosecurity.pos.service.PosSystemParamService;
import com.zkteco.zkbiosecurity.pos.vo.PosCardKindItem;
import com.zkteco.zkbiosecurity.pos.vo.PosCardManageItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PosRechargeCardController
extends BaseController
implements PosRechargeCardRemote {
    @Autowired
    private PosCardManageService posCardManageService;
    @Autowired
    private PosSystemParamService posSystemParamService;
    @Autowired
    private PosCardKindService posCardKindService;

    @RequiresPermissions(value={"pos:rechargeCard"})
    public ModelAndView index() {
        return new ModelAndView("pos/rechargeCard/posRechargeCard");
    }

    @RequiresPermissions(value={"pos:rechargeCard:edit"})
    public ModelAndView edit(String id) {
        HashMap<String, String> param = new HashMap<String, String>();
        Integer cardModel = Integer.valueOf(this.posSystemParamService.getValByName("pos.cardModel"));
        String cardKindId = ((PosCardKindItem)this.posCardKindService.getByCondition(new PosCardKindItem()).get(0)).getId();
        param.put("cardModel", cardModel.toString());
        param.put("posCardKindId", cardKindId);
        return new ModelAndView("pos/rechargeCard/editPosRechargeCard", param);
    }

    @RequiresPermissions(value={"pos:rechargeCard:del"})
    @LogRequest(module="pos_module", object="pos_leftMenu_cardManage", opType="common_op_del", requestParams={"ids"}, opContent="pos_common_id")
    public ZKResultMsg delete(String ids) {
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"pos:rechargeCard:edit"})
    @LogRequest(module="pos_module", object="pos_leftMenu_cardManage", opType="pos_op_repairCard", requestParams={"personPin"}, opContent="pos_card_personNum")
    public ZKResultMsg save(PosCardManageItem item) {
        ZKResultMsg res = new ZKResultMsg();
        String subBalance = this.request.getParameter("subBalance");
        Double subBal = subBalance != null ? Double.parseDouble(subBalance) : 0.0;
        this.posCardManageService.saveItem(item, "1", subBal);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }
}

