/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.pos.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.pos.remote.PosDiningHallRemote;
import com.zkteco.zkbiosecurity.pos.service.PosDiningHallService;
import com.zkteco.zkbiosecurity.pos.vo.PosDiningHallItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PosDiningHallController
extends BaseController
implements PosDiningHallRemote {
    @Autowired
    private PosDiningHallService posDiningHallService;

    @RequiresPermissions(value={"pos:diningHall"})
    public ModelAndView index() {
        return new ModelAndView("pos/diningHall/posDiningHall");
    }

    @RequiresPermissions(value={"pos:diningHall:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.posDiningHallService.getItemById(id));
        }
        return new ModelAndView("pos/diningHall/editPosDiningHall");
    }

    @RequiresPermissions(value={"pos:diningHall:edit"})
    @LogRequest(module="pos_module", object="pos_leftMenu_diningHall", opType="common_op_new", requestParams={"name"}, opContent="common_name")
    public ZKResultMsg save(PosDiningHallItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.posDiningHallService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"pos:diningHall:refresh"})
    public DxGrid list(PosDiningHallItem codition) {
        Pager pager = this.posDiningHallService.getItemsByPage((BaseItem)codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @RequiresPermissions(value={"pos:diningHall:del"})
    @LogRequest(module="pos_module", object="pos_leftMenu_diningHall", opType="common_op_del", requestParams={"names"}, opContent="common_name")
    public ZKResultMsg delete(String ids) {
        this.posDiningHallService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public String validCode(String code) {
        PosDiningHallItem item = this.posDiningHallService.getItemByCode(code);
        boolean rs = item == null;
        return rs + "";
    }

    public String validName(String name) {
        PosDiningHallItem item = this.posDiningHallService.getItemByName(name);
        boolean rs = item == null;
        return rs + "";
    }

    public ZKResultMsg getDiningHallNameList() {
        return new ZKResultMsg((Object)this.posDiningHallService.getDiningHallNameList());
    }
}

