/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.client.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;

public class ParkClientFTPUtil {
    private static FTPClient ftp;
    private static String LOCAL_CHARSET;
    private static String SERVER_CHARSET;

    public static boolean connect(String remote, String addr, int port, String username, String password) throws Exception {
        boolean result = false;
        ftp = new FTPClient();
        ftp.connect(addr, port);
        ftp.login(username, password);
        ftp.setFileType(2);
        if (FTPReply.isPositiveCompletion((int)ftp.sendCommand("OPTS UTF8", "ON"))) {
            LOCAL_CHARSET = "UTF-8";
        }
        ftp.setControlEncoding(LOCAL_CHARSET);
        int reply = ftp.getReplyCode();
        if (!FTPReply.isPositiveCompletion((int)reply)) {
            ftp.disconnect();
            return result;
        }
        String directory = remote + "/";
        if (!directory.equalsIgnoreCase("/") && !ParkClientFTPUtil.changeWorkingDirectory(new String(directory), ftp)) {
            int start = 0;
            int end = 0;
            start = directory.startsWith("/") ? 1 : 0;
            end = directory.indexOf("/", start);
            String path = "";
            String paths = "";
            do {
                String subDirectory = new String(remote.substring(start, end).getBytes(LOCAL_CHARSET), SERVER_CHARSET);
                if (!ParkClientFTPUtil.existFile(path = path + "/" + subDirectory, ftp)) {
                    if (ParkClientFTPUtil.makeDirectory(subDirectory, ftp)) {
                        ParkClientFTPUtil.changeWorkingDirectory(subDirectory, ftp);
                    } else {
                        ParkClientFTPUtil.changeWorkingDirectory(subDirectory, ftp);
                    }
                } else {
                    ParkClientFTPUtil.changeWorkingDirectory(subDirectory, ftp);
                }
                paths = paths + "/" + subDirectory;
            } while ((end = directory.indexOf("/", start = end + 1)) > start);
        }
        result = true;
        return result;
    }

    public static boolean makeDirectory(String dir, FTPClient ftp) {
        boolean flag = true;
        try {
            flag = ftp.makeDirectory(dir);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return flag;
    }

    public static boolean existFile(String path, FTPClient ftp) throws IOException {
        boolean flag = false;
        FTPFile[] ftpFileArr = ftp.listFiles(path);
        if (ftpFileArr.length > 0) {
            flag = true;
        }
        return flag;
    }

    public static boolean changeWorkingDirectory(String directory, FTPClient ftp) {
        boolean flag = true;
        try {
            flag = ftp.changeWorkingDirectory(directory);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return flag;
    }

    public static void upload(File file) throws Exception {
        if (file.isDirectory()) {
            ftp.makeDirectory(file.getName());
            ftp.changeWorkingDirectory(file.getName());
            String[] files = file.list();
            for (int i = 0; i < files.length; ++i) {
                File file1 = new File(file.getPath() + "\\" + files[i]);
                if (file1.isDirectory()) {
                    ParkClientFTPUtil.upload(file1);
                    ftp.changeToParentDirectory();
                    continue;
                }
                File file2 = new File(file.getPath() + "\\" + files[i]);
                FileInputStream input = new FileInputStream(file2);
                ftp.storeFile(new String(file2.getName().getBytes(LOCAL_CHARSET), SERVER_CHARSET), (InputStream)input);
                input.close();
            }
        } else {
            File file2 = new File(file.getPath());
            FileInputStream input = new FileInputStream(file2);
            ftp.storeFile(new String(file2.getName().getBytes(LOCAL_CHARSET), SERVER_CHARSET), (InputStream)input);
            input.close();
        }
    }

    static {
        LOCAL_CHARSET = "GBK";
        SERVER_CHARSET = "ISO-8859-1";
    }
}

