/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.client.service.impl;

import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.client.utils.ParkClientCommonUtil;
import com.zkteco.zkbiosecurity.message.bean.ZKMessage;
import com.zkteco.zkbiosecurity.park.bean.ParkWeChatCharge;
import com.zkteco.zkbiosecurity.park.constants.ParkConstants;
import com.zkteco.zkbiosecurity.park.service.ParkParamsService;
import com.zkteco.zkbiosecurity.park.service.ParkParkingMeterService;
import com.zkteco.zkbiosecurity.park.service.ParkRecordinService;
import com.zkteco.zkbiosecurity.park.service.ParkRecordoutService;
import com.zkteco.zkbiosecurity.park.service.ParkTempBillingService;
import com.zkteco.zkbiosecurity.park.vo.ParkParkingMeterItem;
import com.zkteco.zkbiosecurity.park.vo.ParkRecordinItem;
import com.zkteco.zkbiosecurity.park.vo.ParkTempBillingItem;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ParkWechatCharge {
    private static final Logger logger = LoggerFactory.getLogger(ParkWechatCharge.class);
    @Autowired
    private ParkTempBillingService tempBillingService;
    @Autowired
    private ParkParkingMeterService parkingMeterService;
    @Autowired
    private ParkRecordinService parkRecordinService;
    @Autowired
    private ParkRecordoutService parkRecordoutService;
    @Autowired
    private ParkParamsService parkParamsService;

    public ZKResultMsg wechatCharge(ZKMessage msg) {
        ParkTempBillingItem tempBillingItem;
        String recordinId = msg.getContent().get("recordinId").toString();
        ParkWeChatCharge weChatCharge = new ParkWeChatCharge();
        if (this.parkParamsService.printParkLogger()) {
            logger.info("PARK_ONLINE_PAY == Receive Cloud Parking Charge Request, recordinId = " + recordinId);
        }
        if (ParkClientCommonUtil.isNotNull(tempBillingItem = this.tempBillingService.getByRecordinId(recordinId))) {
            if (this.parkParamsService.printParkLogger()) {
                logger.info("PARK_ONLINE_PAY == Exit Parking Payment");
            }
            ParkClientCommonUtil.getCarTypeByEvent(tempBillingItem.getEventType(), weChatCharge);
            if (tempBillingItem.getPaymentMethod().equals(ParkConstants.PAY_METHOD_CENTERPAY)) {
                List recordinAry = this.parkRecordinService.getByCheckinIdAndStatus(recordinId, ParkConstants.CAR_STATUS_IN);
                ParkRecordinItem recordin = (ParkRecordinItem)recordinAry.get(0);
                recordin.setEventType(ParkConstants.EVENT_ONLINE_CHARGE);
                recordin.setParkingMeterId(tempBillingItem.getParkingMeterId());
                this.parkRecordinService.saveItem(recordin);
            }
            tempBillingItem.setPaymentMethod(ParkConstants.PAY_ONLINE_CHARGE);
            this.tempBillingService.saveItem(tempBillingItem);
            weChatCharge.setFinalAmount(String.valueOf(tempBillingItem.getReceiveAmount()));
            weChatCharge.setChargeType("tempCharge");
            weChatCharge.setRecordinId(recordinId);
            ParkRecordinItem parkRecordinItem = this.parkRecordinService.getItemById(tempBillingItem.getRecordinId());
            weChatCharge.setParkingTime(ParkClientCommonUtil.getParkingTime(parkRecordinItem.getCheckInTime(), new Date()));
        } else {
            if (this.parkParamsService.printParkLogger()) {
                logger.info("PARK_ONLINE_PAY == In Parking Payment");
            }
            ParkRecordinItem recordinItem = this.parkRecordinService.getItemById(recordinId);
            ArrayList<Short> statusList = new ArrayList<Short>(){
                {
                    this.add(ParkConstants.CAR_STATUS_IN);
                    this.add(ParkConstants.CAR_STATUS_OUT_IF);
                }
            };
            List recordinAry = this.parkRecordinService.getByCheckinIdAndStatusIn(recordinId, (List)statusList);
            if (ParkClientCommonUtil.isNotNull(recordinItem) && (ParkConstants.CAR_STATUS_IN.equals(recordinItem.getStatus()) || ParkConstants.CAR_STATUS_OUT_IF.equals(recordinItem.getStatus())) || ParkClientCommonUtil.isNotNull(recordinAry)) {
                if (ParkClientCommonUtil.isNotNull(recordinAry)) {
                    ParkRecordinItem newRecordinItem = (ParkRecordinItem)recordinAry.get(0);
                    if (ParkConstants.EVENT_ONLINE_CHARGE.equals(newRecordinItem.getEventType())) {
                        ParkParkingMeterItem parkingMeter = this.parkingMeterService.getItemById(newRecordinItem.getParkingMeterId());
                        String recordinIdTemp = parkingMeter.getRecordinId();
                        this.parkRecordinService.deleteByIds(newRecordinItem.getId());
                        this.parkingMeterService.deleteByIds(parkingMeter.getId());
                        this.parkRecordoutService.deleteByIds(parkingMeter.getRecordoutId());
                        newRecordinItem = this.parkRecordinService.getItemById(recordinIdTemp);
                        newRecordinItem.setStatus(ParkConstants.CAR_STATUS_IN);
                        recordinItem = this.parkRecordinService.saveItem(newRecordinItem);
                    } else {
                        recordinItem = (ParkRecordinItem)recordinAry.get(0);
                    }
                }
                if (this.parkParamsService.printParkLogger()) {
                    logger.info("PARK_ONLINE_PAY == Start This Charge");
                }
                weChatCharge.setParkingTime(ParkClientCommonUtil.getParkingTime(recordinItem.getCheckInTime(), new Date()));
                this.parkRecordoutService.weChatCheckoutCharge(recordinItem, weChatCharge);
            } else {
                weChatCharge.setFinalAmount(this.parkParamsService.getChargeOpen());
                weChatCharge.setChargeType("noRecordin");
                weChatCharge.setRecordinId(recordinId);
            }
        }
        return new ZKResultMsg((Object)weChatCharge);
    }
}

