/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.client.service.impl;

import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.client.utils.ParkClientCommonUtil;
import com.zkteco.zkbiosecurity.message.bean.ZKMessage;
import com.zkteco.zkbiosecurity.park.service.ParkCarNumberService;
import com.zkteco.zkbiosecurity.park.service.ParkPersonService;
import com.zkteco.zkbiosecurity.park.vo.ParkCarNumberItem;
import com.zkteco.zkbiosecurity.park.vo.ParkPersonItem;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ParkCarNumberHandle {
    private static final Logger log = LoggerFactory.getLogger(ParkCarNumberHandle.class);
    @Autowired
    private ParkPersonService parkPersonService;
    @Autowired
    private ParkCarNumberService parkCarNumberService;

    public ZKResultMsg getByAppIdAndPin(ZKMessage msg) {
        log.info("PARK_CLOUD ParkCarNumberHandle getByAppIdAndPin msg = {}", (Object)msg);
        Map retMap = msg.getContent();
        String pin = ParkClientCommonUtil.getStringValue(retMap, "pin");
        ParkCarNumberItem item = new ParkCarNumberItem();
        if (StringUtils.isNotBlank((CharSequence)pin)) {
            ParkPersonItem parkPersonItem = this.parkPersonService.getByPin(pin);
            if (parkPersonItem != null) {
                item.setPersPersonPin(pin);
            } else {
                return new ZKResultMsg(null);
            }
        }
        List list = this.parkCarNumberService.getByCondition(item);
        return new ZKResultMsg((Object)list);
    }
}

