/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.adms.distributor.push.processor;

import com.zkteco.zkbiosecurity.adms.distributor.utils.HttpObjectUtil;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpRequest;
import java.net.InetSocketAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseProcessor {
    protected Logger log = LoggerFactory.getLogger(this.getClass());

    public abstract String handleReqData(ChannelHandlerContext var1, HttpRequest var2, String var3) throws Exception;

    public void printLog(String tag, String content) {
        this.log.debug(tag + "---------" + content);
    }

    protected String getClientIP(ChannelHandlerContext ctx, HttpRequest httpRequest) {
        String clientIP = httpRequest.headers().get("X-Forwarded-For");
        if (clientIP == null) {
            InetSocketAddress insocket = (InetSocketAddress)ctx.channel().remoteAddress();
            clientIP = insocket.getAddress().getHostAddress();
        }
        return clientIP;
    }

    protected int getServerPort(HttpRequest httpRequest) {
        int port = -1;
        String serverHost = httpRequest.headers().get("host");
        if (serverHost != null) {
            port = Integer.parseInt(serverHost.split(":")[1].trim());
        }
        return port;
    }

    protected String getServerHostAddr(HttpRequest httpRequest) {
        String serverHost = httpRequest.headers().get("host");
        if (serverHost != null) {
            return serverHost.split(":")[0].trim();
        }
        return "";
    }

    protected String getContentData(HttpRequest httpRequest, String encoding) {
        HttpContent httpContent = (HttpContent)httpRequest;
        ByteBuf contentByteBuf = httpContent.content();
        contentByteBuf.readableBytes();
        String data = HttpObjectUtil.getHttpContentAsString(contentByteBuf, encoding);
        return data;
    }
}

