/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.core.utils;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import javax.imageio.ImageIO;
import net.coobird.thumbnailator.Thumbnails;
import org.apache.commons.lang3.StringUtils;

public class PicUtil {
    public static String commpressPicForScale(String srcPath, String desPath, long desFileSize, double accuracy, int desMaxWidth, int desMaxHeight) {
        if (StringUtils.isEmpty((CharSequence)srcPath) || StringUtils.isEmpty((CharSequence)srcPath)) {
            return null;
        }
        if (!new File(srcPath).exists()) {
            return null;
        }
        try {
            File srcFile = new File(srcPath);
            long srcFileSize = srcFile.length();
            BufferedImage bim = ImageIO.read(srcFile);
            int srcWidth = bim.getWidth();
            int srcHeight = bim.getHeight();
            Thumbnails.Builder builder = Thumbnails.of((File[])new File[]{srcFile}).outputFormat("jpg");
            if (srcWidth > desMaxWidth || srcHeight > desMaxHeight) {
                builder.size(desMaxWidth, desMaxHeight);
            } else {
                builder.size(srcWidth, srcHeight);
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            builder.toOutputStream((OutputStream)baos);
            byte[] bytes = PicUtil.commpressPicCycle(baos.toByteArray(), desFileSize, accuracy);
            File desFile = new File(desPath);
            FileOutputStream fos = new FileOutputStream(desFile);
            fos.write(bytes);
            fos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return desPath;
    }

    private static byte[] commpressPicCycle(byte[] bytes, long desFileSize, double accuracy) throws IOException {
        long srcFileSizeJPG = bytes.length;
        if (srcFileSizeJPG <= desFileSize * 1024L) {
            return bytes;
        }
        BufferedImage bim = ImageIO.read(new ByteArrayInputStream(bytes));
        int srcWdith = bim.getWidth();
        int srcHeigth = bim.getHeight();
        int desWidth = new BigDecimal(srcWdith).multiply(new BigDecimal(accuracy)).intValue();
        int desHeight = new BigDecimal(srcHeigth).multiply(new BigDecimal(accuracy)).intValue();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Thumbnails.of((InputStream[])new InputStream[]{new ByteArrayInputStream(bytes)}).size(desWidth, desHeight).outputQuality(accuracy).toOutputStream((OutputStream)baos);
        return PicUtil.commpressPicCycle(baos.toByteArray(), desFileSize, accuracy);
    }
}

