/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.core.utils;

import java.util.Locale;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Component;

@Component
public class LocaleMessageSourceUtil {
    @Resource
    private MessageSource messageSource;
    private MessageSource newMessageSource;
    public static String language;

    @Value(value="${system.language:zh_CN}")
    public void setLanguage(String systemLanguage) {
        language = systemLanguage;
    }

    public String getMessage(String code, Object[] args) {
        String txt = this.getMessage(code, args, code);
        if (txt == null || txt.trim().equals("")) {
            return code;
        }
        return txt;
    }

    public String getMessage(String code, Object[] args, String defaultMessage) {
        Locale locale = null;
        if (language.contains("_")) {
            String[] languageCountry = language.split("_");
            locale = new Locale(languageCountry[0], languageCountry[1]);
        } else {
            locale = new Locale(language);
        }
        if (this.newMessageSource == null) {
            this.newMessageSource = this.messageSource;
        }
        return this.newMessageSource.getMessage(code, args, defaultMessage, locale);
    }

    public MessageSource getNewMessageSource() {
        return this.newMessageSource;
    }

    public void setNewMessageSource(MessageSource newMessageSource) {
        this.newMessageSource = newMessageSource;
    }
}

