/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.core.dao;

import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.core.dao.BaseDao;
import com.zkteco.zkbiosecurity.core.dao.ext.AddScalar;
import com.zkteco.zkbiosecurity.core.dao.ext.SqlParser;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.Table;
import org.hibernate.SQLQuery;
import org.hibernate.transform.Transformers;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.data.jpa.repository.support.SimpleJpaRepository;
import org.springframework.util.Assert;

public class BaseDaoImpl<T, ID extends Serializable>
extends SimpleJpaRepository<T, ID>
implements BaseDao<T, ID> {
    private final EntityManager entityManager;

    @Override
    public List<T> findByIdList(Collection<ID> ids) {
        Query query = this.entityManager.createQuery("FROM " + this.getDomainClass().getName() + " t WHERE t.id IN (:ids)");
        query.setParameter("ids", ids);
        return query.getResultList();
    }

    @Override
    public List<T> findByIdList(List<ID> ids) {
        Query query = this.entityManager.createQuery("FROM " + this.getDomainClass().getName() + " t WHERE t.id IN (:ids)");
        query.setParameter("ids", ids);
        return query.getResultList();
    }

    public BaseDaoImpl(Class<T> domainClass, EntityManager entityManager) {
        super(domainClass, entityManager);
        this.entityManager = entityManager;
    }

    @Override
    public List getItemsBySql(Class target, String sql) {
        return this.getItemsDataBySql(target, sql, null, true);
    }

    public List getItemsDataBySql(Class target, String sql, Pager pager, boolean toItem) {
        Assert.notNull((Object)target, (String)"target class is not null");
        SQLQuery sqlQuery = this.createSqlQuery(sql);
        if (toItem) {
            AddScalar.addSclar(sqlQuery, target);
            sqlQuery.setResultTransformer(Transformers.aliasToBean((Class)target));
        }
        if (pager != null) {
            sqlQuery.setFirstResult(pager.getOffset());
            sqlQuery.setMaxResults(pager.getSize());
        }
        return sqlQuery.list();
    }

    @Override
    public List getItemsDataBySql(Class target, String sql, int beginIndex, int endIndex, boolean toItem) {
        Assert.notNull((Object)target, (String)"target class is not null");
        SQLQuery sqlQuery = this.createSqlQuery(sql);
        if (toItem) {
            AddScalar.addSclar(sqlQuery, target);
            sqlQuery.setResultTransformer(Transformers.aliasToBean((Class)target));
        }
        sqlQuery.setFirstResult(beginIndex);
        sqlQuery.setMaxResults(endIndex - beginIndex + 1);
        return sqlQuery.list();
    }

    private SQLQuery createSqlQuery(String sql) {
        Query nativeQuery = this.entityManager.createNativeQuery(sql);
        return (SQLQuery)nativeQuery.unwrap(SQLQuery.class);
    }

    @Override
    public List createSqlQueryPage(String sql, int start, int size) {
        Query nativeQuery = this.entityManager.createNativeQuery(sql);
        nativeQuery.setFirstResult(start);
        nativeQuery.setMaxResults(size);
        return nativeQuery.getResultList();
    }

    private Query createHqlQuery(String hql) {
        Query query = this.entityManager.createQuery(hql);
        return query;
    }

    @Override
    public List<Object[]> getArrayData(String sql) {
        return this.createSqlQuery(sql).list();
    }

    @Override
    public Pager getItemsBySql(Class target, String sql, int page, int size) {
        Pager pager = new Pager(page, size);
        pager.setTotal(this.getCountBySql(sql));
        pager.setData(this.getItemsDataBySql(target, sql, pager, true));
        return pager;
    }

    @Override
    public Pager getArrayItemsBySql(Class target, String sql, int page, int size) {
        Pager pager = new Pager(page, size);
        pager.setTotal(this.getCountBySql(sql));
        pager.setData(this.getItemsDataBySql(target, sql, pager, false));
        return pager;
    }

    @Override
    public Optional<T> findById(ID id) {
        Object t = this.entityManager.find(this.getDomainClass(), id);
        return Optional.ofNullable(t);
    }

    @Override
    public void deleteById(ID id) {
        Assert.notNull(id, (String)"The given id must not be null!");
        Optional<T> optional = this.findById(id);
        if (optional.isPresent()) {
            this.delete(optional.get());
        } else {
            new EmptyResultDataAccessException(String.format("No %s entity with id %s exists!", this.getDomainClass(), id), 1);
        }
    }

    public int getCountBySql(String sql) {
        String countSql = new SqlParser().getSmartCountSql(sql);
        try {
            String countNum = this.createSqlQuery(countSql).uniqueResult().toString();
            int count = Integer.valueOf(countNum);
            return count;
        }
        catch (Exception e) {
            throw new RuntimeException("sql can't be auto count, sql is:" + countSql, e);
        }
    }

    @Override
    public <S extends T> List<S> saveAll(Iterable<S> entities) {
        return this.save(entities);
    }

    public void deleteAll() {
        Query query = this.entityManager.createQuery("DELETE FROM " + this.getDomainClass().getName());
        query.executeUpdate();
    }

    @Override
    public void truncateAll() {
        Query query = this.entityManager.createNativeQuery("TRUNCATE TABLE " + this.getDomainClass().getAnnotation(Table.class).name());
        query.executeUpdate();
    }
}

