/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ins.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;

@From(after="INS_AREA_PERSON t LEFT JOIN INS_PERSON p ON t.PERS_PERSON_ID=p.PERS_PERSON_ID")
@GridConfig(operate=true, idField="id")
@OrderBy(after="t.CREATE_TIME DESC")
public class InsAreaPersonItem
extends BaseItem {
    private static final long serialVersionUID = 1L;
    @Column(name="t.ID")
    @GridColumn(checkbox=true, width="40", sort="na")
    private String id;
    @Column(name="t.AUTH_AREA_ID")
    private String authAreaId;
    @Column(name="t.PERS_PERSON_ID")
    private String personId;
    @Column(name="p.PERS_PERSON_PIN")
    @GridColumn(label="pers_person_pin", width="90", sort="na")
    private String pin;
    @Column(name="p.PERS_PERSON_NAME")
    @GridColumn(label="pers_person_name", width="120", sort="na")
    private String name;
    @Column(name="p.PERS_PERSON_LASTNAME")
    @GridColumn(label="pers_person_lastName", showExpression="#language!='zh_CN'", width="150")
    private String lastName;
    @Column(name="p.AUTH_DEPT_NAME")
    @GridColumn(label="pers_dept_deptName", width="120", sort="na")
    private String deptName;
    @GridColumn(label="base_area_name", width="150", sort="na")
    private String authAreaName;
    private String cardNo;
    @Condition(value="t.AUTH_AREA_ID", equalTag="in")
    private String inAreaId;
    @Condition(value="t.PERS_PERSON_ID", equalTag="in")
    private String inPersPersonId;
    @Condition(value="(lower(p.PERS_PERSON_NAME) LIKE ''%{0}%'' OR lower(p.PERS_PERSON_LASTNAME) LIKE ''%{0}%'')")
    private String likeName;
    @Condition(value="p.AUTH_DEPT_ID", equalTag="in")
    private String inDeptId;

    public InsAreaPersonItem() {
    }

    public InsAreaPersonItem(Boolean equals) {
        super(equals);
    }

    public InsAreaPersonItem(String id) {
        super(Boolean.valueOf(true));
        this.id = id;
    }

    public InsAreaPersonItem(String authAreaId, String personId) {
        this.authAreaId = authAreaId;
        this.personId = personId;
    }

    public InsAreaPersonItem setId(String id) {
        this.id = id;
        return this;
    }

    public InsAreaPersonItem setAuthAreaId(String authAreaId) {
        this.authAreaId = authAreaId;
        return this;
    }

    public InsAreaPersonItem setPersonId(String personId) {
        this.personId = personId;
        return this;
    }

    public InsAreaPersonItem setPin(String pin) {
        this.pin = pin;
        return this;
    }

    public InsAreaPersonItem setName(String name) {
        this.name = name;
        return this;
    }

    public InsAreaPersonItem setLastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    public InsAreaPersonItem setDeptName(String deptName) {
        this.deptName = deptName;
        return this;
    }

    public InsAreaPersonItem setAuthAreaName(String authAreaName) {
        this.authAreaName = authAreaName;
        return this;
    }

    public InsAreaPersonItem setCardNo(String cardNo) {
        this.cardNo = cardNo;
        return this;
    }

    public InsAreaPersonItem setInAreaId(String inAreaId) {
        this.inAreaId = inAreaId;
        return this;
    }

    public InsAreaPersonItem setInPersPersonId(String inPersPersonId) {
        this.inPersPersonId = inPersPersonId;
        return this;
    }

    public InsAreaPersonItem setLikeName(String likeName) {
        this.likeName = likeName;
        return this;
    }

    public InsAreaPersonItem setInDeptId(String inDeptId) {
        this.inDeptId = inDeptId;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public String getAuthAreaId() {
        return this.authAreaId;
    }

    public String getPersonId() {
        return this.personId;
    }

    public String getPin() {
        return this.pin;
    }

    public String getName() {
        return this.name;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getDeptName() {
        return this.deptName;
    }

    public String getAuthAreaName() {
        return this.authAreaName;
    }

    public String getCardNo() {
        return this.cardNo;
    }

    public String getInAreaId() {
        return this.inAreaId;
    }

    public String getInPersPersonId() {
        return this.inPersPersonId;
    }

    public String getLikeName() {
        return this.likeName;
    }

    public String getInDeptId() {
        return this.inDeptId;
    }
}

