/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.cloud.sdk.websocket;

import com.zkteco.cloud.sdk.internal.util.StringUtils;
import com.zkteco.cloud.sdk.internal.util.ZKCloudUtils;
import com.zkteco.cloud.sdk.util.EncrypAESUtil;
import com.zkteco.cloud.sdk.util.SSLClientUtil;
import com.zkteco.cloud.sdk.websocket.FailMessageHandler;
import com.zkteco.cloud.sdk.websocket.MessageHandler;
import com.zkteco.cloud.sdk.websocket.ZKCloudTmcClientHandler;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.net.URI;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZKCloudTmcClient {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String TIMESTAMP = "timestamp";
    private static final String APP_KEY = "app_key";
    private static final String APP_ID = "app_id";
    private static final String GROUP_NAME = "group_name";
    private static final String ACCESS_TOKEN = "access_token";
    private static final String SIGN = "sign";
    private static final String OUT_ID = "out_id";
    private String host;
    private Integer port;
    private String appId;
    private String appKey;
    private String groupName;
    private URI defaultURI;
    private static Channel ch;
    private static EventLoopGroup group;
    private static Bootstrap bootstrap;
    private EventLoop loop;
    private MessageHandler messageHandler;
    private FailMessageHandler failMessageHandler;
    private ZKCloudTmcClientHandler handler;
    private static ChannelFutureListener channelFutureListener;
    public static String connectType;

    public ZKCloudTmcClient(String appId, String appKey) {
        this.appId = appId;
        this.appKey = appKey;
        this.groupName = "default";
    }

    public void addMessageHander(MessageHandler messageHandler) {
        this.messageHandler = messageHandler;
    }

    public void addFailMessageHandler(FailMessageHandler failMessageHandler) {
        this.failMessageHandler = failMessageHandler;
    }

    public void connect(URI uri) {
        if (this.appId == null || this.appKey == null) {
            this.log.error("appId\u6216appKey\u4e3a\u7a7awebsocket\u94fe\u63a5\u5173\u95ed\uff0c\u53ef\u80fd\u4e91\u4e0a\u91cd\u7f6e\u6fc0\u6d3b");
            return;
        }
        this.log.warn("\u68c0\u6d4bchannel\u8fde\u63a5\u670d\u52a1\u5668...ch=" + (ch != null ? ch.id().asLongText() : "false") + " .ch.isActive=" + (ch != null && ch.isActive()) + " isOpen()=" + this.isOpen());
        if (this.isOpen()) {
            this.log.warn("\u94fe\u63a5\u524d\u5c06\u4e4b\u524d\u7684\u901a\u9053\u5173\u95ed\uff0c\u907f\u514d\u591a\u4e2a\u901a\u9053\u62a2\u5360\u8d44\u6e90");
            ch.close();
        }
        try {
            this.defaultURI = uri;
            bootstrap = new Bootstrap();
            final String protocol = uri.getScheme();
            if (!"ws".equals(protocol) && !"wss".equals(protocol)) {
                throw new IllegalArgumentException("Unsupported protocol: " + protocol);
            }
            String url = this.createConnectFullUrl(uri.toString());
            uri = URI.create(url);
            this.host = uri.getHost();
            this.port = uri.getPort();
            if (uri.getPort() == -1 && "wss".equals(protocol)) {
                this.port = 443;
            } else if (uri.getPort() == -1 && "ws".equals(protocol)) {
                this.port = 80;
            }
            this.handler = new ZKCloudTmcClientHandler(WebSocketClientHandshakerFactory.newHandshaker((URI)uri, (WebSocketVersion)WebSocketVersion.V13, null, (boolean)false, (HttpHeaders)EmptyHttpHeaders.INSTANCE, (int)1280000), this.messageHandler, this.failMessageHandler);
            if (group == null || group.isShutdown()) {
                group = new NioEventLoopGroup();
            }
            ((Bootstrap)((Bootstrap)bootstrap.group(group)).channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                public void initChannel(SocketChannel ch) throws Exception {
                    ChannelPipeline pipeline = ch.pipeline();
                    if ("wss".equals(protocol)) {
                        SSLContext sslContext = SSLClientUtil.createSSLContext("JKS", "classpath:zkWssClient.jks", "xmzkteco123");
                        SSLEngine sslEngine = sslContext.createSSLEngine();
                        sslEngine.setUseClientMode(true);
                        pipeline.addLast(new ChannelHandler[]{new SslHandler(sslEngine)});
                    }
                    pipeline.addLast("ping", (ChannelHandler)new IdleStateHandler(50L, 50L, 50L, TimeUnit.SECONDS));
                    pipeline.addLast("http-codec", (ChannelHandler)new HttpClientCodec());
                    pipeline.addLast("aggregator", (ChannelHandler)new HttpObjectAggregator(65536));
                    pipeline.addLast("ws-handler", (ChannelHandler)ZKCloudTmcClient.this.handler);
                }
            });
            bootstrap.option(ChannelOption.SO_KEEPALIVE, (Object)true);
            bootstrap.option(ChannelOption.TCP_NODELAY, (Object)true);
            this.handler.setAppId(this.appId);
            this.handler.setAppKey(this.appKey);
            this.handler.setUri(this.defaultURI);
            this.handler.setZkCloudTmcClient(this);
            if (this.handler.handshakeFuture() != null) {
                this.handler.handshakeFuture().sync();
            }
            this.log.warn("\u91cd\u65b0\u8fde\u63a5\u670d\u52a1\u5668...ch=" + (ch != null ? ch.id().asLongText() : "false") + " .ch.isActive=" + (ch != null && ch.isActive()) + " isOpen()=" + this.isOpen());
            ChannelFuture channelFuture = bootstrap.connect(this.host, this.port.intValue());
            channelFuture.addListener((GenericFutureListener)this.connectFutureListener());
        }
        catch (Exception e) {
            this.log.error(e.getMessage());
        }
    }

    private ChannelFutureListener connectFutureListener() {
        ChannelFutureListener f = new ChannelFutureListener(){

            public void operationComplete(ChannelFuture f) throws Exception {
                if (f.isSuccess()) {
                    ch = f.sync().channel();
                    if ("startConnect".equals(connectType)) {
                        ZKCloudTmcClient.this.log.warn("ConnectionRestListener operationComplete + \u542f\u52a8\u65f6\u8fde\u63a5\u91cd\u8bd5,\u670d\u52a1\u7aef\u94fe\u63a5\u6210\u529f\u5e76\u7b49\u5f85\u662f\u5426\u6b63\u5f0f\u63e1\u624b...");
                    } else if ("running".equals(connectType)) {
                        ZKCloudTmcClient.this.log.warn("ConnectionRestListener operationComplete + \u8fd0\u884c\u4e2d\u8fde\u63a5\u65ad\u5f00\u65f6\u91cd\u8bd5,\u670d\u52a1\u7aef\u94fe\u63a5\u6210\u529f\u5e76\u7b49\u5f85\u662f\u5426\u6b63\u5f0f\u63e1\u624b...");
                    }
                } else {
                    ZKCloudTmcClient.this.log.warn("ConnectionRestListener \u670d\u52a1\u7aef\u94fe\u63a5\u4e0d\u4e0a\uff0c\u5f00\u59cb\u91cd\u8fde\u64cd\u4f5c...\u542f\u52a8\u65f6\u8fde\u63a5\u91cd\u8bd5....");
                    f.channel().eventLoop().schedule(new Runnable(){

                        @Override
                        public void run() {
                            ZKCloudTmcClient.this.log.warn("\u542f\u52a8\u65f6\uff0c\u8fde\u63a5\u4e0d\u4e0a\u670d\u52a1\u5668...\u6b63\u5728\u5c1d\u8bd5\u91cd\u65b0\u8fde");
                            ZKCloudTmcClient.this.connect(ZKCloudTmcClient.this.defaultURI);
                        }
                    }, 5L, TimeUnit.SECONDS);
                }
            }
        };
        return f;
    }

    public void restconnect() {
        this.log.error("restconnect \u91cd\u65b0\u8fde\u63a5\u670d\u52a1\u5668...ch=" + (ch != null) + " .ch.isActive=" + (ch != null && ch.isActive()));
        if (ch != null && ch.isActive()) {
            return;
        }
        ChannelFuture channelFuture = null;
        try {
            channelFuture = bootstrap.connect(this.host, this.port.intValue());
            channelFuture.addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture channelFuture) throws Exception {
                    if (!channelFuture.isSuccess()) {
                        ZKCloudTmcClient.this.loop = channelFuture.channel().eventLoop();
                        ZKCloudTmcClient.this.loop.schedule(new Runnable(){

                            @Override
                            public void run() {
                                ZKCloudTmcClient.this.log.info("ConnectionListener \u670d\u52a1\u7aef\u94fe\u63a5\u4e0d\u4e0a\uff0c\u5f00\u59cb\u91cd\u8fde\u64cd\u4f5c...");
                                ZKCloudTmcClient.this.connect(ZKCloudTmcClient.this.defaultURI);
                            }
                        }, 10L, TimeUnit.SECONDS);
                    } else {
                        ch = channelFuture.sync().channel();
                        ZKCloudTmcClient.this.log.info("ConnectionListener + \u670d\u52a1\u7aef\u94fe\u63a5\u6210\u529f...");
                    }
                }
            });
        }
        catch (Exception e) {
            this.log.error(e.getMessage());
        }
    }

    public void close() throws InterruptedException {
        this.log.info("WebSocket Client sending close");
        ch.writeAndFlush((Object)new CloseWebSocketFrame());
        ch.closeFuture().sync();
        group.shutdownGracefully();
    }

    public void flushAllClient() {
        this.handler = null;
        this.appId = null;
        this.appKey = null;
        ch = null;
        group = null;
        this.loop = null;
        bootstrap = null;
        this.messageHandler = null;
        this.failMessageHandler = null;
        this.messageHandler = null;
    }

    public boolean isOpen() {
        return ch == null ? false : ch.isOpen();
    }

    protected String createConnectFullUrl(String url) throws IOException {
        HashMap<String, String> signHeader = new HashMap<String, String>();
        signHeader.put(TIMESTAMP, String.valueOf(System.currentTimeMillis()));
        signHeader.put(APP_ID, this.appId);
        try {
            String iv = new StringBuilder(this.appId.substring(8, 24)).reverse().toString();
            String tempAppKey = "HMACSHA256$" + EncrypAESUtil.encryptHMACSHA256(this.appKey, iv);
            signHeader.put(APP_KEY, tempAppKey);
        }
        catch (Exception e) {
            this.log.info("FoldexUtil.encrypt error", (Throwable)e);
        }
        signHeader.put("v", "3.0");
        signHeader.put("method", "zkteco.api.websocket.connect");
        signHeader.put(GROUP_NAME, this.groupName);
        signHeader.put("format", "json");
        signHeader.put("sign_method", "hmac");
        signHeader.put(ACCESS_TOKEN, this.getConnectionToken());
        signHeader.put(SIGN, ZKCloudUtils.signTopRequest(signHeader, null, this.appKey, "hmac"));
        String sysOptQuery = ZKCloudTmcClient.buildQuery(signHeader, "UTF-8");
        String fullUrl = ZKCloudTmcClient.buildRequestUrl(url, sysOptQuery);
        return fullUrl;
    }

    public static String buildRequestUrl(String url, String ... queries) {
        if (queries == null || queries.length == 0) {
            return url;
        }
        StringBuilder newUrl = new StringBuilder(url);
        boolean hasQuery = url.contains("?");
        boolean hasPrepend = url.endsWith("?") || url.endsWith("&");
        for (String query : queries) {
            if (StringUtils.isEmpty(query)) continue;
            if (!hasPrepend) {
                if (hasQuery) {
                    newUrl.append("&");
                } else {
                    newUrl.append("?");
                    hasQuery = true;
                }
            }
            newUrl.append(query);
            hasPrepend = false;
        }
        return newUrl.toString();
    }

    public static String buildQuery(Map<String, String> params, String charset) throws IOException {
        if (params == null || params.isEmpty()) {
            return null;
        }
        StringBuilder query = new StringBuilder();
        Set<Map.Entry<String, String>> entries = params.entrySet();
        boolean hasParam = false;
        for (Map.Entry<String, String> entry : entries) {
            String value;
            String name = entry.getKey();
            if (!StringUtils.areNotEmpty(name, value = entry.getValue())) continue;
            if (hasParam) {
                query.append("&");
            } else {
                hasParam = true;
            }
            query.append(name).append("=").append(URLEncoder.encode(value, charset));
        }
        return query.toString();
    }

    public String getConnectionToken() {
        return System.currentTimeMillis() + "";
    }

    public void send(String text) {
        ch.writeAndFlush((Object)new TextWebSocketFrame(text));
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getAppKey() {
        return this.appKey;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    static {
        channelFutureListener = null;
        connectType = "startConnect";
    }
}

