/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.cloud.sdk.internal.util;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class StringUtils {
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final TimeZone TZ_GMT8 = TimeZone.getTimeZone("GMT+8");
    private static final Pattern PATTERN_CIDR = Pattern.compile("^(\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3})/(\\d{1,2})$");
    private static final String QUOT = "&quot;";
    private static final String AMP = "&amp;";
    private static final String APOS = "&apos;";
    private static final String GT = "&gt;";
    private static final String LT = "&lt;";

    private StringUtils() {
    }

    public static boolean isEmpty(String value) {
        int strLen;
        if (value == null || (strLen = value.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(value.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNumeric(Object obj) {
        if (obj == null) {
            return false;
        }
        char[] chars = obj.toString().toCharArray();
        int length = chars.length;
        if (length < 1) {
            return false;
        }
        int i = 0;
        if (length > 1 && chars[0] == '-') {
            i = 1;
        }
        while (i < length) {
            if (!Character.isDigit(chars[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean areNotEmpty(String ... values) {
        boolean result = true;
        if (values == null || values.length == 0) {
            result = false;
        } else {
            for (String value : values) {
                result &= !StringUtils.isEmpty(value);
            }
        }
        return result;
    }

    public static String unicodeToChinese(String unicode) {
        StringBuilder out = new StringBuilder();
        if (!StringUtils.isEmpty(unicode)) {
            for (int i = 0; i < unicode.length(); ++i) {
                out.append(unicode.charAt(i));
            }
        }
        return out.toString();
    }

    public static String toUnderlineStyle(String name) {
        StringBuilder newName = new StringBuilder();
        int len = name.length();
        for (int i = 0; i < len; ++i) {
            char c = name.charAt(i);
            if (Character.isUpperCase(c)) {
                if (i > 0) {
                    newName.append("_");
                }
                newName.append(Character.toLowerCase(c));
                continue;
            }
            newName.append(c);
        }
        return newName.toString();
    }

    public static String toCamelStyle(String name) {
        StringBuilder newName = new StringBuilder();
        int len = name.length();
        for (int i = 0; i < len; ++i) {
            char c = name.charAt(i);
            if (i == 0) {
                newName.append(Character.toLowerCase(c));
                continue;
            }
            newName.append(c);
        }
        return newName.toString();
    }

    public static Date parseDateTime(String str) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        format.setTimeZone(TZ_GMT8);
        try {
            return format.parse(str);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static String formatDateTime(Date date) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        format.setTimeZone(TZ_GMT8);
        return format.format(date);
    }

    public static String formatDateTime(Date date, String pattern) {
        SimpleDateFormat format = new SimpleDateFormat(pattern);
        format.setTimeZone(TZ_GMT8);
        return format.format(date);
    }

    public static String escapeXml(String value) {
        StringBuilder writer = new StringBuilder();
        char[] chars = value.trim().toCharArray();
        block7: for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            switch (c) {
                case '<': {
                    writer.append(LT);
                    continue block7;
                }
                case '>': {
                    writer.append(GT);
                    continue block7;
                }
                case '\'': {
                    writer.append(APOS);
                    continue block7;
                }
                case '&': {
                    writer.append(AMP);
                    continue block7;
                }
                case '\"': {
                    writer.append(QUOT);
                    continue block7;
                }
                default: {
                    if (!(c == '\t' || c == '\n' || c == '\r' || c >= ' ' && c <= '\ud7ff' || c >= '\ue000' && c <= '\ufffd') && (c < '\u10000' || c > '\u10ffff')) continue block7;
                    writer.append(c);
                }
            }
        }
        return writer.toString();
    }

    public static Set<String> getClassProperties(Class<?> clazz, boolean isGet) {
        HashSet<String> propNames = new HashSet<String>();
        try {
            PropertyDescriptor[] props;
            BeanInfo info = Introspector.getBeanInfo(clazz);
            for (PropertyDescriptor prop : props = info.getPropertyDescriptors()) {
                String name = prop.getName();
                Method method = isGet ? prop.getReadMethod() : prop.getWriteMethod();
                if ("class".equals(name) || method == null) continue;
                propNames.add(name);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return propNames;
    }

    public static boolean isDigits(String str) {
        if (StringUtils.isEmpty(str)) {
            return false;
        }
        for (int i = 0; i < str.length(); ++i) {
            if (Character.isDigit(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String[] split(String str, char separatorChar) {
        return StringUtils.splitWorker(str, separatorChar, false);
    }

    private static String[] splitWorker(String str, char separatorChar, boolean preserveAllTokens) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        if (len == 0) {
            return EMPTY_STRING_ARRAY;
        }
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        int start = 0;
        boolean match = false;
        boolean lastMatch = false;
        while (i < len) {
            if (str.charAt(i) == separatorChar) {
                if (match || preserveAllTokens) {
                    list.add(str.substring(start, i));
                    match = false;
                    lastMatch = true;
                }
                start = ++i;
                continue;
            }
            lastMatch = false;
            match = true;
            ++i;
        }
        if (match || preserveAllTokens && lastMatch) {
            list.add(str.substring(start, i));
        }
        return list.toArray(new String[list.size()]);
    }

    private static String[] splitWorker(String str, String separatorChars, int max, boolean preserveAllTokens) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        if (len == 0) {
            return EMPTY_STRING_ARRAY;
        }
        ArrayList<String> list = new ArrayList<String>();
        int sizePlus1 = 1;
        int i = 0;
        int start = 0;
        boolean match = false;
        boolean lastMatch = false;
        if (separatorChars == null) {
            while (i < len) {
                if (Character.isWhitespace(str.charAt(i))) {
                    if (match || preserveAllTokens) {
                        lastMatch = true;
                        if (sizePlus1++ == max) {
                            i = len;
                            lastMatch = false;
                        }
                        list.add(str.substring(start, i));
                        match = false;
                    }
                    start = ++i;
                    continue;
                }
                lastMatch = false;
                match = true;
                ++i;
            }
        } else if (separatorChars.length() == 1) {
            char sep = separatorChars.charAt(0);
            while (i < len) {
                if (str.charAt(i) == sep) {
                    if (match || preserveAllTokens) {
                        lastMatch = true;
                        if (sizePlus1++ == max) {
                            i = len;
                            lastMatch = false;
                        }
                        list.add(str.substring(start, i));
                        match = false;
                    }
                    start = ++i;
                    continue;
                }
                lastMatch = false;
                match = true;
                ++i;
            }
        } else {
            while (i < len) {
                if (separatorChars.indexOf(str.charAt(i)) >= 0) {
                    if (match || preserveAllTokens) {
                        lastMatch = true;
                        if (sizePlus1++ == max) {
                            i = len;
                            lastMatch = false;
                        }
                        list.add(str.substring(start, i));
                        match = false;
                    }
                    start = ++i;
                    continue;
                }
                lastMatch = false;
                match = true;
                ++i;
            }
        }
        if (match || preserveAllTokens && lastMatch) {
            list.add(str.substring(start, i));
        }
        return list.toArray(new String[list.size()]);
    }

    public static String[] split(String str, String separatorChars) {
        return StringUtils.splitWorker(str, separatorChars, -1, false);
    }

    public static boolean isIpInRange(String ipAddr, String cidrAddr) {
        Matcher matcher = PATTERN_CIDR.matcher(cidrAddr);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid CIDR address: " + cidrAddr);
        }
        int[] minIpParts = new int[4];
        int[] maxIpParts = new int[4];
        String[] ipParts = matcher.group(1).split("\\.");
        int intMask = Integer.parseInt(matcher.group(2));
        for (int i = 0; i < ipParts.length; ++i) {
            int ipPart = Integer.parseInt(ipParts[i]);
            if (intMask >= 8) {
                minIpParts[i] = ipPart;
                maxIpParts[i] = ipPart;
                intMask -= 8;
                continue;
            }
            if (intMask > 0) {
                minIpParts[i] = ipPart >> intMask;
                maxIpParts[i] = ipPart | 255 >> intMask;
                intMask = 0;
                continue;
            }
            minIpParts[i] = 1;
            maxIpParts[i] = 254;
        }
        String[] realIpParts = ipAddr.split("\\.");
        for (int i = 0; i < realIpParts.length; ++i) {
            int realIp = Integer.parseInt(realIpParts[i]);
            if (realIp >= minIpParts[i] && realIp <= maxIpParts[i]) continue;
            return false;
        }
        return true;
    }
}

