/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.pers.util;

import com.zkteco.zkbiosecurity.base.annotation.DateType;
import com.zkteco.zkbiosecurity.pers.vo.PersAttributeRuleItem;
import java.lang.reflect.Field;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;

public class PersExportInfoUtil {
    public static Map<String, PersAttributeRuleItem> getPersAttributeRule() {
        LinkedHashMap<String, PersAttributeRuleItem> map = new LinkedHashMap<String, PersAttributeRuleItem>();
        ArrayList<PersAttributeRuleItem> persAttributeRuleItemList = new ArrayList<PersAttributeRuleItem>();
        persAttributeRuleItemList.add(new PersAttributeRuleItem("pin", true, false, false));
        persAttributeRuleItemList.add(new PersAttributeRuleItem("dept.code", false, false, false));
        persAttributeRuleItemList.add(new PersAttributeRuleItem("dept.name", false, false, false));
        persAttributeRuleItemList.add(new PersAttributeRuleItem("validCardNo", false, true, true));
        for (PersAttributeRuleItem persAttributeRuleItem : persAttributeRuleItemList) {
            map.put(persAttributeRuleItem.getName(), persAttributeRuleItem);
        }
        return map;
    }

    public static Object getFieldValue(Object obj, String filedname) throws Exception {
        Class<?> cls = obj.getClass();
        Field field = cls.getDeclaredField(filedname);
        field.setAccessible(true);
        Object val = field.get(obj);
        if ((field.getType() == Date.class || field.getType() == Timestamp.class) && val != null) {
            DateType dateType = field.getAnnotation(DateType.class);
            String format = PersExportInfoUtil.getDateFormt(dateType);
            val = new SimpleDateFormat(format).format(val);
        }
        return val;
    }

    public static String getDateFormt(DateType dateType) {
        String format = "yyyy-MM-dd HH:mm:ss";
        if (dateType != null) {
            switch (dateType.type()) {
                case "date": {
                    format = "yyyy-MM-dd";
                    break;
                }
                case "time": {
                    format = "HH:mm:ss";
                    break;
                }
                case "timestamp": {
                    format = "yyyy-MM-dd HH:mm:ss";
                }
            }
        }
        return format;
    }
}

