/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.pers.controller;

import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.pers.remote.PersTempRegRemote;
import com.zkteco.zkbiosecurity.pers.service.PerTempRegService;
import com.zkteco.zkbiosecurity.pers.service.PersParamsService;
import com.zkteco.zkbiosecurity.pers.vo.PerTempRegItem;
import java.util.Arrays;
import java.util.stream.Collectors;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PersTempRegController
extends BaseController
implements PersTempRegRemote {
    @Value(value="${system.language}")
    private String sysLanguage;
    @Autowired
    private PerTempRegService perRegSerice;
    @Autowired
    private PersParamsService persParamsService;

    public ZKResultMsg registrarLogin(@RequestBody PerTempRegItem item) {
        item.setPhone(item.getPhone().replaceAll("/[^\\d-]/g", ""));
        ZKResultMsg retMsg = new ZKResultMsg();
        this.perRegSerice.perReg(item);
        return I18nUtil.i18nMsg((ZKResultMsg)retMsg);
    }

    public ModelAndView regView() {
        String enableHealthInfo = this.persParamsService.getValByName("pers.enableHealthInfo");
        String exposure = this.request.getParameter("exposure");
        String[] symptom = this.request.getParameterValues("symptom");
        String visitCity = this.request.getParameter("visitCity");
        String healthRemarks = this.request.getParameter("healthRemarks");
        if ("1".equals(enableHealthInfo) && StringUtils.isBlank((CharSequence)exposure) && StringUtils.isBlank((CharSequence)visitCity) && (symptom == null || symptom.length == 0)) {
            ModelAndView mv = new ModelAndView("pers/tempPerson/persTempHealth");
            mv.addObject("language", (Object)this.sysLanguage);
            return mv;
        }
        String symptomStr = symptom != null ? Arrays.stream(symptom).collect(Collectors.joining(",")) : null;
        String pinLen = this.persParamsService.getValByName("pers.pinLen");
        String pinSupportLetter = this.persParamsService.getValByName("pers.pinSupportLetter");
        ModelAndView mv = new ModelAndView("pers/tempPerson/persTempReg");
        mv.addObject("language", (Object)this.sysLanguage);
        mv.addObject("pinLen", (Object)pinLen);
        mv.addObject("pinSupportLetter", (Object)pinSupportLetter);
        mv.addObject("enableHealthInfo", (Object)enableHealthInfo);
        mv.addObject("exposure", (Object)exposure);
        mv.addObject("symptom", (Object)symptomStr);
        mv.addObject("visitCity", (Object)visitCity);
        mv.addObject("healthRemarks", (Object)healthRemarks);
        return mv;
    }

    protected String getCookie(String name, HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(name)) continue;
                return cookie.getValue();
            }
        }
        return null;
    }
}

