/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.att.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.GroupBy;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import java.util.Date;
import java.util.UUID;

@From(after="ATT_RECORD t ")
@GroupBy(after="t.PERS_PERSON_PIN")
@OrderBy(after="t.PERS_PERSON_PIN DESC")
@GridConfig(operate=false, idField="id", winHeight=400, winWidth=600)
public class AttYearStatisticalReportItem
extends BaseItem {
    private static final long serialVersionUID = 1L;
    @GridColumn(show=false)
    private String id = UUID.randomUUID().toString();
    @Column(name="t.PERS_PERSON_PIN")
    @GridColumn(label="att_common_person", secHeader="att_common_pin")
    private String pin;
    @GridColumn(label="#cspan", secHeader="att_person_name")
    private String name;
    @GridColumn(label="#cspan", secHeader="att_person_lastName", showExpression="#language!='zh_CN'")
    private String lastName;
    @GridColumn(show=false)
    private String deptId;
    @GridColumn(label="att_common_dept", secHeader="common_number")
    private String deptCode;
    @GridColumn(label="#cspan", secHeader="common_name")
    private String deptName;
    @Column(name="(COALESCE(SUM(t.SHOULD_MINUTE),0))")
    @GridColumn(label="att_statistical_attendance_hour", secHeader="att_statistical_should")
    private String shouldHour;
    @Column(name="(COALESCE(SUM(t.ACTUAL_MINUTE),0))")
    @GridColumn(label="#cspan", secHeader="att_statistical_actual")
    private String actualHour;
    @Column(name="(COALESCE(SUM(t.VALID_MINUTE),0))")
    @GridColumn(label="#cspan", secHeader="att_statistical_valid")
    private String validHour;
    @Column(name="(COALESCE(SUM(t.SHOULD_DAYS),0))")
    @GridColumn(label="att_statistical_attendance_day", secHeader="att_statistical_should")
    private String shouldDay;
    @Column(name="(COALESCE(SUM(t.ACTUAL_DAYS),0))")
    @GridColumn(label="#cspan", secHeader="att_statistical_actual")
    private String actualDay;
    @Column(name="(COALESCE(SUM(t.VALID_DAYS),0))")
    @GridColumn(label="#cspan", secHeader="att_statistical_valid")
    private String validDay;
    @Column(name="(COALESCE(SUM(t.LATE_MINUTE_TOTAL),0))")
    @GridColumn(label="att_common_late", secHeader="att_statistical_late_minute")
    private String lateMinute;
    @Column(name="(COALESCE(SUM(t.LATE_COUNT_TOTAL),0))")
    @GridColumn(label="#cspan", secHeader="att_statistical_numberOfTimes")
    private String lateCountTotal;
    @Column(name="(COALESCE(SUM(t.EARLY_MINUTE_TOTAL),0))")
    @GridColumn(label="att_common_early", secHeader="att_statistical_early_minute")
    private String earlyMinute;
    @Column(name="(COALESCE(SUM(t.EARLY_COUNT_TOTAL),0))")
    @GridColumn(label="#cspan", secHeader="att_statistical_numberOfTimes")
    private String earlyCount;
    @Column(name="(COALESCE(SUM(t.OVERTIME_USUAL_MINUTE),0))")
    @GridColumn(label="att_statistical_overtime_hour", secHeader="att_statistical_usually")
    private String overtimeUsualHour;
    @Column(name="(COALESCE(SUM(t.OVERTIME_REST_MINUTE),0))")
    @GridColumn(label="#cspan", secHeader="att_statistical_rest")
    private String overtimeRestHour;
    @Column(name="(COALESCE(SUM(t.OVERTIME_HOLIDAY_MINUTE),0))")
    @GridColumn(label="#cspan", secHeader="att_statistical_holiday")
    private String overtimeHolidayHour;
    @Column(name="(COALESCE(SUM(t.OVERTIME_MINUTE),0))")
    @GridColumn(label="#cspan", secHeader="att_statistical_total")
    private String overtimeHour;
    @Column(name="(COALESCE(SUM(t.ABSENT_MINUTE),0))")
    @GridColumn(label="att_statistical_unusual_hour", secHeader="att_common_absent")
    private String absentHour;
    @Column(name="(COALESCE(SUM(t.LEAVE_MINUTE),0))")
    @GridColumn(label="#cspan", secHeader="att_common_leave")
    private String leaveHour;
    @Column(name="(COALESCE(SUM(t.TRIP_MINUTE),0))")
    @GridColumn(label="#cspan", secHeader="att_common_trip")
    private String tripHour;
    @Column(name="(COALESCE(SUM(t.OUT_MINUTE),0))")
    @GridColumn(label="#cspan", secHeader="att_common_out")
    private String outHour;
    @Column(name="(COALESCE(SUM(t.ABSENT_DAYS),0))")
    @GridColumn(label="att_statistical_unusual_day", secHeader="att_common_absent")
    private String absentDay;
    @Column(name="(COALESCE(SUM(t.LEAVE_DAYS),0))")
    @GridColumn(label="#cspan", secHeader="att_common_leave")
    private String leaveDay;
    @Column(name="(COALESCE(SUM(t.TRIP_DAYS),0))")
    @GridColumn(label="#cspan", secHeader="att_common_trip")
    private String tripDay;
    @Column(name="(COALESCE(SUM(t.OUT_DAYS),0))")
    @GridColumn(label="#cspan", secHeader="att_common_out")
    private String outDay;
    private String searchYear;
    @Condition(value="t.ATT_DATE", equalTag=">=")
    private Date yearStart;
    @Condition(value="t.ATT_DATE", equalTag="<=")
    private Date yearEnd;
    @Condition(value="t.AUTH_DEPT_ID", equalTag="in")
    private String inDeptId;
    private String likeName;
    @Condition(value="t.PERS_PERSON_PIN", equalTag="in")
    private String inPersonPin;

    public AttYearStatisticalReportItem setId(String id) {
        this.id = id;
        return this;
    }

    public AttYearStatisticalReportItem setPin(String pin) {
        this.pin = pin;
        return this;
    }

    public AttYearStatisticalReportItem setName(String name) {
        this.name = name;
        return this;
    }

    public AttYearStatisticalReportItem setLastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    public AttYearStatisticalReportItem setDeptId(String deptId) {
        this.deptId = deptId;
        return this;
    }

    public AttYearStatisticalReportItem setDeptCode(String deptCode) {
        this.deptCode = deptCode;
        return this;
    }

    public AttYearStatisticalReportItem setDeptName(String deptName) {
        this.deptName = deptName;
        return this;
    }

    public AttYearStatisticalReportItem setShouldHour(String shouldHour) {
        this.shouldHour = shouldHour;
        return this;
    }

    public AttYearStatisticalReportItem setActualHour(String actualHour) {
        this.actualHour = actualHour;
        return this;
    }

    public AttYearStatisticalReportItem setValidHour(String validHour) {
        this.validHour = validHour;
        return this;
    }

    public AttYearStatisticalReportItem setShouldDay(String shouldDay) {
        this.shouldDay = shouldDay;
        return this;
    }

    public AttYearStatisticalReportItem setActualDay(String actualDay) {
        this.actualDay = actualDay;
        return this;
    }

    public AttYearStatisticalReportItem setValidDay(String validDay) {
        this.validDay = validDay;
        return this;
    }

    public AttYearStatisticalReportItem setLateMinute(String lateMinute) {
        this.lateMinute = lateMinute;
        return this;
    }

    public AttYearStatisticalReportItem setLateCountTotal(String lateCountTotal) {
        this.lateCountTotal = lateCountTotal;
        return this;
    }

    public AttYearStatisticalReportItem setEarlyMinute(String earlyMinute) {
        this.earlyMinute = earlyMinute;
        return this;
    }

    public AttYearStatisticalReportItem setEarlyCount(String earlyCount) {
        this.earlyCount = earlyCount;
        return this;
    }

    public AttYearStatisticalReportItem setOvertimeUsualHour(String overtimeUsualHour) {
        this.overtimeUsualHour = overtimeUsualHour;
        return this;
    }

    public AttYearStatisticalReportItem setOvertimeRestHour(String overtimeRestHour) {
        this.overtimeRestHour = overtimeRestHour;
        return this;
    }

    public AttYearStatisticalReportItem setOvertimeHolidayHour(String overtimeHolidayHour) {
        this.overtimeHolidayHour = overtimeHolidayHour;
        return this;
    }

    public AttYearStatisticalReportItem setOvertimeHour(String overtimeHour) {
        this.overtimeHour = overtimeHour;
        return this;
    }

    public AttYearStatisticalReportItem setAbsentHour(String absentHour) {
        this.absentHour = absentHour;
        return this;
    }

    public AttYearStatisticalReportItem setLeaveHour(String leaveHour) {
        this.leaveHour = leaveHour;
        return this;
    }

    public AttYearStatisticalReportItem setTripHour(String tripHour) {
        this.tripHour = tripHour;
        return this;
    }

    public AttYearStatisticalReportItem setOutHour(String outHour) {
        this.outHour = outHour;
        return this;
    }

    public AttYearStatisticalReportItem setAbsentDay(String absentDay) {
        this.absentDay = absentDay;
        return this;
    }

    public AttYearStatisticalReportItem setLeaveDay(String leaveDay) {
        this.leaveDay = leaveDay;
        return this;
    }

    public AttYearStatisticalReportItem setTripDay(String tripDay) {
        this.tripDay = tripDay;
        return this;
    }

    public AttYearStatisticalReportItem setOutDay(String outDay) {
        this.outDay = outDay;
        return this;
    }

    public AttYearStatisticalReportItem setSearchYear(String searchYear) {
        this.searchYear = searchYear;
        return this;
    }

    public AttYearStatisticalReportItem setYearStart(Date yearStart) {
        this.yearStart = yearStart;
        return this;
    }

    public AttYearStatisticalReportItem setYearEnd(Date yearEnd) {
        this.yearEnd = yearEnd;
        return this;
    }

    public AttYearStatisticalReportItem setInDeptId(String inDeptId) {
        this.inDeptId = inDeptId;
        return this;
    }

    public AttYearStatisticalReportItem setLikeName(String likeName) {
        this.likeName = likeName;
        return this;
    }

    public AttYearStatisticalReportItem setInPersonPin(String inPersonPin) {
        this.inPersonPin = inPersonPin;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public String getPin() {
        return this.pin;
    }

    public String getName() {
        return this.name;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getDeptId() {
        return this.deptId;
    }

    public String getDeptCode() {
        return this.deptCode;
    }

    public String getDeptName() {
        return this.deptName;
    }

    public String getShouldHour() {
        return this.shouldHour;
    }

    public String getActualHour() {
        return this.actualHour;
    }

    public String getValidHour() {
        return this.validHour;
    }

    public String getShouldDay() {
        return this.shouldDay;
    }

    public String getActualDay() {
        return this.actualDay;
    }

    public String getValidDay() {
        return this.validDay;
    }

    public String getLateMinute() {
        return this.lateMinute;
    }

    public String getLateCountTotal() {
        return this.lateCountTotal;
    }

    public String getEarlyMinute() {
        return this.earlyMinute;
    }

    public String getEarlyCount() {
        return this.earlyCount;
    }

    public String getOvertimeUsualHour() {
        return this.overtimeUsualHour;
    }

    public String getOvertimeRestHour() {
        return this.overtimeRestHour;
    }

    public String getOvertimeHolidayHour() {
        return this.overtimeHolidayHour;
    }

    public String getOvertimeHour() {
        return this.overtimeHour;
    }

    public String getAbsentHour() {
        return this.absentHour;
    }

    public String getLeaveHour() {
        return this.leaveHour;
    }

    public String getTripHour() {
        return this.tripHour;
    }

    public String getOutHour() {
        return this.outHour;
    }

    public String getAbsentDay() {
        return this.absentDay;
    }

    public String getLeaveDay() {
        return this.leaveDay;
    }

    public String getTripDay() {
        return this.tripDay;
    }

    public String getOutDay() {
        return this.outDay;
    }

    public String getSearchYear() {
        return this.searchYear;
    }

    public Date getYearStart() {
        return this.yearStart;
    }

    public Date getYearEnd() {
        return this.yearEnd;
    }

    public String getInDeptId() {
        return this.inDeptId;
    }

    public String getLikeName() {
        return this.likeName;
    }

    public String getInPersonPin() {
        return this.inPersonPin;
    }
}

