/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.att.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;

@From(after="ATT_AREA_PERSON t LEFT JOIN ATT_PERSON p ON t.PERS_PERSON_ID=p.PERS_PERSON_ID")
@GridConfig(operate=true, idField="id")
@OrderBy(after="t.CREATE_TIME DESC")
public class AttAreaPersonItem
extends BaseItem {
    private static final long serialVersionUID = 1L;
    @Column(name="t.ID")
    @GridColumn(checkbox=true, width="40", sort="na")
    private String id;
    @Column(name="p.PERS_PERSON_PIN")
    @GridColumn(label="att_person_pin", width="150", sort="na")
    private String pin;
    @Column(name="p.PERS_PERSON_NAME")
    @GridColumn(label="att_person_name", width="150", sort="na")
    private String name;
    @Column(name="p.PERS_PERSON_LASTNAME")
    @GridColumn(label="att_person_lastName", showExpression="#language!='zh_CN'", width="150")
    private String lastName;
    @Column(name="p.AUTH_DEPT_ID")
    private String deptId;
    @Column(name="p.AUTH_DEPT_CODE")
    private String deptCode;
    @Column(name="p.AUTH_DEPT_NAME")
    @GridColumn(label="pers_dept_deptName", width="150", sort="na")
    private String deptName;
    private String authAreaName;
    private String authAreaNo;
    private String cardNo;
    private String bioTemplateCount;
    @Column(name="t.AUTH_AREA_ID")
    private String areaId;
    @Column(name="t.PERS_PERSON_ID")
    private String personId;
    @Condition(value="t.PERS_PERSON_ID", equalTag="in")
    private String inPersPersonId;
    @Condition(value="t.AUTH_AREA_ID", equalTag="in")
    private String inAreaId;
    @Condition(value="p.AUTH_DEPT_ID", equalTag="in")
    private String inDeptId;
    @Condition(value="(lower(p.PERS_PERSON_NAME) LIKE ''%{0}%'' OR lower(p.PERS_PERSON_LASTNAME) LIKE ''%{0}%'')")
    private String likeName;

    public AttAreaPersonItem() {
    }

    public AttAreaPersonItem(Boolean equals) {
        super(equals);
    }

    public AttAreaPersonItem(String id) {
        super(Boolean.valueOf(true));
        this.id = id;
    }

    public AttAreaPersonItem setId(String id) {
        this.id = id;
        return this;
    }

    public AttAreaPersonItem setPin(String pin) {
        this.pin = pin;
        return this;
    }

    public AttAreaPersonItem setName(String name) {
        this.name = name;
        return this;
    }

    public AttAreaPersonItem setLastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    public AttAreaPersonItem setDeptId(String deptId) {
        this.deptId = deptId;
        return this;
    }

    public AttAreaPersonItem setDeptCode(String deptCode) {
        this.deptCode = deptCode;
        return this;
    }

    public AttAreaPersonItem setDeptName(String deptName) {
        this.deptName = deptName;
        return this;
    }

    public AttAreaPersonItem setAuthAreaName(String authAreaName) {
        this.authAreaName = authAreaName;
        return this;
    }

    public AttAreaPersonItem setAuthAreaNo(String authAreaNo) {
        this.authAreaNo = authAreaNo;
        return this;
    }

    public AttAreaPersonItem setCardNo(String cardNo) {
        this.cardNo = cardNo;
        return this;
    }

    public AttAreaPersonItem setBioTemplateCount(String bioTemplateCount) {
        this.bioTemplateCount = bioTemplateCount;
        return this;
    }

    public AttAreaPersonItem setAreaId(String areaId) {
        this.areaId = areaId;
        return this;
    }

    public AttAreaPersonItem setPersonId(String personId) {
        this.personId = personId;
        return this;
    }

    public AttAreaPersonItem setInPersPersonId(String inPersPersonId) {
        this.inPersPersonId = inPersPersonId;
        return this;
    }

    public AttAreaPersonItem setInAreaId(String inAreaId) {
        this.inAreaId = inAreaId;
        return this;
    }

    public AttAreaPersonItem setInDeptId(String inDeptId) {
        this.inDeptId = inDeptId;
        return this;
    }

    public AttAreaPersonItem setLikeName(String likeName) {
        this.likeName = likeName;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public String getPin() {
        return this.pin;
    }

    public String getName() {
        return this.name;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getDeptId() {
        return this.deptId;
    }

    public String getDeptCode() {
        return this.deptCode;
    }

    public String getDeptName() {
        return this.deptName;
    }

    public String getAuthAreaName() {
        return this.authAreaName;
    }

    public String getAuthAreaNo() {
        return this.authAreaNo;
    }

    public String getCardNo() {
        return this.cardNo;
    }

    public String getBioTemplateCount() {
        return this.bioTemplateCount;
    }

    public String getAreaId() {
        return this.areaId;
    }

    public String getPersonId() {
        return this.personId;
    }

    public String getInPersPersonId() {
        return this.inPersPersonId;
    }

    public String getInAreaId() {
        return this.inAreaId;
    }

    public String getInDeptId() {
        return this.inDeptId;
    }

    public String getLikeName() {
        return this.likeName;
    }
}

