/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.att.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.zkteco.zkbiosecurity.core.utils.DateUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AttDateUtils {
    private static final Logger logger = LoggerFactory.getLogger(AttDateUtils.class);
    @Deprecated
    public static SimpleDateFormat sdfDatetimeyMdHms = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    @Deprecated
    public static SimpleDateFormat sdfDateyMd = new SimpleDateFormat("yyyy-MM-dd");

    public static Date getMaxEndDate() {
        Calendar instance = Calendar.getInstance();
        instance.set(3000, 0, 0, 0, 0, 0);
        return instance.getTime();
    }

    @Deprecated
    public static Date parse(SimpleDateFormat sdf, String source) {
        Date date = null;
        try {
            date = sdf.parse(source);
        }
        catch (ParseException e) {
            logger.error("String parase Date error", (Throwable)e);
        }
        return date;
    }

    public static Date getFirstDayOfYear(int year) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(1, year);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date getLastDayOfYear(int year) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(1, year);
        calendar.roll(6, -1);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return calendar.getTime();
    }

    public static Date getFirstDayOfMonth(int year, int month) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(1, year);
        calendar.set(2, month - 1);
        int minDays = calendar.getMinimum(5);
        calendar.set(5, minDays);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date getLastDayOfMonth(int year, int month) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(1, year);
        calendar.set(2, month - 1);
        int maxDays = calendar.getActualMaximum(5);
        calendar.set(5, maxDays);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return calendar.getTime();
    }

    public static int getMaxDaysOfMonth(int year, int month) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(1, year);
        calendar.set(2, month - 1);
        return calendar.getActualMaximum(5);
    }

    public static int getDayOfWeek(int year, int month, int day) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(1, year);
        calendar.set(2, month - 1);
        calendar.set(5, day);
        return calendar.get(7);
    }

    public static Date getMinOfDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date getMinOfDay(String dateStr) {
        Date date = DateUtil.stringToDate((String)dateStr, (DateUtil.DateStyle)DateUtil.DateStyle.YYYY_MM_DD_HH_MM_SS);
        return AttDateUtils.getMinOfDay(date);
    }

    public static Date getMaxOfDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return calendar.getTime();
    }

    public static Date getMaxOfDay(String dateStr) {
        Date date = DateUtil.stringToDate((String)dateStr, (DateUtil.DateStyle)DateUtil.DateStyle.YYYY_MM_DD_HH_MM_SS);
        return AttDateUtils.getMaxOfDay(date);
    }

    public static Date getLastMonDayOfDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(3, -1);
        calendar.set(7, 2);
        return calendar.getTime();
    }

    public static Date getLastSunDayOfDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(3, 0);
        calendar.set(7, 1);
        return calendar.getTime();
    }

    public static Date getLastMonthOfFirstDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, -1);
        calendar.set(5, 1);
        return calendar.getTime();
    }

    public static Date getLastMonthOfLastDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, -1);
        calendar.set(5, calendar.getActualMaximum(5));
        return calendar.getTime();
    }

    public static Date getNextMonthOfFirstDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, 1);
        calendar.set(5, 1);
        return calendar.getTime();
    }

    public static Date getNextMonthOfLastDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, 1);
        calendar.set(5, calendar.getActualMaximum(5));
        return calendar.getTime();
    }

    public static Date getLastMonthOfDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(2, -1);
        return calendar.getTime();
    }

    public static Date getMonthOfFirstDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, 0);
        calendar.set(5, 1);
        return calendar.getTime();
    }

    public static Date getMonthOfLastDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, 0);
        calendar.set(5, calendar.getActualMaximum(5));
        return calendar.getTime();
    }

    public static int getDayOfWeek(Long dateLong) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(dateLong);
        int dayOfYear = cal.get(7);
        return dayOfYear;
    }

    public static int getDayOfMonth(Long dateLong) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(dateLong);
        int dayOfMonth = cal.get(5);
        return dayOfMonth;
    }

    public static int getWeekOfYear(Long dateLong) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(dateLong);
        int weekOfYear = cal.get(3);
        return weekOfYear;
    }

    public static int getMonth(Long startDateLong, Long endDateLong) {
        int monthday = 0;
        Calendar starCal = Calendar.getInstance();
        starCal.setTimeInMillis(startDateLong);
        int sYear = starCal.get(1);
        int sMonth = starCal.get(2);
        Calendar endCal = Calendar.getInstance();
        endCal.setTimeInMillis(endDateLong);
        int eYear = endCal.get(1);
        int eMonth = endCal.get(2);
        monthday = (eYear - sYear) * 12 + (eMonth - sMonth);
        return monthday;
    }

    public static String getBeforeDay(String today) {
        Date date = DateUtil.stringToDate((String)today, (DateUtil.DateStyle)DateUtil.DateStyle.YYYY_MM_DD);
        return DateUtil.dateToString((Date)DateUtil.addDay((Date)date, (int)-1), (DateUtil.DateStyle)DateUtil.DateStyle.YYYY_MM_DD);
    }

    public static String getNextDay(String today) {
        Date date = DateUtil.stringToDate((String)today, (DateUtil.DateStyle)DateUtil.DateStyle.YYYY_MM_DD);
        return DateUtil.dateToString((Date)DateUtil.addDay((Date)date, (int)1), (DateUtil.DateStyle)DateUtil.DateStyle.YYYY_MM_DD);
    }

    public static String getWeekOfDate(Date dt) {
        String[] weekDays = new String[]{"0", "1", "2", "3", "4", "5", "6"};
        Calendar cal = Calendar.getInstance();
        cal.setTime(dt);
        int w = cal.get(7) - 1;
        if (w < 0) {
            w = 0;
        }
        return weekDays[w];
    }

    public static int getLackCardCount(String cardValue, Map<String, String> attRule) {
        String[] cardTime;
        int lackCount = 0;
        String noSignIn = attRule.get("att.other.noSignIn");
        String noSignOff = attRule.get("att.other.noSignOff");
        if (StringUtils.isNotBlank((CharSequence)cardValue) && (cardTime = cardValue.split(";")).length > 0) {
            for (String timeSlot : cardTime) {
                String startWork = timeSlot.split("-", 2)[0];
                String endWork = timeSlot.split("-", 2)[1];
                if (noSignIn.equals(startWork)) {
                    ++lackCount;
                }
                if (!noSignOff.equals(endWork)) continue;
                ++lackCount;
            }
        }
        return lackCount;
    }

    public static <T> List<T> convertToList(Object object, Class<T> clazz) {
        try {
            String jsonStr = JSON.toJSONString((Object)object);
            List list = JSONArray.parseArray((String)jsonStr, clazz);
            return list;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static int getTimeSeconds(String time) {
        String[] timeArray = time.split(":");
        if (timeArray.length != 2) {
            return 0;
        }
        return Integer.parseInt(timeArray[0]) * 60 + Integer.parseInt(timeArray[1]);
    }

    public static int getMinuteDiff(String startTime, String endTime) {
        int minutes = 0;
        try {
            Date startDate = DateUtil.stringToDate((String)startTime, (DateUtil.DateStyle)DateUtil.DateStyle.YYYY_MM_DD_HH_MM);
            Date endDate = DateUtil.stringToDate((String)endTime, (DateUtil.DateStyle)DateUtil.DateStyle.YYYY_MM_DD_HH_MM);
            minutes = AttDateUtils.getMinuteDiff(startDate, endDate);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return minutes;
    }

    public static int getMinuteDiff(Date startDate, Date endDate) {
        int minutes = 0;
        try {
            long diff = endDate.getTime() - startDate.getTime();
            minutes = (int)(diff / 60000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return minutes;
    }

    public static int getIntersectionTime(String s1, String e1, String s2, String e2) {
        if (StringUtils.compare((String)e1, (String)s2) < 0 || StringUtils.compare((String)s1, (String)e2) > 0) {
            return 0;
        }
        ArrayList<String> dateTimeList = new ArrayList<String>(Arrays.asList(s1, e1, s2, e2));
        Collections.sort(dateTimeList);
        int diffTime = AttDateUtils.getMinuteDiff((String)dateTimeList.get(1), (String)dateTimeList.get(2));
        return diffTime;
    }

    public static String addMinute(String dateTime, int minutes) {
        Date date1 = DateUtil.stringToDate((String)dateTime, (DateUtil.DateStyle)DateUtil.DateStyle.YYYY_MM_DD_HH_MM_SS);
        Date date2 = DateUtil.addMinute((Date)date1, (int)minutes);
        String result = DateUtil.dateToString((Date)date2, (DateUtil.DateStyle)DateUtil.DateStyle.YYYY_MM_DD_HH_MM_SS);
        return result;
    }

    public static String judgeExceptionTime(String exceptionTime, String startTime, String endTime, boolean isStartTime, Boolean interDay) {
        if (!exceptionTime.equals(startTime) && !exceptionTime.equals(endTime)) {
            int exceptionMinute = AttDateUtils.calcTimeMinute(exceptionTime);
            int shiftStartMinute = AttDateUtils.calcTimeMinute(startTime);
            int shiftEndMinute = AttDateUtils.calcTimeMinute(endTime);
            if (interDay != false ? shiftStartMinute < exceptionMinute || exceptionMinute < shiftEndMinute : shiftStartMinute < exceptionMinute && exceptionMinute < shiftEndMinute) {
                return exceptionTime;
            }
        }
        return isStartTime ? startTime : endTime;
    }

    public static int calcTimeMinute(String time) {
        if (time != null && time.contains(":")) {
            String[] timeArr = time.split(":", 2);
            return Integer.parseInt(timeArr[0]) * 60 + Integer.parseInt(timeArr[1]);
        }
        return 0;
    }

    public static Date getFirstDayWithMonthsAgo(Date curDate, int monthAmount) {
        Date newDate = DateUtil.addMonth((Date)curDate, (int)monthAmount);
        Date firstDate = AttDateUtils.getMonthOfFirstDay(newDate);
        return firstDate;
    }

    public static String dateToStrAsLong(Date date) {
        return DateUtil.dateToString((Date)date, (DateUtil.DateStyle)DateUtil.DateStyle.YYYY_MM_DD_HH_MM_SS);
    }

    public static String dateToStrAsShort(Date date) {
        return DateUtil.dateToString((Date)date, (DateUtil.DateStyle)DateUtil.DateStyle.YYYY_MM_DD);
    }

    public static String dateToStrAsMedium(Date date) {
        return DateUtil.dateToString((Date)date, (DateUtil.DateStyle)DateUtil.DateStyle.YYYY_MM_DD_HH_MM);
    }

    public static Date stringToYmdDate(String dateStr) {
        return DateUtil.stringToDate((String)dateStr, (DateUtil.DateStyle)DateUtil.DateStyle.YYYY_MM_DD);
    }

    public static LocalDateTime date2LocalDateTime(Date date) {
        Instant instant = date.toInstant();
        ZoneId zoneId = ZoneId.systemDefault();
        LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, zoneId);
        return localDateTime;
    }

    public static int diffDays(Date startDate, Date endDate) {
        Duration duration = Duration.between(AttDateUtils.date2LocalDateTime(startDate), AttDateUtils.date2LocalDateTime(endDate));
        return Long.valueOf(duration.toDays()).intValue();
    }

    public static Date getEndDate(Date begin, Date end) {
        return AttDateUtils.diffDays(begin, end) > 60 ? DateUtil.addDay((Date)begin, (int)60) : end;
    }

    public static String getEndDate(String begin, String end) {
        Date endDate = AttDateUtils.getEndDate(DateUtil.stringToDate((String)begin, (DateUtil.DateStyle)DateUtil.DateStyle.YYYY_MM_DD), DateUtil.stringToDate((String)end, (DateUtil.DateStyle)DateUtil.DateStyle.YYYY_MM_DD));
        return DateUtil.dateToString((Date)endDate, (DateUtil.DateStyle)DateUtil.DateStyle.YYYY_MM_DD);
    }

    public static List<String> getBetweenDate(String begin, String end) {
        ArrayList<String> betweenList = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)begin) && StringUtils.isNotBlank((CharSequence)end)) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            try {
                String newend;
                Calendar startDay = Calendar.getInstance();
                startDay.setTime(format.parse(begin));
                startDay.add(5, -1);
                do {
                    startDay.add(5, 1);
                    Date newDate = startDay.getTime();
                    newend = format.format(newDate);
                    betweenList.add(newend);
                } while (!end.equals(newend));
            }
            catch (Exception var7) {
                var7.printStackTrace();
            }
        }
        return betweenList;
    }

    public static void forEachDay(Date startDate, Date endDate, Consumer<? super Date> action) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(startDate);
        while (calendar.getTime().compareTo(endDate) <= 0) {
            Date date = calendar.getTime();
            action.accept(date);
            calendar.add(6, 1);
        }
    }
}

