/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.auth.model;

import com.zkteco.zkbiosecurity.auth.model.AuthArea;
import com.zkteco.zkbiosecurity.auth.model.AuthBioTemplate;
import com.zkteco.zkbiosecurity.auth.model.AuthDepartment;
import com.zkteco.zkbiosecurity.auth.model.AuthRole;
import com.zkteco.zkbiosecurity.core.model.BaseModel;
import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;
import javax.persistence.Table;

@Entity
@Table(name="AUTH_USER", indexes={@Index(name="AUTH_USER_CRT_IDX", columnList="CREATE_TIME"), @Index(name="AUTH_USER_UPT_IDX", columnList="UPDATE_TIME")})
public class AuthUser
extends BaseModel
implements Serializable {
    private static final long serialVersionUID = -2863701046693039413L;
    @Column(name="USERNAME", length=30, unique=true)
    private String username;
    @Column(name="LOGIN_PWD", length=128)
    private String loginPwd;
    @Column(name="PWD_CREATE_TIME")
    private Date pwdCreateTime;
    @Column(name="USER_LOGIN_LIMIT")
    private Integer userLoginLimit;
    @Column(name="NAME", length=50)
    private String name;
    @Column(name="LAST_NAME", length=50)
    private String lastName;
    @Column(name="EMAIL", length=100)
    private String email;
    @Column(name="PHONE", length=100)
    private String phone;
    @Column(name="IS_STAFF")
    private Boolean isStaff;
    @Column(name="IS_ACTIVE")
    private Boolean isActive;
    @Column(name="IS_SUPERUSER")
    private Boolean isSuperuser;
    @Column(name="INIT_FLAG")
    private Boolean initFlag;
    @Column(name="USER_TYPE", length=2)
    private String userType;
    @Column(name="SALT", length=50)
    private String salt;
    @Column(name="PWD_INIT_FLAG", length=10)
    private String pwdInitFlag;
    @ManyToMany(targetEntity=AuthRole.class, fetch=FetchType.LAZY)
    @JoinTable(name="AUTH_USER_ROLE", joinColumns={@JoinColumn(name="AUTH_USER_ID", referencedColumnName="ID")}, inverseJoinColumns={@JoinColumn(name="AUTH_ROLE_ID", referencedColumnName="ID")})
    private Set<AuthRole> roles = new HashSet<AuthRole>();
    @ManyToMany(targetEntity=AuthArea.class, fetch=FetchType.LAZY)
    @JoinTable(name="AUTH_USER_AREA", joinColumns={@JoinColumn(name="AUTH_USER_ID", referencedColumnName="ID")}, inverseJoinColumns={@JoinColumn(name="AUTH_AREA_ID", referencedColumnName="ID")})
    private Set<AuthArea> areas = new HashSet<AuthArea>();
    @ManyToMany(targetEntity=AuthDepartment.class, fetch=FetchType.LAZY)
    @JoinTable(name="AUTH_USER_DEPT", joinColumns={@JoinColumn(name="AUTH_USER_ID", referencedColumnName="ID")}, inverseJoinColumns={@JoinColumn(name="AUTH_DEPT_ID", referencedColumnName="ID")})
    private Set<AuthDepartment> departments = new HashSet<AuthDepartment>();
    @OneToMany(mappedBy="authUser", cascade={CascadeType.REMOVE})
    private Set<AuthBioTemplate> authBioTemplateSet = new HashSet<AuthBioTemplate>();

    public AuthUser() {
    }

    public AuthUser(String username, String loginPwd) {
        this.username = username;
        this.loginPwd = loginPwd;
    }

    public String getUsername() {
        return this.username;
    }

    public String getLoginPwd() {
        return this.loginPwd;
    }

    public Date getPwdCreateTime() {
        return this.pwdCreateTime;
    }

    public Integer getUserLoginLimit() {
        return this.userLoginLimit;
    }

    public String getName() {
        return this.name;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getEmail() {
        return this.email;
    }

    public String getPhone() {
        return this.phone;
    }

    public Boolean getIsStaff() {
        return this.isStaff;
    }

    public Boolean getIsActive() {
        return this.isActive;
    }

    public Boolean getIsSuperuser() {
        return this.isSuperuser;
    }

    public Boolean getInitFlag() {
        return this.initFlag;
    }

    public String getUserType() {
        return this.userType;
    }

    public String getSalt() {
        return this.salt;
    }

    public String getPwdInitFlag() {
        return this.pwdInitFlag;
    }

    public Set<AuthRole> getRoles() {
        return this.roles;
    }

    public Set<AuthArea> getAreas() {
        return this.areas;
    }

    public Set<AuthDepartment> getDepartments() {
        return this.departments;
    }

    public Set<AuthBioTemplate> getAuthBioTemplateSet() {
        return this.authBioTemplateSet;
    }

    public AuthUser setUsername(String username) {
        this.username = username;
        return this;
    }

    public AuthUser setLoginPwd(String loginPwd) {
        this.loginPwd = loginPwd;
        return this;
    }

    public AuthUser setPwdCreateTime(Date pwdCreateTime) {
        this.pwdCreateTime = pwdCreateTime;
        return this;
    }

    public AuthUser setUserLoginLimit(Integer userLoginLimit) {
        this.userLoginLimit = userLoginLimit;
        return this;
    }

    public AuthUser setName(String name) {
        this.name = name;
        return this;
    }

    public AuthUser setLastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    public AuthUser setEmail(String email) {
        this.email = email;
        return this;
    }

    public AuthUser setPhone(String phone) {
        this.phone = phone;
        return this;
    }

    public AuthUser setIsStaff(Boolean isStaff) {
        this.isStaff = isStaff;
        return this;
    }

    public AuthUser setIsActive(Boolean isActive) {
        this.isActive = isActive;
        return this;
    }

    public AuthUser setIsSuperuser(Boolean isSuperuser) {
        this.isSuperuser = isSuperuser;
        return this;
    }

    public AuthUser setInitFlag(Boolean initFlag) {
        this.initFlag = initFlag;
        return this;
    }

    public AuthUser setUserType(String userType) {
        this.userType = userType;
        return this;
    }

    public AuthUser setSalt(String salt) {
        this.salt = salt;
        return this;
    }

    public AuthUser setPwdInitFlag(String pwdInitFlag) {
        this.pwdInitFlag = pwdInitFlag;
        return this;
    }

    public AuthUser setRoles(Set<AuthRole> roles) {
        this.roles = roles;
        return this;
    }

    public AuthUser setAreas(Set<AuthArea> areas) {
        this.areas = areas;
        return this;
    }

    public AuthUser setDepartments(Set<AuthDepartment> departments) {
        this.departments = departments;
        return this;
    }

    public AuthUser setAuthBioTemplateSet(Set<AuthBioTemplate> authBioTemplateSet) {
        this.authBioTemplateSet = authBioTemplateSet;
        return this;
    }
}

