/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.att.controller;

import com.zkteco.zkbiosecurity.att.remote.AttTimingRemote;
import com.zkteco.zkbiosecurity.att.service.AttTimingService;
import com.zkteco.zkbiosecurity.att.vo.AttTimingItem;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AttTimingController
extends BaseController
implements AttTimingRemote {
    @Autowired
    private AttTimingService attTimingService;

    @RequiresPermissions(value={"att:timing"})
    public ModelAndView index() {
        return new ModelAndView("att/timing/attTiming");
    }

    @RequiresPermissions(value={"att:timing:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.attTimingService.getItemById(id));
        }
        return new ModelAndView("att/timing/editAttTiming");
    }

    @RequiresPermissions(value={"att:timing:edit"})
    @LogRequest(module="att_module", object="att_leftMenu_timingCalculation", opType="common_op_edit", requestParams={"calcFrequency"}, opContent="att_timingcalc_timeCalcFrequency")
    public ZKResultMsg save(String calcFrequency, AttTimingItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.attTimingService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"att:timing:refresh"})
    public DxGrid list(AttTimingItem condition) {
        Pager pager = this.attTimingService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"att:timing:del"})
    @LogRequest(module="att_module", object="att_leftMenu_timingCalculation", opType="common_op_del", requestParams={"timeCalcInterval"}, opContent="att_timingcalc_timeCalcInterval")
    public ZKResultMsg delete(String ids) {
        List<String> idsAry = Arrays.asList(ids.split(","));
        List attTimingList = this.attTimingService.getItemByCalcFrequencyAndIdNotIn("0", idsAry);
        if (attTimingList == null || attTimingList.size() < 1) {
            throw new ZKBusinessException("400", "att_timingcalc_optionTip");
        }
        this.attTimingService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"att:timing:enable"})
    @LogRequest(module="att_module", object="att_leftMenu_timingCalculation", opType="common_enable", requestParams={"timeCalcInterval"}, opContent="att_timingcalc_timeCalcInterval")
    public ZKResultMsg enable(String ids) {
        this.attTimingService.enable(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"att:timing:disable"})
    @LogRequest(module="att_module", object="att_leftMenu_timingCalculation", opType="common_disable", requestParams={"timeCalcInterval"}, opContent="att_timingcalc_timeCalcInterval")
    public ZKResultMsg disable(String ids) {
        List<String> idsAry = Arrays.asList(ids.split(","));
        List attTimingList = this.attTimingService.getItemByCalcFrequencyAndIdNotIn("0", idsAry);
        if (attTimingList == null || attTimingList.size() < 1) {
            throw new ZKBusinessException("400", "att_timingcalc_optionTip");
        }
        this.attTimingService.disable(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public ZKResultMsg isExist(String timeCalcFrequency, String timeCalcInterval) {
        AttTimingItem item = this.attTimingService.getItemByCalcFrequencyAndCalcInterval(timeCalcFrequency, timeCalcInterval);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg((Object)(item != null ? 1 : 0)));
    }
}

