/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.att.controller;

import com.zkteco.zkbiosecurity.att.remote.AttDeptStatisticalReportRemote;
import com.zkteco.zkbiosecurity.att.service.AttDeptStatisticalReportService;
import com.zkteco.zkbiosecurity.att.service.AttRecordService;
import com.zkteco.zkbiosecurity.att.vo.AttDeptStatisticalReportItem;
import com.zkteco.zkbiosecurity.auth.service.AuthDepartmentService;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AttDeptStatisticalReportController
extends ExportController
implements AttDeptStatisticalReportRemote {
    @Autowired
    private AttDeptStatisticalReportService attDeptStatisticalReportService;
    @Autowired
    private AttRecordService attRecordService;
    @Autowired(required=false)
    private AuthDepartmentService authDepartmentService;

    @RequiresPermissions(value={"att:deptStatistiCalReport"})
    public ModelAndView index() {
        return new ModelAndView("att/report/attDeptStatistical");
    }

    @RequiresPermissions(value={"att:deptStatistiCalReport:refresh"})
    public DxGrid list(AttDeptStatisticalReportItem condition) {
        Pager pager = this.attDeptStatisticalReportService.loadPagerByAuthUserFilter(this.request.getSession().getId(), (BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"att:deptStatistiCalReport:export"})
    @LogRequest(module="att_module", object="att_leftMenu_deptStatisticalReport", opType="common_op_export", requestParams={"exportType"}, opContent="common_report_fileType")
    public void export(HttpServletRequest request, HttpServletResponse response) {
        AttDeptStatisticalReportItem attDeptStatisticalReportItem = new AttDeptStatisticalReportItem();
        this.setConditionValue((BaseItem)attDeptStatisticalReportItem);
        this.addCondition(request.getSession().getId(), attDeptStatisticalReportItem);
        List itemList = this.attRecordService.getDeptStatisticalReportItemData(AttDeptStatisticalReportItem.class, (BaseItem)attDeptStatisticalReportItem, this.getBeginIndex(), this.getEndIndex());
        this.excelExport(itemList, AttDeptStatisticalReportItem.class);
    }

    private void addCondition(String sessionId, AttDeptStatisticalReportItem condition) {
        if (StringUtils.isBlank((CharSequence)condition.getInDeptId())) {
            condition.setInDeptId(this.authDepartmentService.getDeptIdsByIdAndCodeAndName(sessionId, condition.getDeptId(), condition.getDeptCode(), condition.getDeptName()));
            condition.setDeptId(null);
        } else if (StringUtils.isNotBlank((CharSequence)sessionId)) {
            condition.setInDeptId(this.authDepartmentService.getDeptIdsByAuthAndIds(sessionId, condition.getInDeptId()));
            condition.setDeptId(null);
        }
    }
}

