/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.dll;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;

public class ResourceUtil {
    private static final Logger logger = LoggerFactory.getLogger(ResourceUtil.class);
    private static ResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();

    public static Resource[] loadResources(String locationPattern) {
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        try {
            Resource[] resources = resolver.getResources("classpath*:" + locationPattern);
            return resources;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Resource loadResourcesOne(String locationPattern) {
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        try {
            Resource[] resources = resolver.getResources("classpath*:" + locationPattern);
            if (resources != null && resources.length > 0) {
                return resources[0];
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    public static List<InputStream> loadResourcesAsInputStream(String locationPattern) {
        Resource[] resources;
        ArrayList<InputStream> xmlInputStreamList = new ArrayList<InputStream>();
        for (Resource resource : resources = ResourceUtil.loadResources(locationPattern)) {
            try {
                xmlInputStreamList.add(resource.getInputStream());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return xmlInputStreamList;
    }

    public static InputStream loadResourcesOneAsInputStream(String locationPattern) {
        Resource resource = ResourceUtil.loadResourcesOne(locationPattern);
        if (resource != null) {
            try {
                return resource.getInputStream();
            }
            catch (IOException e) {
                logger.error("exception\uff1a", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public static Resource getResource(String location) {
        Resource resource = resolver.getResource(location);
        return resource;
    }

    public static Resource[] getResources(String locationPattern) throws IOException {
        if (!locationPattern.startsWith("classpath*:")) {
            locationPattern = "classpath*:" + locationPattern;
        }
        return resolver.getResources(locationPattern);
    }
}

